/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.parts;

import com.ibm.cic.common.ui.parts.SharedPart;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class SharedPartWithButtons
extends SharedPart {
    private final String[] buttonLabels;
    private Control[] controls;
    private Composite buttonContainer;
    protected int buttonsOrientation = 512;

    public SharedPartWithButtons(String[] buttonLabels) {
        this.buttonLabels = buttonLabels;
    }

    public void setButtonEnabled(int index, boolean enabled) {
        Control c;
        if (this.controls != null && index >= 0 && this.controls.length > index && (c = this.controls[index]) instanceof Button) {
            c.setEnabled(enabled);
        }
    }

    public void setButtonVisible(int index, boolean visible) {
        Control c;
        if (this.controls != null && index >= 0 && this.controls.length > index && (c = this.controls[index]) instanceof Button) {
            c.setVisible(visible);
        }
    }

    public void setButtonTooltip(int index, String tooltip) {
        Control c;
        if (this.controls != null && index >= 0 && this.controls.length > index && (c = this.controls[index]) instanceof Button) {
            c.setToolTipText(tooltip);
        }
    }

    public void setButtonsOrientation(int orientation) {
        this.buttonsOrientation = orientation;
    }

    protected abstract void createMainControl(Composite var1, int var2, int var3, FormToolkit var4);

    protected abstract void buttonSelected(Button var1, int var2);

    @Override
    public void createControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.createMainLabel(parent, span, toolkit);
        int mainSpan = span;
        if (this.buttonsOrientation == 512 && this.buttonLabels != null && this.buttonLabels.length > 0) {
            mainSpan = span - 1;
        }
        this.createMainControl(parent, style, mainSpan, toolkit);
        this.createButtons(parent, toolkit);
    }

    protected void createButtons(Composite parent, FormToolkit toolkit) {
        if (this.buttonLabels != null && this.buttonLabels.length > 0) {
            this.buttonContainer = this.createComposite(parent, toolkit);
            GridData gd = null;
            gd = this.buttonsOrientation == 512 ? new GridData(4, 1, false, false) : new GridData(3, 1, true, false);
            this.buttonContainer.setLayoutData((Object)gd);
            this.buttonContainer.setLayout((Layout)this.createButtonsLayout());
            this.controls = new Control[this.buttonLabels.length];
            SelectionHandler listener = new SelectionHandler();
            int i = 0;
            while (i < this.buttonLabels.length) {
                String label = this.buttonLabels[i];
                if (label != null) {
                    Button button = this.createButton(this.buttonContainer, label, i, toolkit);
                    button.addSelectionListener((SelectionListener)listener);
                    this.controls[i] = button;
                } else {
                    this.createEmptySpace(this.buttonContainer, 1, toolkit);
                }
                ++i;
            }
        }
    }

    protected GridLayout createButtonsLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        if (this.buttonsOrientation != 512) {
            layout.numColumns = this.buttonLabels.length;
        }
        return layout;
    }

    protected Button createButton(Composite parent, String label, int index, FormToolkit toolkit) {
        Button button;
        if (toolkit != null) {
            button = toolkit.createButton(parent, label, 8);
        } else {
            button = new Button(parent, 8);
            button.setText(label);
        }
        GridData gd = null;
        gd = this.buttonsOrientation == 512 ? new GridData(770) : new GridData(128);
        button.setLayoutData((Object)gd);
        button.setData((Object)index);
        return button;
    }

    @Override
    protected void updateEnabledState() {
        Control[] controlArray = this.controls;
        int n = this.controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Button) {
                c.setEnabled(this.isEnabled());
            }
            ++n2;
        }
    }

    protected void createMainLabel(Composite parent, int span, FormToolkit toolkit) {
    }

    private class SelectionHandler
    implements SelectionListener {
        private SelectionHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.buttonSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.buttonSelected(e);
        }

        private void buttonSelected(SelectionEvent e) {
            Integer index = (Integer)e.widget.getData();
            SharedPartWithButtons.this.buttonSelected((Button)e.widget, index);
        }
    }
}

