/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.iwm.internal.ui;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.IAgentEventManager;
import com.ibm.cic.agent.core.IAgentObserverRegistrar;
import com.ibm.cic.agent.internal.core.notify.Utils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.iwm.internal.model.IwmRepository;
import com.ibm.cic.common.core.iwm.internal.model.MultipleChoiceQuestion;
import com.ibm.cic.common.core.iwm.internal.util.IwmUtils;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.ui.services.IStyledText;
import com.ibm.cic.common.ui.services.UiServices;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ENurturePage
extends AbstractAgentUIWizardPage
implements IAgentEventManager.AgentJobListener,
CommonDef {
    private transient AgentJob[] jobs = null;
    private transient IAgentObserverRegistrar agentRegistrar = null;
    private transient Map urlToNurtureDataMap = new HashMap();
    private transient List nurturedOfferingsList = new LinkedList();
    private transient LinkedHashMap repositoryOfferingsMap = new LinkedHashMap();
    private transient Map otherRadioAndTextMap = new HashMap();
    private static final String RESPONSE_TAG_BEGIN = "<response ";
    private static final String RESPONSE_TAG_SOURCE_ATTR = "source=\"";
    private static final String RESPONSE_TAG_BEGIN_END = ">";
    private static final String RESPONSE_TAG_END = "</response>";
    private static final String MCQ_TAG_BEGIN = "<mcq name=\"";
    private static final String MCQ_TAG_BEGIN_END = "\">";
    private static final String MCQ_TAG_END = "</mcq>";
    private static final String OFFERING_NAME_TAG_BEGIN = "<offeringName><![CDATA[";
    private static final String OFFERING_NAME_TAG_END = "]]></offeringName>";
    private static final String OFFERING_VERSION_TAG_BEGIN = "<offeringVersion><![CDATA[";
    private static final String OFFERING_VERSION_TAG_END = "]]></offeringVersion>";
    private static final String QUESTION_TAG_BEGIN = "<question><![CDATA[";
    private static final String QUESTION_TAG_END = "]]></question>";
    private static final String ANSWER_TAG_BEGIN = "<answer><![CDATA[";
    private static final String ANSWER_TAG_END = "]]></answer>";

    public ENurturePage(FormToolkit toolkit, AgentUIWizard wizard) {
        super(toolkit, Messages.ENurturePage_PageTitle, Messages.ENurturePage_PageDescription, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.ENurturePage");
    }

    public IStatus performFinish(IProgressMonitor monitor) {
        this.cleanup();
        return Status.OK_STATUS;
    }

    @Override
    public void createControl(Composite parent) {
        Group form = new Group(parent, 4);
        form.setLayout((Layout)new GridLayout());
        form.setLayoutData((Object)new GridData(768));
        this.setControl((Control)form);
        HashSet<String> sources = new HashSet<String>();
        AgentJob[] agentJobArray = this.jobs;
        int n = this.jobs.length;
        int n2 = 0;
        while (n2 < n) {
            List questionsForSource;
            String source;
            AgentJob job = agentJobArray[n2];
            IOffering offering = job.getOffering();
            if (offering != null && (source = this.getSource(offering)) != null && !sources.contains(source) && !(questionsForSource = this.getQuestionsForSource(source)).isEmpty()) {
                this.createQuestions(offering, questionsForSource, (Composite)form, sources.size() > 0);
                sources.add(source);
            }
            ++n2;
        }
        this.updateMessage();
        sources.clear();
    }

    private void createQuestions(IOffering offering, List questionsForSource, Composite parent, boolean needVerticalIndent) {
        if (offering == null) {
            return;
        }
        this.createTitle(offering, parent, needVerticalIndent);
        int i = 0;
        while (i < questionsForSource.size()) {
            MultipleChoiceQuestion mcq = (MultipleChoiceQuestion)questionsForSource.get(i);
            mcq.setOffering(offering);
            IStyledText question = UiServices.getInstance().createStyledText(parent, 64);
            question.setText(String.valueOf(i + 1) + ". " + mcq.getQuestion().getDisplayText());
            UiServices.getInstance().setStyleRange(question, 1, question.getText().length());
            GridData gd = new GridData(768);
            gd.horizontalIndent = 20;
            gd.verticalIndent = 15;
            question.setLayoutData((Object)gd);
            this.createMcqUi(parent, mcq);
            ++i;
        }
    }

    private void createMcqUi(Composite parent, MultipleChoiceQuestion mcq) {
        Composite comp = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginRight = 20;
        comp.setLayout((Layout)layout);
        GridData gd1 = new GridData(768);
        comp.setLayoutData((Object)gd1);
        List answers = mcq.getAnswers();
        int j = 0;
        while (j < answers.size()) {
            GridData answerGd;
            MultipleChoiceQuestion.LocaleSupport ls = (MultipleChoiceQuestion.LocaleSupport)answers.get(j);
            if (ls.getMcq() == null) {
                answerGd = new GridData(4);
                answerGd.horizontalIndent = 30;
                answerGd.horizontalSpan = 2;
            } else {
                answerGd = new GridData();
                answerGd.horizontalIndent = 30;
            }
            Button answer = mcq.getType() == 0 ? new Button(comp, 16) : new Button(comp, 32);
            answer.setText(ls.getDisplayText());
            answer.setData((Object)mcq);
            answer.setLayoutData((Object)answerGd);
            answer.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.getSource();
                    MultipleChoiceQuestion q = (MultipleChoiceQuestion)button.getData();
                    int k = 0;
                    while (k < q.getAnswers().size()) {
                        MultipleChoiceQuestion.LocaleSupport support = (MultipleChoiceQuestion.LocaleSupport)q.getAnswers().get(k);
                        if (support.getDisplayText().equals(button.getText())) {
                            if (button.getSelection()) {
                                if ((button.getStyle() & 0x10) > 0) {
                                    q.resetSelection();
                                }
                                q.addAnswer(k);
                                Text text = (Text)ENurturePage.this.otherRadioAndTextMap.get(button);
                                if (text == null) break;
                                text.setEditable(true);
                                text.setFocus();
                                break;
                            }
                            q.resetSelection(k);
                            Text text = (Text)ENurturePage.this.otherRadioAndTextMap.get(button);
                            if (text == null) break;
                            text.setEditable(false);
                            break;
                        }
                        ++k;
                    }
                    ENurturePage.this.updateMessage();
                    ENurturePage.this.getContainer().updateButtons();
                }
            });
            if (ls.getMcq() != null && ls.getMcq().getType() == 2) {
                mcq = ls.getMcq();
                ls = (MultipleChoiceQuestion.LocaleSupport)ls.getMcq().getAnswers().get(0);
                Text text = new Text(comp, 2052);
                text.setText(ls.getDisplayText());
                text.setData((Object)new TextQuestion(mcq));
                text.setEditable(false);
                GridData gd = new GridData(768);
                text.setLayoutData((Object)gd);
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent ev) {
                        ENurturePage.this.updateOtherText((TypedEvent)ev);
                    }
                });
                text.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent ev) {
                        Text w = (Text)ev.getSource();
                        w.selectAll();
                        ENurturePage.this.updateMessage();
                        ENurturePage.this.getContainer().updateButtons();
                    }

                    public void focusLost(FocusEvent ev) {
                        ENurturePage.this.updateOtherText((TypedEvent)ev);
                    }
                });
                this.otherRadioAndTextMap.put(answer, text);
            }
            ++j;
        }
    }

    private void updateOtherText(TypedEvent ev) {
        Text w = (Text)ev.getSource();
        TextQuestion q = (TextQuestion)w.getData();
        q.mcq.setText(w.getText().trim());
        this.updateMessage();
        this.getContainer().updateButtons();
    }

    private void createTitle(IOffering offering, Composite parent, boolean needVerticalIndent) {
        String msg = NLS.bind((String)Messages.ENurturePage_QuestionForOfferingTitle, (Object)offering.getName());
        IStyledText titleForOffering = UiServices.getInstance().createStyledText(parent, 64);
        titleForOffering.setText(msg);
        UiServices.getInstance().setStyleRange(titleForOffering, 1, msg.length());
        titleForOffering.setEditable(false);
        if (needVerticalIndent) {
            GridData gd = new GridData(4);
            gd.verticalIndent = 30;
            titleForOffering.setLayoutData((Object)gd);
        }
    }

    private List getQuestionsForSource(String source) {
        for (NurtureData data : this.urlToNurtureDataMap.values()) {
            if (!data.sources.contains(source)) continue;
            List list = (List)data.mcqs.get(source);
            if (list == null) {
                return Collections.EMPTY_LIST;
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    private String getSource(IOffering offering) {
        IwmRepository repository = ENurturePage.getIwmRepository(offering);
        if (repository == null) {
            return null;
        }
        if (this.isServedFromSiteRepository(offering)) {
            return null;
        }
        return repository.getOfferingSourceId();
    }

    void updateMessage() {
        boolean foundQuestion = false;
        Iterator iterator = this.urlToNurtureDataMap.keySet().iterator();
        while (iterator.hasNext()) {
            NurtureData data = (NurtureData)this.urlToNurtureDataMap.get(iterator.next());
            Iterator itor = data.mcqs.keySet().iterator();
            while (itor.hasNext()) {
                List list = (List)data.mcqs.get(itor.next());
                int i = 0;
                while (i < list.size()) {
                    foundQuestion = true;
                    MultipleChoiceQuestion mcq = (MultipleChoiceQuestion)list.get(i);
                    if (!mcq.isAnswered()) {
                        String msg = NLS.bind((String)Messages.ENurturePage_QuestionNotAnsweredError, (Object)(i + 1), (Object)mcq.getOffering().getName());
                        this.setMessage(msg, 3);
                        return;
                    }
                    ++i;
                }
            }
        }
        if (!foundQuestion) {
            this.setMessage(Messages.ENurturePage_QuestionsNotAvailable, 3);
            return;
        }
        this.setMessage("");
    }

    public void init(IAdaptable adaptable) {
        Object obj = adaptable.getAdapter(AgentJob[].class);
        if (obj != null) {
            this.jobs = (AgentJob[])obj;
        }
        if ((obj = adaptable.getAdapter(IAgentObserverRegistrar.class)) != null) {
            this.agentRegistrar = (IAgentObserverRegistrar)obj;
        }
    }

    public void dispose() {
        super.dispose();
        this.cleanup();
    }

    private void cleanup() {
        this.jobs = null;
        this.otherRadioAndTextMap.clear();
        this.nurturedOfferingsList.clear();
        this.repositoryOfferingsMap.clear();
        this.urlToNurtureDataMap.clear();
        if (this.agentRegistrar != null) {
            this.agentRegistrar.removeInstallOfferingOrFixListener((IAgentEventManager.AgentJobListener)this);
        }
    }

    public boolean canAddPageToWizard() {
        boolean flag = this.isNurturingRequired();
        if (flag) {
            this.compileNurturingQuestions();
            this.agentRegistrar.addInstallOfferingOrFixListener((IAgentEventManager.AgentJobListener)this);
        }
        return flag;
    }

    private void compileNurturingQuestions() {
        List repositories = this.getRepositoryList();
        int i = 0;
        while (i < repositories.size()) {
            IwmRepository repo = (IwmRepository)repositories.get(i);
            String source = repo.getOfferingSourceId();
            if (source != null && (source = source.trim()).length() > 0) {
                String nurturingQuestionsUrl = repo.getNurturingQuestionsUrl();
                NurtureData nurtureData = (NurtureData)this.urlToNurtureDataMap.get(nurturingQuestionsUrl);
                if (nurtureData == null) {
                    nurtureData = new NurtureData();
                    this.urlToNurtureDataMap.put(nurturingQuestionsUrl, nurtureData);
                }
                nurtureData.sources.add(source);
            }
            ++i;
        }
        for (Map.Entry entry : this.urlToNurtureDataMap.entrySet()) {
            String url = (String)entry.getKey();
            NurtureData nurtureData = (NurtureData)entry.getValue();
            nurtureData.mcqs = IwmUtils.fetchNurtureQuestions((String)url, (List)nurtureData.sources);
        }
    }

    private List getRepositoryList() {
        LinkedList list = new LinkedList();
        Iterator itor = this.repositoryOfferingsMap.keySet().iterator();
        while (itor.hasNext()) {
            list.add(itor.next());
        }
        return list;
    }

    private boolean isNurturingRequired() {
        this.populateIwmRepositoryMap();
        if (this.repositoryOfferingsMap.size() == 0) {
            return false;
        }
        for (List list : this.repositoryOfferingsMap.values()) {
            if (list.isEmpty()) continue;
            int i = 0;
            while (i < list.size()) {
                IOffering offering = (IOffering)list.get(i);
                if (!this.nurturedOfferingsList.contains(offering.getName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void populateIwmRepositoryMap() {
        AgentJob[] agentJobArray = this.jobs;
        int n = this.jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOffering offering = job.getOffering();
            if (offering != null) {
                IwmRepository repository = ENurturePage.getIwmRepository(offering);
                if (!this.isServedFromSiteRepository(offering) && repository != null) {
                    this.addToRepositoryOfferingsMap((IRepository)repository, offering);
                }
            }
            ++n2;
        }
    }

    private boolean isServedFromSiteRepository(IOffering offering) {
        IRepository repository = this.getOfferingSourceRepository(offering);
        return CommonDef.Urls.EntitledRepositoryUrl.equals(repository.getRepositoryInfo().getLocationStr());
    }

    private IRepository getOfferingSourceRepository(IOffering offering) {
        Iterator iterator = AgentUI.getDefault().getAgent().getRepositoryGroup().getRepositories().iterator();
        NullProgressMonitor monitor = new NullProgressMonitor();
        while (iterator.hasNext()) {
            IRepository repository = (IRepository)iterator.next();
            if (!(UpdateOfferingUtils.isUpdate((IContent)offering) ? repository.findUpdate(offering.getIdentity(), offering.getVersion(), (IProgressMonitor)monitor) != null : repository.findOffering(offering.getIdentity(), offering.getVersion(), (IProgressMonitor)monitor) != null)) continue;
            return repository;
        }
        return null;
    }

    private void addToRepositoryOfferingsMap(IRepository repository, IOffering offering) {
        LinkedList<IOffering> list = (LinkedList<IOffering>)this.repositoryOfferingsMap.get(repository);
        if (list == null) {
            list = new LinkedList<IOffering>();
            this.repositoryOfferingsMap.put(repository, list);
        }
        if (!list.contains(offering)) {
            list.add(offering);
        }
    }

    public boolean isPageComplete() {
        return this.getMessageType() == 0 && "".equals(this.getMessage());
    }

    public IStatus beforeInstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
        String url;
        IwmRepository repository;
        IOffering offering = event.getAgentJob().getOffering();
        if (offering != null && (repository = ENurturePage.getIwmRepository(offering)) != null && (url = repository.getNotifyNurtureAnswersUrl()) != null) {
            String source = repository.getOfferingSourceId();
            Iterator iterator = this.urlToNurtureDataMap.keySet().iterator();
            while (iterator.hasNext()) {
                NurtureData data = (NurtureData)this.urlToNurtureDataMap.get(iterator.next());
                if (!data.sources.contains(source)) continue;
                FileUtil.delete((File)IwmUtils.sendMessage((String)url, (String)this.createResponse(source, (List)data.mcqs.get(source))));
            }
        }
        return Status.OK_STATUS;
    }

    private String createResponse(String source, List mcqs) {
        StringBuffer buf = new StringBuffer();
        this.createResponseBegin(buf, source);
        this.createNurutreAnswersResponse(buf, source, mcqs);
        buf.append(RESPONSE_TAG_END);
        return buf.toString();
    }

    private void createResponseBegin(StringBuffer buf, String source) {
        Properties properties = Utils.getIwmMessageProperties();
        buf.append(RESPONSE_TAG_BEGIN).append(RESPONSE_TAG_SOURCE_ATTR).append(source).append("\"");
        for (String string : properties.keySet()) {
            buf.append(" ").append(string).append("=").append("\"").append(properties.getProperty(string)).append("\"").append(CommonDef.EOL);
        }
        buf.append(RESPONSE_TAG_BEGIN_END).append(CommonDef.EOL);
    }

    private void createNurutreAnswersResponse(StringBuffer buf, String source, List mcqs) {
        int i = 0;
        while (i < mcqs.size()) {
            MultipleChoiceQuestion mcq = (MultipleChoiceQuestion)mcqs.get(i);
            if (i == 0) {
                buf.append(OFFERING_NAME_TAG_BEGIN).append(mcq.getOffering().getName()).append(OFFERING_NAME_TAG_END).append(CommonDef.EOL).append(OFFERING_VERSION_TAG_BEGIN).append(mcq.getOffering().getVersion()).append(OFFERING_VERSION_TAG_END).append(CommonDef.EOL);
            }
            buf.append(MCQ_TAG_BEGIN).append(mcq.getQuestionName()).append(MCQ_TAG_BEGIN_END).append(CommonDef.EOL).append(QUESTION_TAG_BEGIN).append(mcq.getQuestion().getValue()).append(QUESTION_TAG_END).append(CommonDef.EOL).append(ANSWER_TAG_BEGIN);
            List selection = mcq.getSelection();
            int j = 0;
            while (j < selection.size()) {
                if (j > 0) {
                    buf.append(",");
                }
                Integer index = (Integer)selection.get(j);
                MultipleChoiceQuestion.LocaleSupport lc = (MultipleChoiceQuestion.LocaleSupport)mcq.getAnswers().get(index);
                if (lc.getMcq() == null) {
                    buf.append(lc.getValue());
                } else {
                    buf.append(lc.getMcq().getText());
                }
                ++j;
            }
            buf.append(ANSWER_TAG_END).append(CommonDef.EOL).append(MCQ_TAG_END).append(CommonDef.EOL);
            ++i;
        }
    }

    public void afterInstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
    }

    public IStatus beforeUninstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
        return Status.OK_STATUS;
    }

    public void afterUninstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
    }

    public static IwmRepository getIwmRepository(IOffering offering) {
        return IwmUtils.getIwmRepository((IRepository)Agent.getInstance().getRepositoryGroup(), (IOffering)offering);
    }

    private static class NurtureData {
        private final List sources = new LinkedList();
        private Map mcqs;

        private NurtureData() {
        }
    }

    private static class TextQuestion {
        MultipleChoiceQuestion mcq;

        TextQuestion(MultipleChoiceQuestion mcq) {
            this.mcq = mcq;
        }
    }
}

