/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.factories.LauncherFactory;
import com.ibm.cic.agent.internal.ui.utils.ProfileTreeNode;
import com.ibm.cic.agent.internal.ui.utils.UpdateResultContentProvider;
import com.ibm.cic.agent.internal.ui.utils.UpdateResultLabelProvider;
import com.ibm.cic.agent.internal.ui.utils.UpdateResultTreeViewerSorter;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.RebootCompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.UpdateWizard;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.RebootRequest;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class UpdateCompletionPage
extends RebootCompletionPage {
    private Label installedUpdateLabel;
    private TreeViewer updateViewer;
    private Map launchersProfiles;

    public UpdateCompletionPage(FormToolkit toolkit, AgentUIWizard wizard, IStatus status) {
        super(toolkit, Messages.UpdateCompletionPage_title, "", wizard, status);
    }

    private Composite createDetailControlWithLaunchers(Composite container) {
        this.hasLauncherAndNoRebootRequested = !this.launchers.isEmpty() && !RebootRequest.isSet();
        Composite comp = this.getToolkit().createComposite(container);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1808));
        Label fillerLabel1 = this.getToolkit().createLabel(comp, "");
        GridData gd = new GridData();
        int fillerWidth = 0;
        fillerWidth = this.hasLauncherAndNoRebootRequested ? 20 : 150;
        gd.widthHint = fillerWidth;
        fillerLabel1.setLayoutData((Object)gd);
        Composite detailComp = this.getToolkit().createComposite(comp);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        if (this.hasLauncherAndNoRebootRequested) {
            gridLayout.numColumns = 2;
            gridLayout.makeColumnsEqualWidth = true;
        }
        detailComp.setLayout((Layout)gridLayout);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        detailComp.setLayoutData((Object)data);
        int detailCompNumColumns = gridLayout.numColumns;
        this.createDetailResultTextControl(detailComp, detailCompNumColumns);
        Composite installedUpdateComp = this.getToolkit().createComposite(detailComp);
        installedUpdateComp.setLayout((Layout)new GridLayout());
        installedUpdateComp.setLayoutData((Object)new GridData(1808));
        this.installedUpdateLabel = this.getToolkit().createLabel(installedUpdateComp, "", 64);
        int style = 101124;
        this.updateViewer = new TreeViewer(installedUpdateComp, style);
        gd = new GridData(1808);
        gd.heightHint = this.updateViewer.getTree().getItemHeight() * 6;
        this.updateViewer.getTree().setLayoutData((Object)gd);
        this.updateViewer.getTree().setLinesVisible(false);
        this.updateViewer.getTree().setHeaderVisible(true);
        TreeColumn updateCol = new TreeColumn(this.updateViewer.getTree(), 0x800000);
        updateCol.setText(Messages.AvailableUpdateSection_updateCol);
        TreeColumn installLocationCol = new TreeColumn(this.updateViewer.getTree(), 0x800000);
        installLocationCol.setText(Messages.InstallLocationSection_columnLocation);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(72, 280, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(28, 120, true));
        this.updateViewer.getTree().setLayout((Layout)tableLayout);
        this.updateViewer.setContentProvider((IContentProvider)new UpdateResultContentProvider(false));
        this.updateViewer.setLabelProvider((IBaseLabelProvider)new UpdateResultLabelProvider(DisplayKeeper.INSTANCE.getDisplay()));
        this.updateViewer.setSorter((ViewerSorter)new UpdateResultTreeViewerSorter());
        this.updateViewer.setInput(null);
        Composite labelComp = this.getToolkit().createComposite(detailComp);
        labelComp.setLayout((Layout)new GridLayout());
        labelComp.setLayoutData((Object)new GridData(1808));
        Label installedUpdateLabel1 = this.getToolkit().createLabel(labelComp, "", 64);
        style = 101124;
        if (this.hasLauncherAndNoRebootRequested) {
            installedUpdateLabel1.setText(Messages.InstallCompletionPage_launchPkgLabel);
            this.launcherButtons = new ArrayList();
            ScrolledComposite scrolled = new ScrolledComposite(labelComp, 2816);
            scrolled.setExpandHorizontal(true);
            scrolled.setExpandVertical(true);
            scrolled.setLayoutData((Object)new GridData(1808));
            Composite buttonsComp = new Composite((Composite)scrolled, 0);
            buttonsComp.setLayout((Layout)new GridLayout());
            buttonsComp.setLayoutData((Object)new GridData(1808));
            buttonsComp.setBackground(labelComp.getBackground());
            for (Object profileName : this.launchersProfiles.keySet()) {
                if (this.launchersProfiles.size() > 1) {
                    Label profileLabel = this.getToolkit().createLabel(buttonsComp, "", 64);
                    profileLabel.setText(profileName.toString());
                }
                for (LauncherFactory.Launcher launcher : this.launchers) {
                    if (!launcher.getProfile().getProfileId().equals(profileName.toString())) continue;
                    Button btn = this.getToolkit().createButton(buttonsComp, launcher.getLabel(), 16);
                    this.launcherButtons.add(btn);
                    if (!Agent.getInstance().isSkipInstall()) continue;
                    btn.setEnabled(false);
                }
                if (this.launchersProfiles.size() <= 1) continue;
                Label newlineLabel = this.getToolkit().createLabel(buttonsComp, "", 64);
                newlineLabel.setText("\n");
            }
            Button btn = this.getToolkit().createButton(buttonsComp, Messages.InstallCompletionPage_notLaunchPkgButton, 16);
            this.launcherButtons.add(btn);
            if (Agent.getInstance().isSkipInstall()) {
                btn.setEnabled(false);
                btn.setSelection(true);
            } else if (!this.launcherButtons.isEmpty()) {
                ((Button)this.launcherButtons.get(0)).setSelection(true);
            }
            scrolled.setContent((Control)buttonsComp);
            scrolled.setMinSize(buttonsComp.computeSize(-1, -1));
        }
        Label fillerLabel2 = this.getToolkit().createLabel(comp, "");
        gd = new GridData();
        gd.widthHint = 20;
        fillerLabel2.setLayoutData((Object)gd);
        return detailComp;
    }

    private Composite createDetailControlWithoutLaunchers(Composite container) {
        Composite detailComp = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        detailComp.setLayout((Layout)gridLayout);
        detailComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label fillerLabel1 = new Label(detailComp, 0);
        GridData data = new GridData();
        data.widthHint = 120;
        fillerLabel1.setLayoutData((Object)data);
        Composite installedUpdateComp = new Composite(detailComp, 0);
        installedUpdateComp.setLayout((Layout)new GridLayout());
        installedUpdateComp.setLayoutData((Object)new GridData(1808));
        this.createDetailResultTextControl(installedUpdateComp, new GridLayout().numColumns);
        this.installedUpdateLabel = new Label(installedUpdateComp, 0);
        int style = 101124;
        this.updateViewer = new TreeViewer(installedUpdateComp, style);
        GridData gd = new GridData(1808);
        gd.heightHint = this.updateViewer.getTree().getItemHeight() * 6;
        this.updateViewer.getTree().setLayoutData((Object)gd);
        this.updateViewer.getTree().setLinesVisible(false);
        this.updateViewer.getTree().setHeaderVisible(true);
        TreeColumn updateCol = new TreeColumn(this.updateViewer.getTree(), 0x800000);
        updateCol.setText(Messages.AvailableUpdateSection_updateCol);
        TreeColumn installLocationCol = new TreeColumn(this.updateViewer.getTree(), 0x800000);
        installLocationCol.setText(Messages.InstallLocationSection_columnLocation);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(72, 280, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(28, 120, true));
        this.updateViewer.getTree().setLayout((Layout)tableLayout);
        this.updateViewer.setContentProvider((IContentProvider)new UpdateResultContentProvider(false));
        this.updateViewer.setLabelProvider((IBaseLabelProvider)new UpdateResultLabelProvider(DisplayKeeper.INSTANCE.getDisplay()));
        this.updateViewer.setSorter((ViewerSorter)new UpdateResultTreeViewerSorter());
        this.updateViewer.setInput(null);
        Label fillerLabel2 = new Label(detailComp, 0);
        data = new GridData();
        data.widthHint = 120;
        fillerLabel2.setLayoutData((Object)data);
        return installedUpdateComp;
    }

    @Override
    protected Composite createDetailControl(Composite container) {
        Composite detailComp = null;
        if (this.launchers != null && !this.launchers.isEmpty()) {
            if (!RebootRequest.isSet()) {
                detailComp = this.createDetailControlWithLaunchers(container);
            }
        } else {
            detailComp = this.createDetailControlWithoutLaunchers(container);
        }
        return detailComp;
    }

    public void setLaunchers(Map offeringLauncherMap) {
        if (offeringLauncherMap != null) {
            LinkedHashSet<LauncherFactory.Launcher> launcherSet = new LinkedHashSet<LauncherFactory.Launcher>();
            List jobs = this.getSelectedJobs();
            for (AbstractJob job : jobs) {
                IOfferingOrFix offering = job.getOfferingOrFix();
                List launcherList = (List)offeringLauncherMap.get(String.valueOf(offering.getIdentity().getId()) + "," + job.getProfile().getProfileId());
                if (launcherList == null) continue;
                int j = 0;
                while (j < launcherList.size()) {
                    LauncherFactory.Launcher launcher = (LauncherFactory.Launcher)launcherList.get(j);
                    launcher.setProfile(job.getProfile());
                    launcherSet.add(launcher);
                    ++j;
                }
            }
            this.launchers = LauncherFactory.Launcher.reorder(launcherSet);
        }
    }

    public void setLaunchersProfiles(Map launchersProfiles) {
        this.launchersProfiles = launchersProfiles;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.showResultText();
            this.showUpdateDetails();
            this.reflowFor((Control)this.resultText);
            this.reflowFor((Control)this.updateViewer.getTree());
            this.reflowFor(this.getControl());
        }
        super.setVisible(visible);
    }

    private void showResultText() {
        List jobs = this.getSelectedJobs();
        if (jobs.size() > 0) {
            if (this.result == 0) {
                this.resultText.setText(Messages.UpdateCompletionPage_result_success);
            } else if (this.result == 3) {
                this.resultText.setText(Messages.UpdateCompletionPage_result_completeWithWarning);
            } else if (this.result == 2) {
                this.resultText.setText(Messages.UpdateCompletionPage_result_cancel);
            } else {
                this.resultText.setText(Messages.UpdateCompletionPage_result_fail);
            }
        } else {
            this.resultText.setText(Messages.UpdateCompletionPage_result_noUpdates);
        }
    }

    private void showUpdateDetails() {
        this.updateViewer.getTree().removeAll();
        List jobs = this.getSelectedJobs();
        if (jobs.size() == 0) {
            this.installedUpdateLabel.setText("");
            this.updateViewer.setInput(null);
        } else {
            if (this.result == 0 || this.result == 3) {
                if (jobs.size() > 1) {
                    this.installedUpdateLabel.setText(Messages.UpdateCompletionPage_updatesSuccessLabel);
                } else {
                    this.installedUpdateLabel.setText(Messages.UpdateCompletionPage_updateSuccessLabel);
                }
            } else if (jobs.size() > 1) {
                this.installedUpdateLabel.setText(Messages.UpdateCompletionPage_updatesFailLabel);
            } else {
                this.installedUpdateLabel.setText(Messages.UpdateCompletionPage_updateFailLabel);
            }
            if (this.wizard != null && this.wizard instanceof UpdateWizard) {
                ArrayList<ProfileTreeNode> allProfileNodes = ((UpdateWizard)this.wizard).getUpdateResultTreeRoot();
                if (allProfileNodes != null && allProfileNodes.size() > 1 && jobs.size() > 1 && this.result != 0 && this.result != 3) {
                    ArrayList<ProfileTreeNode> failedProfileNodes = new ArrayList<ProfileTreeNode>();
                    for (Object e : allProfileNodes) {
                        ProfileTreeNode ptn = (ProfileTreeNode)e;
                        if (this.areAllProfileJobsSuccessful(ptn.getProfile(), jobs)) continue;
                        failedProfileNodes.add(ptn);
                    }
                    allProfileNodes = failedProfileNodes;
                }
                this.updateViewer.setInput((Object)allProfileNodes);
            }
            this.updateViewer.expandAll();
        }
    }

    private boolean areAllProfileJobsSuccessful(Profile profile, List jobs) {
        for (Object obj : jobs) {
            UpdateOfferingJob uoj = (UpdateOfferingJob)obj;
            if (!uoj.getProfile().getProfileId().equals(profile.getProfileId()) || uoj.getProfile().isInstalled(uoj.getOfferingOrFix())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void createSpaceNoticeControl(Composite container) {
        if (this.needCreateSpaceNoticeControl()) {
            Layout layout = container.getLayout();
            int numSpan = 1;
            if (layout instanceof GridLayout) {
                numSpan = ((GridLayout)layout).numColumns;
            }
            final Link noteLink = new Link(container, 64);
            noteLink.setText(Messages.FeatureSelectionPage_noteLabel);
            GridData gridData = new GridData(4, 1, true, false);
            gridData.widthHint = 250;
            gridData.horizontalSpan = numSpan;
            noteLink.setLayoutData((Object)gridData);
            noteLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)noteLink.getShell(), (String)"com.ibm.cic.agent.ui.DownloadCachePage", (String[])new String[]{"com.ibm.cic.agent.ui.DownloadCachePage"}, null);
                    dlg.open();
                }
            });
            this.createSpaceNoticeControl = true;
        }
    }

    @Override
    protected String getRebootRequestLabel() {
        return com.ibm.cic.agent.core.sharedUI.Messages.RebootCompletionPage_rebootUpdateLabel;
    }

    @Override
    public void performDone() {
        if (this.rebootNow()) {
            PlatformUtils.reboot();
        } else {
            if (RebootRequest.isSet()) {
                RebootRequest.setRebootLater();
            }
            if (this.launchers != null && !this.launchers.isEmpty() && !RebootRequest.isSet()) {
                this.launchSelected();
            }
        }
    }
}

