/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.ProfilesJobFeatureContentProvider;
import com.ibm.cic.agent.internal.ui.utils.SummaryFeatureLabelProvider;
import com.ibm.cic.agent.internal.ui.utils.UpdateResultTreeViewerSorter;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.RebootCompletionPage;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class UninstallCompletionPage
extends RebootCompletionPage {
    private Label uninstalledPackageLabel;
    private Label notUninstalledPkgLabel;
    private TreeViewer uninstalledPkgTreeViewer;
    private TreeViewer notUninstalledPkgTreeViewer;
    private final AgentUILabelProvider agentLabelProvider;
    private final List uninstalledJobs = new ArrayList();
    private final List notUninstalledJobs = new ArrayList();
    private boolean allUninstalledJobsAreFix = false;
    private boolean allNonUninstalledJobsAreFix = false;

    public UninstallCompletionPage(FormToolkit toolkit, AgentUIWizard wizard, IStatus status) {
        super(toolkit, Messages.UninstallCompletionPage_title, "", wizard, status);
        super.setHelpRef("com.ibm.cic.agent.ui.UninstallCompletionPage");
        this.agentLabelProvider = AgentUI.getDefault().getLabelProvider();
        this.agentLabelProvider.connect((Object)this);
    }

    @Override
    public void dispose() {
        this.agentLabelProvider.disconnect((Object)this);
    }

    @Override
    protected Composite createDetailControl(Composite container) {
        this.checkUninstalledJobs();
        Composite detailComp = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        detailComp.setLayout((Layout)gridLayout);
        detailComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label fillerLabel1 = new Label(detailComp, 0);
        GridData data = new GridData();
        data.widthHint = !this.uninstalledJobs.isEmpty() && !this.notUninstalledJobs.isEmpty() ? 40 : 150;
        fillerLabel1.setLayoutData((Object)data);
        Composite tableComp = new Composite(detailComp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = !this.uninstalledJobs.isEmpty() && !this.notUninstalledJobs.isEmpty() ? 2 : 1;
        tableComp.setLayout((Layout)layout);
        tableComp.setLayoutData((Object)new GridData(1808));
        this.createDetailResultTextControl(tableComp, layout.numColumns);
        Composite uninstalledPackageComp = new Composite(tableComp, 0);
        uninstalledPackageComp.setLayout((Layout)new GridLayout());
        uninstalledPackageComp.setLayoutData((Object)new GridData(1808));
        this.uninstalledPackageLabel = new Label(uninstalledPackageComp, 0);
        int style = 101124;
        this.uninstalledPkgTreeViewer = new TreeViewer(uninstalledPackageComp, style);
        GridData gd = new GridData(1808);
        gd.heightHint = this.uninstalledPkgTreeViewer.getTree().getItemHeight() * 6;
        gd.widthHint = 300;
        this.uninstalledPkgTreeViewer.getTree().setLayoutData((Object)gd);
        this.uninstalledPkgTreeViewer.getTree().setLinesVisible(false);
        this.uninstalledPkgTreeViewer.getTree().setHeaderVisible(true);
        TreeColumn pkgCol = new TreeColumn(this.uninstalledPkgTreeViewer.getTree(), 0x800000);
        pkgCol.setText(Messages.UninstallSummaryPage_uninstallPackage);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 280, true));
        this.uninstalledPkgTreeViewer.getTree().setLayout((Layout)tableLayout);
        this.uninstalledPkgTreeViewer.setContentProvider((IContentProvider)new ProfilesJobFeatureContentProvider(false));
        this.uninstalledPkgTreeViewer.setLabelProvider((IBaseLabelProvider)new SummaryFeatureLabelProvider());
        this.uninstalledPkgTreeViewer.setInput(null);
        this.uninstalledPkgTreeViewer.setSorter((ViewerSorter)new UpdateResultTreeViewerSorter(true));
        if (!this.uninstalledJobs.isEmpty() && !this.notUninstalledJobs.isEmpty()) {
            Composite notUninstalledPkgComp = new Composite(tableComp, 0);
            notUninstalledPkgComp.setLayout((Layout)new GridLayout());
            notUninstalledPkgComp.setLayoutData((Object)new GridData(1808));
            this.notUninstalledPkgLabel = new Label(notUninstalledPkgComp, 0);
            int style2 = 101124;
            this.notUninstalledPkgTreeViewer = new TreeViewer(notUninstalledPkgComp, style2);
            gd = new GridData(1808);
            gd.heightHint = this.uninstalledPkgTreeViewer.getTree().getItemHeight() * 6;
            gd.widthHint = 300;
            this.notUninstalledPkgTreeViewer.getTree().setLayoutData((Object)gd);
            this.notUninstalledPkgTreeViewer.getTree().setLinesVisible(false);
            this.notUninstalledPkgTreeViewer.getTree().setHeaderVisible(true);
            TreeColumn notUinstalledPkgCol = new TreeColumn(this.notUninstalledPkgTreeViewer.getTree(), 0x800000);
            if (!this.allNonUninstalledJobsAreFix) {
                notUinstalledPkgCol.setText(Messages.UninstallSummaryPage_uninstallPackage);
            } else {
                notUinstalledPkgCol.setText(Messages.UpdateSummaryPage_colFix);
            }
            TableLayout nonUninstallTableLayout = new TableLayout();
            nonUninstallTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 280, true));
            this.notUninstalledPkgTreeViewer.getTree().setLayout((Layout)nonUninstallTableLayout);
            this.notUninstalledPkgTreeViewer.setContentProvider((IContentProvider)new ProfilesJobFeatureContentProvider(false));
            this.notUninstalledPkgTreeViewer.setLabelProvider((IBaseLabelProvider)new SummaryFeatureLabelProvider());
            this.notUninstalledPkgTreeViewer.setInput(null);
            this.notUninstalledPkgTreeViewer.setSorter((ViewerSorter)new UpdateResultTreeViewerSorter());
        }
        Label fillerLabel2 = new Label(detailComp, 0);
        data = new GridData();
        data.widthHint = !this.uninstalledJobs.isEmpty() && !this.notUninstalledJobs.isEmpty() ? 40 : 150;
        fillerLabel2.setLayoutData((Object)data);
        return tableComp;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.showResultText();
            this.showUninstallDetails();
            this.reflowFor((Control)this.resultText);
            this.reflowFor((Control)this.uninstalledPkgTreeViewer.getTree());
            if (this.notUninstalledPkgTreeViewer != null) {
                this.reflowFor((Control)this.notUninstalledPkgTreeViewer.getTree());
            }
            this.reflowFor(this.getControl());
        }
        super.setVisible(visible);
    }

    private void showResultText() {
        if (this.result == 0) {
            this.resultText.setText(Messages.UninstallCompletionPage_result_success);
        } else if (this.result == 3) {
            this.resultText.setText(Messages.UninstallCompletionPage_result_completeWithWarning);
        } else if (this.result == 2) {
            this.resultText.setText(Messages.UninstallCompletionPage_result_cancel);
        } else {
            this.resultText.setText(Messages.UninstallCompletionPage_result_fail);
        }
    }

    private void showUninstallDetails() {
        if (!this.uninstalledJobs.isEmpty()) {
            TreeColumn col;
            if (this.uninstalledJobs.size() > 1) {
                if (!this.allUninstalledJobsAreFix) {
                    this.uninstalledPackageLabel.setText(Messages.UninstallCompletionPage_uninstallationsSuccessLabel);
                } else {
                    this.uninstalledPackageLabel.setText(Messages.UninstallCompletionPage_uninstallationsSuccessLabelFix);
                }
            } else if (!this.allUninstalledJobsAreFix) {
                this.uninstalledPackageLabel.setText(Messages.UninstallCompletionPage_uninstallSuccessLabel);
            } else {
                this.uninstalledPackageLabel.setText(Messages.UninstallCompletionPage_uninstallSuccessLabelFix);
            }
            if (this.allUninstalledJobsAreFix) {
                col = this.uninstalledPkgTreeViewer.getTree().getColumn(0);
                col.setText(Messages.UpdateSummaryPage_colFix);
            }
            this.uninstalledPkgTreeViewer.setInput((Object)AgentUIUtils.createProfileJobTreeView(this.uninstalledJobs));
            this.uninstalledPkgTreeViewer.expandAll();
            if (!this.notUninstalledJobs.isEmpty()) {
                if (this.notUninstalledJobs.size() > 1) {
                    if (!this.allNonUninstalledJobsAreFix) {
                        this.notUninstalledPkgLabel.setText(Messages.UninstallCompletionPage_uninstallationsFailLabel);
                    } else {
                        this.notUninstalledPkgLabel.setText(Messages.UninstallCompletionPage_uninstallationsFailLabelFix);
                    }
                } else if (!this.allNonUninstalledJobsAreFix) {
                    this.notUninstalledPkgLabel.setText(Messages.UninstallCompletionPage_uninstallationFailLabel);
                } else {
                    this.notUninstalledPkgLabel.setText(Messages.UninstallCompletionPage_uninstallationFailLabelFix);
                }
                if (this.allNonUninstalledJobsAreFix) {
                    col = this.notUninstalledPkgTreeViewer.getTree().getColumn(0);
                    col.setText(Messages.UpdateSummaryPage_colFix);
                }
                this.notUninstalledPkgTreeViewer.setInput((Object)AgentUIUtils.createProfileJobTreeView(this.notUninstalledJobs));
                this.notUninstalledPkgTreeViewer.expandAll();
            }
        } else {
            if (this.notUninstalledJobs.size() > 1) {
                if (!this.allNonUninstalledJobsAreFix) {
                    this.uninstalledPackageLabel.setText(Messages.UninstallCompletionPage_uninstallationsFailLabel);
                } else {
                    this.uninstalledPackageLabel.setText(Messages.UninstallCompletionPage_uninstallationsFailLabelFix);
                }
            } else if (!this.allNonUninstalledJobsAreFix) {
                this.uninstalledPackageLabel.setText(Messages.UninstallCompletionPage_uninstallationFailLabel);
            } else {
                this.uninstalledPackageLabel.setText(Messages.UninstallCompletionPage_uninstallationFailLabelFix);
            }
            if (this.allNonUninstalledJobsAreFix) {
                TreeColumn col = this.uninstalledPkgTreeViewer.getTree().getColumn(0);
                col.setText(Messages.UpdateSummaryPage_colFix);
            }
            this.uninstalledPkgTreeViewer.setInput((Object)AgentUIUtils.createProfileJobTreeView(this.notUninstalledJobs));
            this.uninstalledPkgTreeViewer.expandAll();
        }
    }

    private void checkUninstalledJobs() {
        this.uninstalledJobs.clear();
        this.notUninstalledJobs.clear();
        List selectedJobs = this.getSelectedJobs();
        int i = 0;
        while (i < selectedJobs.size()) {
            AgentJob job = (AgentJob)selectedJobs.get(i);
            IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
            Profile profile = job.getProfile();
            if (offeringOrFix != null) {
                boolean offeringOrFixWasUninstalled = true;
                if (offeringOrFix instanceof IOffering) {
                    IOffering offering = (IOffering)offeringOrFix;
                    if (AgentUI.getDefault().getAgent().findInstalledOffering((IProfile)profile, offering.getIdentity()) != null) {
                        offeringOrFixWasUninstalled = false;
                    }
                } else if (offeringOrFix instanceof IFix) {
                    IFix[] installedFixes;
                    IFix fix = (IFix)offeringOrFix;
                    IFix[] iFixArray = installedFixes = AgentUI.getDefault().getAgent().getInstalledFixes(profile);
                    int n = installedFixes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFix installedFix = iFixArray[n2];
                        if (fix.equals(installedFix)) {
                            offeringOrFixWasUninstalled = false;
                            break;
                        }
                        ++n2;
                    }
                }
                if (offeringOrFixWasUninstalled) {
                    this.uninstalledJobs.add(job);
                } else {
                    this.notUninstalledJobs.add(job);
                }
            }
            ++i;
        }
        this.allUninstalledJobsAreFix = AgentUIUtils.allFixJobs(this.uninstalledJobs);
        this.allNonUninstalledJobsAreFix = AgentUIUtils.allFixJobs(this.notUninstalledJobs);
    }

    @Override
    protected String getRebootRequestLabel() {
        return com.ibm.cic.agent.core.sharedUI.Messages.RebootCompletionPage_rebootUninstallLabel;
    }
}

