/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.wizards.ResponseFileGenWizard;
import com.ibm.cic.common.ui.internal.wizardry.AbstractCicWizardPage;
import com.ibm.cic.common.ui.services.IBaseDialogService;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.io.File;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ResponseFileGenResponseFilePage
extends AbstractCicWizardPage {
    private final ResponseFileGenWizard wizard;
    private Text responseFileText;

    public ResponseFileGenResponseFilePage(FormToolkit toolkit, ResponseFileGenWizard wizard) {
        super(Messages.ResponseFileGenerator_ResponseFilePage_Title, toolkit, Messages.ResponseFileGenerator_ResponseFilePage_Des);
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        Composite container = this.getToolkit().createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label msg = this.getToolkit().createLabel(container, Messages.ResponseFileGenerator_ResponseFilePage_Label);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.verticalIndent = 20;
        msg.setLayoutData((Object)data);
        this.responseFileText = this.getToolkit().createText(container, "");
        this.responseFileText.setLayoutData((Object)new GridData(768));
        this.responseFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String fileName = ResponseFileGenResponseFilePage.this.responseFileText.getText();
                if (fileName == null || fileName.trim().length() == 0) {
                    ResponseFileGenResponseFilePage.this.setErrorMessage(null);
                    ResponseFileGenResponseFilePage.this.setPageComplete(false);
                } else {
                    String deprocessedFileName = TextProcessor.deprocess((String)fileName);
                    File file = new File(deprocessedFileName);
                    if (file.isDirectory()) {
                        ResponseFileGenResponseFilePage.this.setErrorMessage(NLS.bind((String)Messages.ResponseFileGenerator_ResponseFilePage_Dir_Error, (Object)fileName));
                        ResponseFileGenResponseFilePage.this.setPageComplete(false);
                    } else if (!deprocessedFileName.endsWith(".xml")) {
                        ResponseFileGenResponseFilePage.this.setErrorMessage(Messages.ResponseFileGenerator_ResponseFilePage_XML_File);
                        ResponseFileGenResponseFilePage.this.setPageComplete(false);
                    } else {
                        if (file.exists()) {
                            ResponseFileGenResponseFilePage.this.setErrorMessage(null);
                            ResponseFileGenResponseFilePage.this.setMessage(NLS.bind((String)Messages.ResponseFileGenerator_ResponseFilePage_Warning, (Object)fileName), 2);
                        } else {
                            ResponseFileGenResponseFilePage.this.setErrorMessage(null);
                            ResponseFileGenResponseFilePage.this.setMessage(null, 2);
                        }
                        ResponseFileGenResponseFilePage.this.setPageComplete(true);
                        ResponseFileGenResponseFilePage.this.wizard.setResponseFile(deprocessedFileName);
                    }
                }
            }
        });
        Button browseButton = this.getToolkit().createButton(container, Messages.LicenseImportPage_browse, 8);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = DisplayKeeper.INSTANCE.getDisplay().getActiveShell();
                String fileName = ResponseFileGenResponseFilePage.this.responseFileText.getText();
                IBaseDialogService service = UiServices.getInstance().getFileDialog(shell).filterExtensions(new String[]{"*.xml", "*.*"}).title(Messages.ResponseFileGenerator_BrowseFileDlg_Title).filterPath(TextProcessor.deprocess((String)fileName));
                String selectedFile = service.run();
                if (selectedFile != null) {
                    ResponseFileGenResponseFilePage.this.responseFileText.setText(TextProcessor.process((String)selectedFile));
                }
            }
        });
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    protected void setFocus() {
    }
}

