/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.factories.LauncherFactory;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.CompletionPage;
import com.ibm.cic.common.core.utils.AbstractPlatformPolicyFactory;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.RebootRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class RebootCompletionPage
extends CompletionPage {
    Button rebootNowButton;
    List launchers;
    List launcherButtons;
    boolean hasLauncherAndNoRebootRequested;
    PPRebootCompletionPage platformSpecificCode = new PPRebootCompletionPage();

    protected boolean rebootNow() {
        return this.rebootNowButton != null && this.rebootNowButton.getSelection();
    }

    public RebootCompletionPage(FormToolkit toolkit, String pageTitle, String pageDes, AgentUIWizard wizard, IStatus status) {
        super(toolkit, pageTitle, pageDes, wizard, status);
    }

    @Override
    protected void createRebootControl(Composite container) {
        if (RebootRequest.isSet()) {
            this.platformSpecificCode.getPolicy().createRebootControl(container);
        }
    }

    @Override
    public void performDone() {
        if (this.rebootNow()) {
            PlatformUtils.reboot();
        }
    }

    public boolean checkExistence() {
        boolean bVal = false;
        ArrayList<LauncherFactory.Launcher> newList = new ArrayList<LauncherFactory.Launcher>();
        Iterator it = this.launchers.iterator();
        while (it.hasNext()) {
            bVal = true;
            LauncherFactory.Launcher launcher = (LauncherFactory.Launcher)it.next();
            if (!launcher.commandExists()) continue;
            newList.add(launcher);
        }
        this.launchers = newList;
        return bVal;
    }

    protected void launchSelected() {
        LauncherFactory.Launcher launcher;
        IStatus launchStatus;
        int selectionIndex = 0;
        int i = 0;
        while (i < this.launcherButtons.size()) {
            Button btn = (Button)this.launcherButtons.get(i);
            if (btn.getSelection()) {
                selectionIndex = i;
                break;
            }
            ++i;
        }
        if (selectionIndex < this.launchers.size() && (launchStatus = (launcher = (LauncherFactory.Launcher)this.launchers.get(selectionIndex)).launch()).getSeverity() != 0) {
            AgentUI.getDefault().getLog().log(launchStatus);
        }
    }

    protected abstract String getRebootRequestLabel();

    class PPRebootCompletionPage
    extends AbstractPlatformPolicyFactory {
        PPRebootCompletionPage() {
        }

        protected Object createWindowsPolicy() {
            return new PPWindows();
        }

        protected Object createLinuxPolicy() {
            return new PPCommon(this){};
        }

        PPCommon getPolicy() {
            return (PPCommon)this.getPlatformPolicy();
        }

        abstract class PPCommon {
            PPCommon() {
            }

            protected void createRebootControl(Composite container) {
            }
        }

        class PPWindows
        extends PPCommon {
            PPWindows() {
            }

            @Override
            protected void createRebootControl(Composite container) {
                if (((PPRebootCompletionPage)PPRebootCompletionPage.this).RebootCompletionPage.this.result == 0 || ((PPRebootCompletionPage)PPRebootCompletionPage.this).RebootCompletionPage.this.result == 3 || ((PPRebootCompletionPage)PPRebootCompletionPage.this).RebootCompletionPage.this.result == 2 && ((PPRebootCompletionPage)PPRebootCompletionPage.this).RebootCompletionPage.this.offeringsInstalled || ((PPRebootCompletionPage)PPRebootCompletionPage.this).RebootCompletionPage.this.result == 1 && ((PPRebootCompletionPage)PPRebootCompletionPage.this).RebootCompletionPage.this.offeringsInstalled) {
                    Layout layout = container.getLayout();
                    int numSpan = 1;
                    if (layout instanceof GridLayout) {
                        numSpan = ((GridLayout)layout).numColumns;
                    }
                    boolean needSeparator = false;
                    if (((PPRebootCompletionPage)PPRebootCompletionPage.this).RebootCompletionPage.this.createSpaceNoticeControl) {
                        needSeparator = true;
                    } else {
                        List selectedJobs = RebootCompletionPage.this.getSelectedJobs();
                        if (AgentUtil.hasInstallAgentJob((List)selectedJobs)) {
                            boolean installJob = true;
                            int i = 0;
                            while (i < selectedJobs.size()) {
                                AbstractJob job = (AbstractJob)selectedJobs.get(i);
                                if (!job.isInstall()) {
                                    installJob = false;
                                    break;
                                }
                                ++i;
                            }
                            if (installJob) {
                                needSeparator = true;
                            }
                        }
                    }
                    if (needSeparator) {
                        Label separatorLabel = new Label(container, 258);
                        GridData gd = new GridData(4, 1, true, false);
                        gd.horizontalSpan = numSpan;
                        gd.verticalIndent = 10;
                        separatorLabel.setLayoutData((Object)gd);
                    }
                    Composite rebootComp = new Composite(container, 0);
                    rebootComp.setLayout((Layout)new GridLayout());
                    GridData data = new GridData(4, 4, true, false);
                    data.horizontalSpan = numSpan;
                    rebootComp.setLayoutData((Object)data);
                    Label rebootLabel = new Label(rebootComp, 0);
                    rebootLabel.setText(RebootCompletionPage.this.getRebootRequestLabel());
                    ((PPRebootCompletionPage)PPRebootCompletionPage.this).RebootCompletionPage.this.rebootNowButton = new Button(rebootComp, 0x800010);
                    ((PPRebootCompletionPage)PPRebootCompletionPage.this).RebootCompletionPage.this.rebootNowButton.setText(Messages.RebootCompletionPage_rebootNow);
                    Button rebootLaterButton = new Button(rebootComp, 0x800010);
                    rebootLaterButton.setText(Messages.RebootCompletionPage_rebootLater);
                    if (RebootRequest.shouldRebootNow()) {
                        ((PPRebootCompletionPage)PPRebootCompletionPage.this).RebootCompletionPage.this.rebootNowButton.setSelection(true);
                    } else {
                        rebootLaterButton.setSelection(true);
                    }
                }
            }
        }
    }
}

