/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.views.PreviewTaskDetailsPage;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import java.util.ArrayList;
import java.util.Arrays;

public class ProfileDetailsPage
extends PreviewTaskDetailsPage {
    @Override
    protected String getInstalledOfferingDescription(Profile profile) {
        Agent agent = AgentUI.getDefault().getAgent();
        IOffering[] offerings = agent.getInstalledOfferings(profile);
        IFix[] fixes = agent.getInstalledFixes(profile);
        ArrayList<IFix> fixList = new ArrayList<IFix>(Arrays.asList(fixes));
        if (offerings.length == 0 && fixes.length == 0) {
            return "";
        }
        StringBuffer installedOfferingsList = new StringBuffer("<p><b>");
        installedOfferingsList.append(Messages.ProfileDetailsPage_InstalledPkgs);
        installedOfferingsList.append("</b></p>");
        SortUtil.sortOfferings((IOfferingOrFix[])offerings);
        IOffering[] iOfferingArray = offerings;
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IFix[] fixesForOffering;
            IOffering offering = iOfferingArray[n2];
            String offeringLabel = this.getObjectLabel(offering);
            if (offeringLabel != null && offeringLabel.length() > 0) {
                installedOfferingsList.append("<li>");
                installedOfferingsList.append(CommonUIUtils.escapeSpecialChars((String)offeringLabel));
                installedOfferingsList.append("</li>");
            }
            if ((fixesForOffering = agent.getInstalledFixes(profile, offering)) != null && fixesForOffering.length > 0) {
                SortUtil.sortByNameAndVersion((IOfferingOrFix[])fixesForOffering);
                IFix[] iFixArray = fixesForOffering;
                int n3 = fixesForOffering.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFix fix = iFixArray[n4];
                    String fixLabel = this.getObjectLabel(fix);
                    if (fixLabel != null && fixLabel.length() > 0) {
                        installedOfferingsList.append("<li bindent=\"20\">");
                        installedOfferingsList.append(CommonUIUtils.escapeSpecialChars((String)fixLabel));
                        installedOfferingsList.append("</li>");
                    }
                    fixList.remove(fix);
                    ++n4;
                }
            }
            ++n2;
        }
        if (!fixList.isEmpty()) {
            int i = 0;
            while (i < fixList.size()) {
                IFix fix = (IFix)fixList.get(i);
                String fixLabel = this.getObjectLabel(fix);
                if (fixLabel != null && fixLabel.length() > 0) {
                    installedOfferingsList.append("<li>");
                    installedOfferingsList.append(CommonUIUtils.escapeSpecialChars((String)fixLabel));
                    installedOfferingsList.append("</li>");
                }
                ++i;
            }
        }
        return installedOfferingsList.toString();
    }
}

