/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.LicenseFlexData;
import com.ibm.cic.agent.internal.ui.utils.ProfileOfferingFeature;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.licensing.common.util.LicUserUtils;
import com.ibm.cic.licensing.common.util.LicensePolicyData;
import com.ibm.cic.licensing.policy.ui.dialogs.OfferingDialog;
import com.ibm.cic.licensing.policy.ui.dialogs.TableItemEditDialog;
import com.ibm.cic.licensing.policy.ui.viewers.EditableTableViewer;
import com.ibm.cic.licensing.policy.ui.viewers.OfferingMapViewer;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.framework.Version;

public class LicenseUsagePage
extends AbstractAgentUIWizardPage {
    private final LicensePolicyData policyData;
    private OfferingMapViewer viewer;
    private final ProfileOfferingFeature profileOfferingFeature;

    public LicenseUsagePage(FormToolkit toolkit, AgentUIWizard wizard, LicenseFlexData licenseFlexData, ProfileOfferingFeature pof) {
        super(Messages.LicenseUsagePage_title, toolkit, Messages.LicenseUsagePage_title, Messages.LicenseUsagePage_header, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.LicenseUsagePage");
        this.policyData = licenseFlexData.getPolicyData();
        this.profileOfferingFeature = pof;
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = this.toolkit.createComposite(parent);
        EditableTableViewer.DefaultFormAdapter formAdapter = new EditableTableViewer.DefaultFormAdapter();
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.viewer = new MyOfferingMapViewer(container, (EditableTableViewer.IFormAdapter)formAdapter);
        this.addOfferingToPolicyData();
        this.viewer.setInput((Object)this.policyData.getOfferingMapData());
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            Table table = this.viewer.getTableViewer().getTable();
            table.setEnabled(false);
            table.setEnabled(true);
            this.viewer.setEnabled(this.policyData.getFlexData().isEnabled());
        }
        super.setVisible(visible);
    }

    private void addOfferingToPolicyData() {
        LicensePolicyData.OfferingMapData offeringMapData = this.policyData.getOfferingMapData();
        if (this.profileOfferingFeature != null) {
            IOffering offering = this.profileOfferingFeature.getProfileOffering().getOffering();
            IFeatureBase featureOrGroup = this.profileOfferingFeature.getFeatureOrGroup();
            Version version = LicUserUtils.getMajorMinorMicroVersion((Version)offering.getVersion());
            if (featureOrGroup == null) {
                LicensePolicyData.OfferingData[] datas;
                LicensePolicyData.OfferingData[] offeringDataArray = datas = LicenseUsagePage.genOfferingDataForOfferingFeatureOrGroup(offering);
                int n = datas.length;
                int n2 = 0;
                while (n2 < n) {
                    LicensePolicyData.OfferingData data = offeringDataArray[n2];
                    if (offeringMapData.getOffering(data.toKeyString()) == null) {
                        offeringMapData.addOffering(data);
                    }
                    ++n2;
                }
            } else {
                String name;
                IInstallableUnit iu = LicenseUtils.getFeatureIplaUnit((IOffering)offering, (IFeatureBase)featureOrGroup);
                String id = LicenseUtils.getLicenseId((IInstallableUnit)iu);
                LicensePolicyData.OfferingData data = new LicensePolicyData.OfferingData(id, version, name = LicenseUtils.getLicenseName((IInstallableUnit)iu));
                if (offeringMapData.getOffering(data.toKeyString()) == null) {
                    offeringMapData.addOffering(data);
                }
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    private static LicensePolicyData.OfferingData[] genOfferingDataForOfferingFeatureOrGroup(IOffering installedOffering) {
        Agent agent = AgentUI.getDefault().getAgent();
        Profile[] profiles = agent.getVisibleProfiles();
        ArrayList<LicensePolicyData.OfferingData> return_value = new ArrayList<LicensePolicyData.OfferingData>();
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            String profileKind = profile.getProfileKind();
            if (!profileKind.equals("self") && !profileKind.equals("license")) {
                IOffering[] offerings = agent.getInstalledOfferings(profile);
                int j = 0;
                while (j < offerings.length) {
                    if (installedOffering == null || installedOffering.equals(offerings[j])) {
                        IFeatureBase[] installedLicensedFeatureOrGroups;
                        if (LicenseUtils.isOfferingFlexlmApplicable((IOffering)offerings[j])) {
                            return_value.add(LicenseUsagePage.generateOfferingData(offerings[j]));
                        }
                        if ((installedLicensedFeatureOrGroups = AgentUIUtils.getInstalledVisibleLicensedFeatureOrGroup(offerings[j], profile)) != null && installedLicensedFeatureOrGroups.length > 0) {
                            IFeatureBase[] iFeatureBaseArray = installedLicensedFeatureOrGroups;
                            int n3 = installedLicensedFeatureOrGroups.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IFeatureBase featureOrGroup = iFeatureBaseArray[n4];
                                if (LicenseUtils.isFeatureFlexlmApplicable((IOffering)offerings[j], (IFeatureBase)featureOrGroup)) {
                                    return_value.add(LicenseUsagePage.generateOfferingData(offerings[j], featureOrGroup));
                                }
                                ++n4;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++n2;
        }
        return return_value.toArray(new LicensePolicyData.OfferingData[return_value.size()]);
    }

    private static LicensePolicyData.OfferingData generateOfferingData(IOffering offering) {
        Version v = offering.getVersion();
        Version newVer = LicUserUtils.getMajorMinorMicroVersion((Version)v);
        LicensePolicyData.OfferingData od = new LicensePolicyData.OfferingData(offering.getIdentity().getId(), newVer, offering.getName());
        return od;
    }

    private static LicensePolicyData.OfferingData generateOfferingData(IOffering offering, IFeatureBase featureOrGroup) {
        Version v = offering.getVersion();
        Version newVer = LicUserUtils.getMajorMinorMicroVersion((Version)v);
        IInstallableUnit unit = LicenseUtils.getFeatureIplaUnit((IOffering)offering, (IFeatureBase)featureOrGroup);
        LicensePolicyData.OfferingData od = new LicensePolicyData.OfferingData(LicenseUtils.getLicenseId((IInstallableUnit)unit), newVer, LicenseUtils.getLicenseName((IInstallableUnit)unit));
        return od;
    }

    private static class MyOfferingMapViewer
    extends OfferingMapViewer {
        public MyOfferingMapViewer(Composite parent, EditableTableViewer.IFormAdapter formAdapter) {
            super(parent, formAdapter, 3);
        }

        protected Object createNewData(String[] values) {
            return super.createNewData(new String[]{values[2], values[1], values[0]});
        }

        protected TableItemEditDialog createOfferingDialog(Shell shell, String title, String[] initialValues) {
            return new OfferingDialog(shell, Messages.LicenseUsagePage_addPkgFeatureOrGroupDlg_title, LicenseUsagePage.genOfferingDataForOfferingFeatureOrGroup(null), new Point(400, 200));
        }

        public boolean canModify(Object element, String property) {
            return false;
        }
    }
}

