/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.common.ui.parts.CheckboxTreeMasterPart;
import com.ibm.cic.common.ui.parts.IFormContext;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public abstract class CheckboxTreeMasterSection
extends CheckboxTreeMasterPart {
    public CheckboxTreeMasterSection(IFormContext context, Composite parent, int sectionStyle, String[] buttonLabels, int buttonsOrientation) {
        super(context, parent, sectionStyle, buttonLabels, buttonsOrientation);
    }

    public CheckboxTreeMasterSection(IFormContext context, Composite parent, String[] buttonLabels) {
        super(context, parent, buttonLabels);
    }

    protected void checkItem(CheckboxTreeViewer viewer, Object element, boolean checked, boolean grayed) {
        viewer.setChecked(element, checked);
        viewer.setGrayed(element, grayed);
    }

    protected abstract ITreeContentProvider getContentProvider();

    @Override
    protected TreeViewer createTreeViewer(Composite parent, int style) {
        int fullStyle = style;
        if (fullStyle == 0) {
            fullStyle = this.getToolkit().getBorderStyle() | 0x10000;
        }
        CheckboxTreeViewer cviewer = new CheckboxTreeViewer(parent, fullStyle);
        cviewer.getControl().setLayoutData((Object)new GridData(1808));
        this.getContext().getForm().getToolkit().adapt(cviewer.getControl(), true, true);
        cviewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CheckboxTreeMasterSection.this.onCheckStateChange(event);
            }
        });
        return cviewer;
    }

    protected boolean isRequiredItem(Object element) {
        return false;
    }

    protected boolean isVisibleItem(Object element) {
        return true;
    }

    public void checkAll(CheckboxTreeViewer viewer, Object element, boolean checked) {
        Object[] children;
        this.checkItem(viewer, element, checked, false);
        Object[] objectArray = children = this.getChildren(element);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object element2 = objectArray[n2];
            this.checkAll(viewer, element2, checked);
            ++n2;
        }
    }

    protected void elementChecked(CheckboxTreeViewer viewer, Object element, boolean checked) {
        Object[] children;
        Object[] objectArray = children = this.getChildren(element);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (viewer.getChecked(child) != checked || viewer.getGrayed(child)) {
                this.elementChecked(viewer, child, checked);
            }
            ++n2;
        }
        this.updateItem(viewer, element, checked);
    }

    protected Object[] getChildren(Object element) {
        return this.getContentProvider().getChildren(element);
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.getCheckboxTreeViewer().getLabelProvider();
    }

    protected Object getParent(Object element) {
        return this.getContentProvider().getParent(element);
    }

    @Override
    protected void onCheckStateChange(CheckStateChangedEvent event) {
        Object element = event.getElement();
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        this.elementChecked(viewer, element, event.getChecked());
        this.updateParents(viewer, this.getParent(element), event.getChecked());
    }

    @Override
    public void showURL(String url) {
        AgentUI.getDefault().showURL(url);
    }

    protected void updateItem(CheckboxTreeViewer viewer, Object element, boolean preferredState) {
        Object[] children = this.getChildren(element);
        boolean containsSelected = false;
        boolean containsUnselected = false;
        boolean containsRequired = this.isRequiredItem(element);
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (containsRequired || containsSelected && containsUnselected) break;
            boolean checked = viewer.getChecked(child);
            boolean grayed = viewer.getGrayed(child);
            if (this.isVisibleItem(child)) {
                containsSelected |= checked || grayed;
                containsUnselected |= checked && grayed || !checked && !grayed;
            }
            containsRequired = !checked && grayed;
            ++n2;
        }
        if (containsRequired) {
            this.checkItem(viewer, element, false, true);
        } else if (containsSelected || containsUnselected) {
            this.checkItem(viewer, element, containsSelected, containsSelected && containsUnselected);
        } else {
            this.checkItem(viewer, element, preferredState, false);
        }
    }

    protected void updateParents(CheckboxTreeViewer viewer, Object element, boolean checked) {
        if (element != null) {
            this.updateItem(viewer, element, checked);
            this.updateParents(viewer, this.getParent(element), checked);
        }
    }
}

