/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.ICustomPanel;
import com.ibm.cic.agent.core.sharedUI.CommonCustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.CustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.CustomPanelJobPair;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.core.sharedUI.TemplateCommonCustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.TemplateOfferingCustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.core.userdata.parser.CommonUserDataExtParser;
import com.ibm.cic.agent.core.userdata.parser.OfferingUserDataExtParser;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.custompanel.SWTCustomPanelGenerator;
import com.ibm.cic.agent.internal.ui.factories.WizardPageFactory;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.InstallAgentUtils;
import com.ibm.cic.agent.internal.ui.wizards.CompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.IAgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.SingleConfigurationPage;
import com.ibm.cic.agent.ui.extensions.AbstractAgentUIWizard;
import com.ibm.cic.agent.ui.extensions.AbstractAgentWizardPage;
import com.ibm.cic.agent.ui.extensions.CustomPanel;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.internal.WebUiSafeProgressMonitor;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.MaxInstallSizeInfo;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserFeedbackProvider;
import com.ibm.cic.common.downloads.SizeInfo;
import com.ibm.cic.common.ui.internal.views.AbstractCicWizardView;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AgentUIWizard
extends AbstractAgentUIWizard
implements IAgentUIWizard {
    private final ArrayList jobs = new ArrayList();
    private Agent.IAssignedArtifacts collectedArtifacts = null;
    private final ArrayList profiles = new ArrayList();
    private final Map profileLocaleLanguages = new HashMap();
    private final ArrayList productProfiles = new ArrayList();
    private final ArrayList agentProfiles = new ArrayList();
    private final String progressText;
    private final Map previousLocaleLangsMap = new HashMap();
    private final Map addedLocaleLangsMap = new HashMap();
    private final Map removedLocaleLangsMap = new HashMap();
    private Map offeringOrFixLicenseTypeMap = new HashMap();
    private CompletionPage completionPage;
    private CustomPanelJobPair[] panels = null;
    private CustomPanelJobPair[] commonPanels = null;
    private boolean multipleProfile = false;

    @Override
    public IWizardPage getCompletionPage(IStatus completionStatus) {
        if (this.completionPage == null) {
            this.completionPage = this.createCompletionPage(completionStatus);
        }
        return this.completionPage;
    }

    public String getCompletionPageFinishLabel() {
        if (this.completionPage == null) {
            return super.getCompletionPageFinishLabel();
        }
        String finishLabel = this.completionPage.getCompletionPageFinishLabel();
        if (finishLabel == null) {
            return super.getCompletionPageFinishLabel();
        }
        return finishLabel;
    }

    public abstract CompletionPage createCompletionPage(IStatus var1);

    public AgentUIWizard(String finishReturnViewId, String progressText, ImageDescriptor imageDes) {
        super(finishReturnViewId, progressText, imageDes);
        this.setForcePreviousAndNextButtons(true);
        this.progressText = progressText;
    }

    protected void addExtensionPages(String helpRef) {
        try {
            AbstractAgentWizardPage[] pages;
            AbstractAgentWizardPage[] abstractAgentWizardPageArray = pages = WizardPageFactory.getInstance().createExtensionPages(this.getWizardType(), this.getJobsArray());
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractAgentWizardPage page = abstractAgentWizardPageArray[n2];
                if (page.getHelpRef() == null) {
                    page.setHelpRef(helpRef);
                }
                this.addPage((IWizardPage)page);
                ++n2;
            }
        }
        catch (CoreException e) {
            AgentUI.reportStatus(e.getStatus(), true);
        }
    }

    protected void addSingleConfigurationPage(String pageTitle, String helpRef) {
        List selectedJobs = AgentUtil.getSelectedProductAgentJobs((Collection)this.getSelectedJobs());
        CommonUserDataExtParser.getInstance().initializeCommonUserDataExtensions(selectedJobs.toArray(new AgentJob[selectedJobs.size()]));
        OfferingUserDataExtParser.getInstance().initializeOfferingUserDataExtensions(selectedJobs.toArray(new AgentJob[selectedJobs.size()]));
        CustomPanelJobPair[] commonPanelJobs = this.getCommonCustomPanels();
        CustomPanelJobPair[] panelJobs = this.getCustomPanels();
        ArrayList<CustomPanelJobPair> totalPanelJob = new ArrayList<CustomPanelJobPair>();
        if (commonPanelJobs != null && commonPanelJobs.length > 0) {
            totalPanelJob.addAll(Arrays.asList(commonPanelJobs));
        }
        if (panelJobs != null && panelJobs.length > 0) {
            totalPanelJob.addAll(Arrays.asList(panelJobs));
        }
        if (!totalPanelJob.isEmpty()) {
            SingleConfigurationPage singleConfigPage = new SingleConfigurationPage(this.toolkit, pageTitle, Messages.SingleConfigurationPage_des, this, totalPanelJob.toArray(new CustomPanelJobPair[totalPanelJob.size()]));
            singleConfigPage.setHelpRef(helpRef);
            this.addPage((IWizardPage)singleConfigPage);
        }
    }

    private void decideIfMultipleProfiles(AgentJob[] selectedProductJobs) {
        WizardType type = this.getWizardType();
        if (!type.equals(WizardType.INSTALL)) {
            Collection jobArrays = AgentUtil.groupByProfile((AgentJob[])selectedProductJobs, (boolean)false);
            this.multipleProfile = jobArrays.size() > 1;
        }
    }

    private CustomPanelJobPair[] getCommonCustomPanels() {
        AgentJob[] selectedProductJobs = AgentUtil.getSelectedProductAgentJobArray((Collection)this.jobs);
        this.decideIfMultipleProfiles(selectedProductJobs);
        try {
            LinkedList<CustomPanelJobPair> pairsFromAllExtensions = new LinkedList<CustomPanelJobPair>();
            CustomPanelJobPair[] pairsFromTemplateExtension = TemplateCommonCustomPanelFactory.getInstance().createCustomPanels(CustomPanel.class, SWTCustomPanelGenerator.getInstance(), this.getWizardType(), selectedProductJobs, this.multipleProfile);
            pairsFromAllExtensions.addAll(Arrays.asList(pairsFromTemplateExtension));
            CustomPanelJobPair[] pairsFromOldExtension = CommonCustomPanelFactory.getInstance().createCustomPanels(false, CustomPanel.class, this.getWizardType(), selectedProductJobs, this.multipleProfile);
            pairsFromAllExtensions.addAll(Arrays.asList(pairsFromOldExtension));
            this.commonPanels = pairsFromAllExtensions.toArray(new CustomPanelJobPair[pairsFromAllExtensions.size()]);
        }
        catch (CoreException e) {
            AgentUI.reportStatus(e.getStatus(), true);
        }
        return this.commonPanels;
    }

    private CustomPanelJobPair[] getCustomPanels() {
        AgentJob[] selectedProductJobs = AgentUtil.getSelectedProductAgentJobArray((Collection)this.jobs);
        this.decideIfMultipleProfiles(selectedProductJobs);
        try {
            LinkedList<CustomPanelJobPair> pairsFromAllExtensions = new LinkedList<CustomPanelJobPair>();
            CustomPanelJobPair[] pairsFromTemplateExtension = TemplateOfferingCustomPanelFactory.getInstance().createCustomPanels(CustomPanel.class, SWTCustomPanelGenerator.getInstance(), this.getWizardType(), selectedProductJobs, this.multipleProfile);
            pairsFromAllExtensions.addAll(Arrays.asList(pairsFromTemplateExtension));
            CustomPanelJobPair[] pairsFromOldExtension = CustomPanelFactory.getInstance().createCustomPanels(false, CustomPanel.class, this.getWizardType(), selectedProductJobs, this.multipleProfile);
            pairsFromAllExtensions.addAll(Arrays.asList(pairsFromOldExtension));
            this.panels = pairsFromAllExtensions.toArray(new CustomPanelJobPair[pairsFromAllExtensions.size()]);
        }
        catch (CoreException e) {
            AgentUI.reportStatus(e.getStatus(), true);
        }
        return this.panels;
    }

    protected void swapProfileLocaleSettings() {
        Map pll = this.getProfileLocaleLanguagesMap();
        HashSet pSet = new HashSet(pll.keySet());
        for (Profile p : pSet) {
            if (p == null) continue;
            String inProfile = p.getData("cic.selector.nl");
            inProfile = inProfile == null ? "" : inProfile;
            String inMap = (String)pll.get(p);
            pll.put(p, inProfile);
            if (inMap == null) continue;
            p.setData("cic.selector.nl", inMap);
        }
    }

    public synchronized void getSizeInfo(AgentJob[] jobz, SizeInfo profileSize, MaxInstallSizeInfo cacheSize, IProgressMonitor monitor) {
        this.swapProfileLocaleSettings();
        AgentUI.getDefault().getAgent().getSizeInfo(jobz, profileSize, cacheSize, monitor);
        this.swapProfileLocaleSettings();
    }

    public synchronized MaxInstallSizeInfo getSizeInfo(AgentJob[] jobz, IProgressMonitor monitor) {
        SizeInfo profileSize = new SizeInfo();
        MaxInstallSizeInfo cacheSize = new MaxInstallSizeInfo();
        this.getSizeInfo(jobz, profileSize, cacheSize, monitor);
        MaxInstallSizeInfo totalSize = new MaxInstallSizeInfo(profileSize);
        totalSize.add(cacheSize);
        return totalSize;
    }

    protected abstract AbstractJob createJob(Profile var1, IOfferingOrFix var2);

    protected void doRestartProfile(Profile profile) {
        DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)AgentUIWizard.this.getShell(), (String)Messages.AbstractInstallWizard_restartTitle, (String)AgentUIWizard.this.getRestartMessage());
            }
        });
        AgentUI.getDefault().getAgent().restart(profile);
    }

    protected List getJobs() {
        return this.jobs;
    }

    protected List getSelectedJobs() {
        ArrayList<AbstractJob> selectedJobs = new ArrayList<AbstractJob>();
        for (AbstractJob job : this.jobs) {
            if (!job.isSelected()) continue;
            selectedJobs.add(job);
        }
        return selectedJobs;
    }

    protected MapList getProfileJobsMap() {
        MapList profileJobsMap = new MapList();
        List selectedJobs = this.getSelectedJobs();
        int i = 0;
        while (i < selectedJobs.size()) {
            AgentJob job = (AgentJob)selectedJobs.get(i);
            if (!job.isError()) {
                Profile profile = job.getProfile();
                profileJobsMap.add((Object)profile, (Object)job);
            }
            ++i;
        }
        return profileJobsMap;
    }

    protected MapList getProfileProductJobsMap() {
        MapList profileProductJobsMap = new MapList();
        List selectedProductJobs = AgentUtil.getSelectedProductAgentJobs((Collection)this.getSelectedJobs());
        int i = 0;
        while (i < selectedProductJobs.size()) {
            AgentJob job = (AgentJob)selectedProductJobs.get(i);
            if (!job.isError()) {
                Profile profile = job.getProfile();
                profileProductJobsMap.add((Object)profile, (Object)job);
            }
            ++i;
        }
        return profileProductJobsMap;
    }

    protected Agent.IAssignedArtifacts getCollectedArtifacts() {
        return this.collectedArtifacts;
    }

    protected void setCollectedArtifacts(Agent.IAssignedArtifacts collectedArtifacts) {
        this.collectedArtifacts = collectedArtifacts;
    }

    protected List getSelectedAgentJob() {
        ArrayList selectedJobList = new ArrayList(this.getSelectedJobs());
        selectedJobList.removeAll(InstallAgentUtils.getSelectedJobsWithoutAgentJob(selectedJobList));
        return selectedJobList;
    }

    protected List getSelectedOfferings() {
        ArrayList<IOffering> selectedOfferings = new ArrayList<IOffering>();
        List selectedJobs = this.getSelectedJobs();
        for (AbstractJob job : selectedJobs) {
            IOffering offering = job.getOffering();
            if (offering == null) continue;
            selectedOfferings.add(offering);
        }
        return selectedOfferings;
    }

    protected AgentJob[] getJobsArray() {
        AgentJob[] array = new AgentJob[this.jobs.size()];
        return this.jobs.toArray(array);
    }

    protected List getProfiles() {
        this.profiles.clear();
        this.profiles.addAll(this.productProfiles);
        this.profiles.addAll(this.agentProfiles);
        return this.profiles;
    }

    protected List getProductProfileList() {
        return this.productProfiles;
    }

    protected List getAgentProfileList() {
        return this.agentProfiles;
    }

    protected boolean isShadowProfile() {
        List profilesList = this.getProfiles();
        int i = 0;
        while (i < profilesList.size()) {
            Profile profile = (Profile)profilesList.get(i);
            if (!profile.getProfileKind().equals("license")) {
                return profile.isShadow();
            }
            ++i;
        }
        return false;
    }

    protected Profile getProductProfile() {
        List profilesList = this.getProductProfileList();
        int i = 0;
        while (i < profilesList.size()) {
            Profile profile = (Profile)profilesList.get(i);
            if (!profile.getProfileKind().equals("self") && !profile.getProfileKind().equals("license")) {
                return profile;
            }
            ++i;
        }
        return null;
    }

    protected Map getProfileLocaleLanguagesMap() {
        return this.profileLocaleLanguages;
    }

    protected abstract String getRestartMessage();

    protected abstract WizardType getWizardType();

    @Override
    public void init(FormToolkit formToolkit) {
        this.toolkit = formToolkit;
    }

    public void performBackgroundFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                Object newLocaleLangSet;
                monitor = new WebUiSafeProgressMonitor(monitor);
                HashSet<Profile> profilesSet = new HashSet<Profile>();
                int i = 0;
                while (i < AgentUIWizard.this.jobs.size()) {
                    profilesSet.add(((AgentJob)AgentUIWizard.this.jobs.get(i)).getProfile());
                    ++i;
                }
                for (Profile theProfile : profilesSet) {
                    String newLocaleLangValue = (String)AgentUIWizard.this.profileLocaleLanguages.get(theProfile);
                    if (newLocaleLangValue == null) continue;
                    String oldLocaleLangValue = theProfile.getData("cic.selector.nl");
                    AgentUIWizard.this.previousLocaleLangsMap.put(theProfile, oldLocaleLangValue);
                    theProfile.setData("cic.selector.nl", newLocaleLangValue);
                    Set oldLocaleLangSet = ProfileLanguageUtils.convertCodeStringToSet((String)oldLocaleLangValue);
                    newLocaleLangSet = ProfileLanguageUtils.convertCodeStringToSet((String)newLocaleLangValue);
                    HashSet commonLangsSet = new HashSet(oldLocaleLangSet);
                    commonLangsSet.retainAll((Collection<?>)newLocaleLangSet);
                    oldLocaleLangSet.removeAll(commonLangsSet);
                    newLocaleLangSet.removeAll(commonLangsSet);
                    AgentUIWizard.this.addedLocaleLangsMap.put(theProfile, newLocaleLangSet);
                    AgentUIWizard.this.removedLocaleLangsMap.put(theProfile, oldLocaleLangSet);
                }
                IWizardPage[] pages = AgentUIWizard.this.getPages();
                ArrayList<IWizardPage> agentWizardPages = new ArrayList<IWizardPage>();
                newLocaleLangSet = pages;
                int oldLocaleLangSet = pages.length;
                int oldLocaleLangValue = 0;
                while (oldLocaleLangValue < oldLocaleLangSet) {
                    IWizardPage page = newLocaleLangSet[oldLocaleLangValue];
                    if (page instanceof AbstractAgentWizardPage) {
                        agentWizardPages.add(page);
                    }
                    ++oldLocaleLangValue;
                }
                int commonPanelSize = 0;
                if (AgentUIWizard.this.commonPanels != null) {
                    commonPanelSize = AgentUIWizard.this.commonPanels.length;
                }
                int panelSize = 0;
                if (AgentUIWizard.this.panels != null) {
                    panelSize = AgentUIWizard.this.panels.length;
                }
                monitor.beginTask("", 9 * AgentUIWizard.this.jobs.size() + profilesSet.size() + agentWizardPages.size() + commonPanelSize + panelSize);
                monitor.subTask(AgentUIWizard.this.progressText);
                UserFeedbackProvider oldProvider = null;
                Agent agent = AgentUI.getDefault().getAgent();
                try {
                    Exception newExp;
                    String errorMsg;
                    String causedBy;
                    String panelId;
                    SubProgressMonitor panelMonitor;
                    CustomPanel panel;
                    CustomPanelJobPair[] customPanelJobPairArray;
                    oldProvider = agent.setUserFeedbackProvider((UserFeedbackProvider)AgentUIWizard.this);
                    CicMultiStatus resultStatus = Statuses.ST.createMultiStatus();
                    IStatus status = AgentUIWizard.this.performTask(monitor);
                    if (status.matches(4) || status.matches(8)) {
                        throw new InvocationTargetException(new CoreException(status));
                    }
                    if (!status.isOK()) {
                        if (resultStatus.isOK()) {
                            resultStatus = Statuses.ST.createMultiStatusFromStatus(status);
                        } else {
                            resultStatus.add(status);
                        }
                    }
                    Iterator iter = agentWizardPages.iterator();
                    while (iter.hasNext()) {
                        SubProgressMonitor pageMonitor = new SubProgressMonitor(monitor, 1, 4);
                        AbstractAgentWizardPage page = (AbstractAgentWizardPage)((Object)iter.next());
                        status = page.performFinish((IProgressMonitor)pageMonitor);
                        if (status == null || status.getSeverity() == 0) continue;
                        if (status.matches(4) || status.matches(8)) {
                            throw new InvocationTargetException(new CoreException(status));
                        }
                        if (resultStatus.isOK()) {
                            resultStatus = Statuses.ST.createMultiStatusFromStatus(status);
                            continue;
                        }
                        resultStatus.add(status);
                    }
                    if (AgentUIWizard.this.commonPanels != null) {
                        customPanelJobPairArray = AgentUIWizard.this.commonPanels;
                        int n = customPanelJobPairArray.length;
                        int pageMonitor = 0;
                        while (pageMonitor < n) {
                            CustomPanelJobPair commonPanel = customPanelJobPairArray[pageMonitor];
                            panel = (CustomPanel)commonPanel.getPanel();
                            panelMonitor = new SubProgressMonitor(monitor, 1, 4);
                            try {
                                status = panel.performFinish((IProgressMonitor)panelMonitor);
                            }
                            catch (Exception e) {
                                panelId = panel.getPanelId();
                                causedBy = null;
                                causedBy = e.getMessage() == null || e.getMessage().length() == 0 ? e.toString() : e.getMessage();
                                errorMsg = NLS.bind((String)Messages.customPanelInternalError, (Object)panelId, (Object)causedBy);
                                newExp = new Exception(errorMsg, e);
                                DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        AgentUI.reportException(newExp, true);
                                    }
                                });
                            }
                            if (status != null && status.getSeverity() != 0) {
                                if (status.matches(4) || status.matches(8)) {
                                    throw new InvocationTargetException(new CoreException(status));
                                }
                                if (resultStatus.isOK()) {
                                    resultStatus = Statuses.ST.createMultiStatusFromStatus(status);
                                } else {
                                    resultStatus.add(status);
                                }
                            }
                            ++pageMonitor;
                        }
                    }
                    if (AgentUIWizard.this.panels != null) {
                        customPanelJobPairArray = AgentUIWizard.this.panels;
                        int n = customPanelJobPairArray.length;
                        int pageMonitor = 0;
                        while (pageMonitor < n) {
                            CustomPanelJobPair panel2 = customPanelJobPairArray[pageMonitor];
                            panel = (CustomPanel)panel2.getPanel();
                            panelMonitor = new SubProgressMonitor(monitor, 1, 4);
                            try {
                                status = panel.performFinish((IProgressMonitor)panelMonitor);
                            }
                            catch (Exception e) {
                                panelId = panel.getPanelId();
                                causedBy = null;
                                causedBy = e.getMessage() == null || e.getMessage().length() == 0 ? e.toString() : e.getMessage();
                                errorMsg = NLS.bind((String)Messages.customPanelInternalError, (Object)panelId, (Object)causedBy);
                                newExp = new Exception(errorMsg, e);
                                DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        AgentUI.reportException(newExp, true);
                                    }
                                });
                            }
                            if (status != null && status.getSeverity() != 0) {
                                if (status.matches(4) || status.matches(8)) {
                                    throw new InvocationTargetException(new CoreException(status));
                                }
                                if (resultStatus.isOK()) {
                                    resultStatus = Statuses.ST.createMultiStatusFromStatus(status);
                                } else {
                                    resultStatus.add(status);
                                }
                            }
                            ++pageMonitor;
                        }
                    }
                    for (Profile profile : profilesSet) {
                        if (profile.needsRestart()) {
                            AgentUIWizard.this.doRestartProfile(profile);
                        }
                        monitor.worked(1);
                    }
                    if (!resultStatus.isOK()) {
                        throw new InvocationTargetException(new CoreException((IStatus)resultStatus));
                    }
                }
                finally {
                    monitor.done();
                    agent.setUserFeedbackProvider(oldProvider);
                }
            }
        };
        AbstractCicWizardView view = (AbstractCicWizardView)this.getContainer();
        if (this.progressText != null) {
            view.setJobName(this.progressText);
        } else {
            view.setJobName(Messages.AgentProgress);
        }
        this.previousLocaleLangsMap.clear();
        this.addedLocaleLangsMap.clear();
        this.removedLocaleLangsMap.clear();
        view.run(true, this.isJobCancelable(), op);
    }

    public boolean isJobCancelable() {
        return true;
    }

    public boolean performCancel() {
        this.performCancelForWizardPages((IProgressMonitor)new NullProgressMonitor());
        this.checkForProductRestart();
        this.unprepareJobs();
        return super.performCancel();
    }

    public boolean performDone() {
        if (this.completionPage != null) {
            this.completionPage.performDone();
        }
        this.checkForProductRestart();
        this.unprepareJobs();
        return super.performDone();
    }

    public boolean performFinish() {
        this.performBackgroundFinish();
        return false;
    }

    private void performCancelForWizardPages(IProgressMonitor monitor) {
        IStatus status;
        IWizardPage[] pages;
        IWizardPage[] iWizardPageArray = pages = this.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof AbstractAgentWizardPage) {
                ((AbstractAgentWizardPage)page).performCancel(monitor);
            }
            ++n2;
        }
        if (this.commonPanels != null) {
            iWizardPageArray = this.commonPanels;
            n = this.commonPanels.length;
            n2 = 0;
            while (n2 < n) {
                IWizardPage commonPanel = iWizardPageArray[n2];
                CustomPanel commonCustomPanel = (CustomPanel)commonPanel.getPanel();
                if (commonCustomPanel != null) {
                    try {
                        commonCustomPanel.performCancel(monitor);
                    }
                    catch (Exception e) {
                        status = SharedUIUtils.generateCustomPanelExceptionStatus(null, (ICustomPanel)commonCustomPanel, (Throwable)e);
                        AgentUI.reportStatus(status, true);
                    }
                }
                ++n2;
            }
        }
        if (this.panels != null) {
            iWizardPageArray = this.panels;
            n = this.panels.length;
            n2 = 0;
            while (n2 < n) {
                IWizardPage panel = iWizardPageArray[n2];
                CustomPanel customPanel = (CustomPanel)panel.getPanel();
                if (customPanel != null) {
                    try {
                        customPanel.performCancel(monitor);
                    }
                    catch (Exception e) {
                        status = SharedUIUtils.generateCustomPanelExceptionStatus(null, (ICustomPanel)customPanel, (Throwable)e);
                        AgentUI.reportStatus(status, true);
                    }
                }
                ++n2;
            }
        }
    }

    protected abstract IStatus performTask(IProgressMonitor var1);

    @Override
    public abstract void setInput(Object[] var1);

    private void unprepareJobs() {
        List selectedJobs = this.getSelectedJobs();
        AgentJob[] jobsArray = selectedJobs.toArray(new AgentJob[selectedJobs.size()]);
        Agent agent = AgentUI.getDefault().getAgent();
        IStatus status = agent.unprepare(jobsArray, (IProgressMonitor)new NullProgressMonitor());
        if (status.getSeverity() != 0) {
            AgentUI.getDefault().getLog().log(status);
        }
    }

    protected Map getPreviousLocaleLangsMap() {
        return this.previousLocaleLangsMap;
    }

    protected Map getAddedLocaleLangsMap() {
        return this.addedLocaleLangsMap;
    }

    protected Map getRemovedLocaleLangsMap() {
        return this.removedLocaleLangsMap;
    }

    public Map getOfferingOrFixLicenseTypeMap() {
        return this.offeringOrFixLicenseTypeMap;
    }

    public void setOfferingOrFixLicenseTypeMap(Map offeringOrFixLicenseTypeMap) {
        this.offeringOrFixLicenseTypeMap = offeringOrFixLicenseTypeMap;
    }

    private void checkForProductRestart() {
        List seljobs = this.getSelectedJobs();
        if (seljobs.size() == 0) {
            return;
        }
        AbstractJob job = (AbstractJob)seljobs.get(0);
        Profile profile = job.getProfile();
        AgentUIUtils.checkForProductRestart(this.getShell(), profile);
    }

    public boolean isMultipleProfileInstall() {
        return this.multipleProfile;
    }

    public void setMultipleProfileInstall(boolean multipleProfileInstall) {
        this.multipleProfile = multipleProfileInstall;
    }

    public void dispose() {
        super.dispose();
        if (this.completionPage != null) {
            this.completionPage.dispose();
        }
    }
}

