/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.views;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.ProfileOffering;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.views.PreviewTaskDetailsPage;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import java.util.Collection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ViewInstalledOfferingsDetailPage
extends PreviewTaskDetailsPage {
    private FormText installedFeatures;

    @Override
    public void createContents(Composite parent) {
        super.createContents(parent);
        Layout layout = parent.getLayout();
        if (layout != null && layout instanceof TableWrapLayout) {
            ((TableWrapLayout)layout).leftMargin = 8;
        }
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.installedFeatures = toolkit.createFormText(this.container, true);
        TableWrapData td = new TableWrapData(256, 16);
        this.installedFeatures.setLayoutData((Object)td);
    }

    @Override
    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = ((StructuredSelection)selection).getFirstElement();
        if (object == this.lastSelectedObject) {
            return;
        }
        super.selectionChanged(part, selection);
        if (object instanceof ProfileOffering) {
            Profile profile = ((ProfileOffering)object).getProfile();
            IOffering offering = ((ProfileOffering)object).getOffering();
            if (offering != null) {
                this.showInstalledFeatures(profile, offering);
            }
        } else {
            this.installedFeatures.setVisible(false);
        }
    }

    private void showInstalledFeatures(Profile profile, IOffering offering) {
        Agent agent = AgentUI.getDefault().getAgent();
        Collection visibleFeatures = AgentUtil.getVisibleInstalledFeatures((Agent)agent, (Profile)profile, (IOffering)offering);
        if (visibleFeatures.isEmpty()) {
            return;
        }
        StringBuffer installedFeatureList = new StringBuffer("<form>");
        installedFeatureList.append("<p>");
        installedFeatureList.append(Messages.ConfirmationPage_optionalFeatures);
        installedFeatureList.append("</p>");
        for (Object element : visibleFeatures) {
            IFeature feature = (IFeature)element;
            String featureLabel = SharedUIUtils.getFeatureBaseLabel((IFeatureBase)feature);
            if (featureLabel == null) continue;
            installedFeatureList.append("<li>");
            installedFeatureList.append(CommonUIUtils.escapeSpecialChars((String)featureLabel));
            installedFeatureList.append("</li>");
        }
        installedFeatureList.append("</form>");
        this.installedFeatures.setVisible(true);
        this.installedFeatures.setText(installedFeatureList.toString(), true, false);
        this.installedFeatures.getParent().layout();
    }
}

