/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.wizards.FeatureSelectionPage;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.ui.internal.CommonImages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class SummaryFeatureLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    protected AgentUILabelProvider agentLabelProvider = AgentUI.getDefault().getLabelProvider();

    public SummaryFeatureLabelProvider() {
        this.agentLabelProvider.connect((Object)this);
    }

    public Image getImage(Object element) {
        if (element instanceof AbstractJob) {
            IOfferingOrFix offeringOrFix = ((AbstractJob)element).getOfferingOrFix();
            if (offeringOrFix instanceof IOffering) {
                return this.agentLabelProvider.getOfferingImage((IOffering)offeringOrFix);
            }
            return this.agentLabelProvider.get(CommonImages.DESC_FIX_OBJ);
        }
        if (element instanceof FeatureSelectionPage.FeatureGroupNode || element instanceof IFeatureGroup) {
            return this.agentLabelProvider.get(CommonImages.DESC_FEATUREGROUP_OBJ);
        }
        if (element instanceof FeatureSelectionPage.FeatureNode || element instanceof IFeature) {
            return this.agentLabelProvider.get(CommonImages.DESC_FEATURE_OBJ);
        }
        if (element instanceof IOffering) {
            return this.agentLabelProvider.getOfferingImage((IOffering)element);
        }
        if (element instanceof IAdaptable) {
            Profile profile = (Profile)((IAdaptable)element).getAdapter(Profile.class);
            if (profile != null) {
                return this.agentLabelProvider.get(CommonImages.DESC_PROFILE_OBJ);
            }
            IOffering offering = (IOffering)((IAdaptable)element).getAdapter(IOffering.class);
            if (offering != null) {
                return this.agentLabelProvider.getOfferingImage(offering);
            }
            IFix fix = (IFix)((IAdaptable)element).getAdapter(IFix.class);
            if (fix != null) {
                return this.agentLabelProvider.get(CommonImages.DESC_FIX_OBJ);
            }
        }
        return null;
    }

    public String getText(Object element) {
        Profile profile;
        if (element instanceof AbstractJob) {
            AbstractJob job = (AbstractJob)element;
            IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
            return OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFix);
        }
        if (element instanceof FeatureSelectionPage.FeatureGroupNode) {
            String featureGroupName = SharedUIUtils.getFeatureBaseLabel((IFeatureBase)((FeatureSelectionPage.FeatureGroupNode)element).getFeatureGroup());
            if (featureGroupName.length() > 0) {
                return featureGroupName;
            }
            Object parent = ((FeatureSelectionPage.FeatureGroupNode)element).getParent();
            if (parent == null) {
                return "";
            }
            return this.getText(parent);
        }
        if (element instanceof FeatureSelectionPage.FeatureNode) {
            return SharedUIUtils.getFeatureBaseLabel((IFeatureBase)((FeatureSelectionPage.FeatureNode)element).getFeature());
        }
        if (element instanceof IFeatureGroup) {
            return SharedUIUtils.getFeatureBaseLabel((IFeatureBase)((IFeatureGroup)element));
        }
        if (element instanceof IFeature) {
            return SharedUIUtils.getFeatureBaseLabel((IFeatureBase)((IFeature)element));
        }
        if (element instanceof IOffering) {
            return OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)((IOffering)element));
        }
        if (element instanceof IAdaptable && (profile = (Profile)((IAdaptable)element).getAdapter(Profile.class)) != null) {
            return profile.getProfileId();
        }
        return "";
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getText(element);
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.agentLabelProvider.disconnect((Object)this);
        super.dispose();
    }
}

