/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.utils.FixNode;
import com.ibm.cic.agent.internal.ui.utils.PackageNode;
import com.ibm.cic.agent.internal.ui.utils.VersionNode;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class OfferingOrFixFilter
extends ViewerFilter {
    private String filterString = "";
    private final boolean filterOffering;

    public OfferingOrFixFilter(boolean filterOffering) {
        this.filterOffering = filterOffering;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        VersionNode elementNode;
        PackageNode parentNode;
        boolean isVersion;
        try {
            isVersion = ((VersionNode)element).isInstalled();
            isVersion = true;
        }
        catch (ClassCastException e) {
            isVersion = false;
        }
        if (!isVersion) {
            if (element instanceof PackageNode) {
                PackageNode elementNode2 = (PackageNode)element;
                if (elementNode2.getBaseNode() != null) {
                    if (this.filterString == null || this.filterString.length() == 0) {
                        elementNode2.getBaseNode().isSelectedBaseNode = false;
                        return true;
                    }
                    if (this.isElementVisible(viewer, element)) {
                        elementNode2.getBaseNode().selectBaseNode(true);
                        elementNode2.getBaseNode().selectByVersion(false);
                    }
                    int nodeI = 0;
                    while (nodeI < elementNode2.getChildren().size()) {
                        this.select(viewer, element, elementNode2.getChildren().get(nodeI));
                        ++nodeI;
                    }
                    if (elementNode2.getBaseNode().isSelectedBaseNode) {
                        return true;
                    }
                } else {
                    if (!elementNode2.prevFilter.equals(this.filterString)) {
                        elementNode2.isSelectedBaseNode = false;
                        elementNode2.selectByVersion(false);
                        elementNode2.prevFilter = this.filterString;
                    }
                    if (this.filterString == null || this.filterString.length() == 0) {
                        elementNode2.isSelectedBaseNode = false;
                        return true;
                    }
                    if (this.isElementVisible(viewer, element)) {
                        elementNode2.selectBaseNode(true);
                        elementNode2.selectByVersion(false);
                    }
                    int nodeI = 0;
                    while (nodeI < elementNode2.getChildren().size()) {
                        this.select(viewer, element, elementNode2.getChildren().get(nodeI));
                        ++nodeI;
                    }
                    if (elementNode2.isSelectedBaseNode) {
                        return true;
                    }
                    elementNode2.selectBaseNode(false);
                }
            }
        } else if (element instanceof VersionNode && (parentNode = (elementNode = (VersionNode)element).getParent()) != null) {
            PackageNode baseNode = parentNode.getBaseNode();
            if (baseNode != null) {
                if (this.filterString == null || this.filterString.length() == 0) {
                    parentNode.getBaseNode().isSelectedBaseNode = false;
                    return true;
                }
                if (this.isElementVisible(viewer, element)) {
                    parentNode.getBaseNode().selectBaseNode(true);
                    parentNode.getBaseNode().selectByVersion(false);
                }
                if (parentNode.getBaseNode().isSelectedBaseNode) {
                    return true;
                }
            } else {
                if (!elementNode.prevFilter.equals(this.filterString)) {
                    elementNode.selectVersion(true);
                    elementNode.prevFilter = this.filterString;
                }
                if (this.filterString == null || this.filterString.length() == 0) {
                    parentNode.isSelectedBaseNode = false;
                    return true;
                }
                if (this.isElementVisible(viewer, element)) {
                    parentNode.selectBaseNode(true);
                    elementNode.selectVersion(true);
                    parentNode.selectByVersion(true);
                } else {
                    elementNode.selectVersion(false);
                }
                if (!parentNode.isSelectByVersion) {
                    return parentNode.isSelectedBaseNode;
                }
                return elementNode.versionSelected;
            }
        }
        return this.isElementVisible(viewer, element);
    }

    public boolean isElementVisible(Viewer viewer, Object element) {
        return this.isParentMatch(viewer, element) || this.isLeafMatch(viewer, element);
    }

    private boolean isParentMatch(Viewer viewer, Object element) {
        Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
        if (children != null && children.length > 0) {
            return this.isAnyVisible(viewer, element, children);
        }
        return false;
    }

    private boolean isLeafMatch(Viewer viewer, Object element) {
        boolean showInternalVersion = AgentUI.getDefault().getAgentPreferenceStore().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key());
        if (this.filterOffering) {
            if (element instanceof VersionNode) {
                VersionNode vNode = (VersionNode)element;
                IOffering offering = vNode.getOffering();
                return OfferingUtil.isOfferingOrFixWithString((IOfferingOrFix)offering, (String)this.filterString, (boolean)showInternalVersion);
            }
        } else if (element instanceof FixNode) {
            AbstractJob job = ((FixNode)element).getJob();
            IFix fix = job.getFix();
            if (fix == null) {
                return false;
            }
            return OfferingUtil.isOfferingOrFixWithString((IOfferingOrFix)fix, (String)this.filterString, (boolean)showInternalVersion);
        }
        return false;
    }

    private boolean isAnyVisible(Viewer viewer, Object parent, Object[] elements) {
        boolean elementFound = false;
        int i = 0;
        while (i < elements.length && !elementFound) {
            Object element = elements[i];
            elementFound = this.isElementVisible(viewer, element);
            ++i;
        }
        return elementFound;
    }

    public void setFilterString(String filterText) {
        this.filterString = filterText;
    }
}

