/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.InstallOfferingJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.JarRepository;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class LicenseImportHelper {
    public static final String IS_LICENSE_KIT = "isLicenseKit";
    public static final String LUMKIT_EXTENSION = "*.jar";

    public InstallOfferingJob getInstallJob(IRepositoryGroup repoGroup, File zipfile) {
        String zipfilename = zipfile.getName();
        String zipfiledir = zipfile.getParent();
        IRepositoryInfo repInfo = repoGroup.createRepositoryInfo(zipfilename, "Jar", "0.0.0.1", (ICicLocation)new CicFileLocation(zipfiledir), null);
        JarRepository zippedRepo = new JarRepository();
        try {
            zippedRepo = repoGroup.addOrCreateRepository(repInfo);
            zippedRepo.getSiteProperties().setProperty(IS_LICENSE_KIT, "true");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Agent agent = AgentUI.getDefault().getAgent();
        NullProgressMonitor pm = new NullProgressMonitor();
        List offerings = zippedRepo.getAllOfferings((IProgressMonitor)pm);
        if (offerings.size() > 0) {
            IOffering offering = (IOffering)offerings.get(0);
            Logger.getGlobalLogger().statusNotOK(RepositoryUtils.resolve((IOfferingOrFix)offering, (IProgressMonitor)pm));
            Profile licprofile = Profile.getLicenseProfile((Agent)agent);
            IOffering installed = agent.getInstalledOffering(licprofile, offering.getIdentity());
            Object job = installed != null ? new UpdateOfferingJob(licprofile, offering) : new InstallOfferingJob(offering);
            job.setFeatures((Collection)offering.getFeatureGroup().getChildren());
            job.setProfile(licprofile);
            return job;
        }
        return null;
    }
}

