/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.api.ICustomPanel;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.custompanel.GeneratedSWTCustomPanel;
import com.ibm.cic.agent.internal.ui.utils.ConfigurationCustomPanelNode;
import com.ibm.cic.agent.internal.ui.utils.ConfigurationOfferingNode;
import com.ibm.cic.agent.internal.ui.utils.ConfigurationPanelTreeViewer;
import com.ibm.cic.agent.internal.ui.utils.CustomPanelProfileNode;
import com.ibm.cic.agent.ui.extensions.CustomPanel;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.internal.CommonImages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;

public class CustomPanelLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final AgentUILabelProvider agentUILabelProvider;
    private final ConfigurationPanelTreeViewer viewer;

    public CustomPanelLabelProvider(ConfigurationPanelTreeViewer treeViewer) {
        this.viewer = treeViewer;
        this.agentUILabelProvider = AgentUI.getDefault().getLabelProvider();
        this.agentUILabelProvider.connect((Object)this);
    }

    public void dispose() {
        this.agentUILabelProvider.disconnect((Object)this);
        super.dispose();
    }

    private boolean hasError(ConfigurationCustomPanelNode node) {
        boolean hasError;
        CustomPanel cp = node.getPanel();
        boolean bl = hasError = cp.getErrorMessage() != null;
        if (hasError) {
            return true;
        }
        if (cp instanceof GeneratedSWTCustomPanel) {
            GeneratedSWTCustomPanel generatedPanel = (GeneratedSWTCustomPanel)cp;
            boolean bl2 = hasError = generatedPanel.getErrorStatus() != null;
            if (hasError) {
                return true;
            }
            IStatus msgStatus = generatedPanel.getMessageStatus();
            if (msgStatus != null && StatusUtil.isErrorOrCancel((IStatus)msgStatus)) {
                return true;
            }
        }
        return false;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        block12: {
            if (columnIndex == 0) {
                if (element instanceof CustomPanelProfileNode) {
                    return this.agentUILabelProvider.get(CommonImages.DESC_PROFILE_OBJ);
                }
                if (element instanceof ConfigurationCustomPanelNode) {
                    ConfigurationCustomPanelNode panelNode = (ConfigurationCustomPanelNode)element;
                    try {
                        if (this.isCurrentSelectedNode(element)) {
                            return this.agentUILabelProvider.get(CICImages.DESC_ONGOING_OBJ);
                        }
                        if (this.hasError(panelNode)) {
                            if (panelNode.isVisited()) {
                                return this.agentUILabelProvider.get(CommonImages.LOG_ERROR);
                            }
                            return this.agentUILabelProvider.get(CICImages.DESC_MANDATORY_OBJ);
                        }
                        if (!panelNode.getPanel().isPageComplete()) {
                            return this.agentUILabelProvider.get(CICImages.DESC_MANDATORY_OBJ);
                        }
                        if (panelNode.getPanel().isPageComplete()) {
                            if (panelNode.isVisited()) {
                                return this.agentUILabelProvider.get(CICImages.DESC_COMPLETE_OBJ);
                            }
                            return null;
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        ConfigurationOfferingNode offNode = panelNode.getParent();
                        AgentJob job = offNode.getJob();
                        IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((AgentJob)job, (ICustomPanel)panelNode.getPanel(), (Throwable)e);
                        AgentUI.reportStatus(status, true);
                        return null;
                    }
                }
                if (element instanceof ConfigurationOfferingNode) {
                    IOffering offering = ((ConfigurationOfferingNode)element).getOffering();
                    return this.agentUILabelProvider.getOfferingImage(offering);
                }
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    private boolean isCurrentSelectedNode(Object element) {
        Object obj;
        ISelection selection;
        return element instanceof ConfigurationCustomPanelNode && this.viewer != null && (selection = this.viewer.getSelection()) != null && selection instanceof StructuredSelection && (obj = ((StructuredSelection)selection).getFirstElement()) == element;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof CustomPanelProfileNode) {
                return ((CustomPanelProfileNode)element).getProfile().getProfileId();
            }
            if (element instanceof ConfigurationOfferingNode) {
                return ((ConfigurationOfferingNode)element).toString();
            }
            if (element instanceof ConfigurationCustomPanelNode) {
                return ((ConfigurationCustomPanelNode)element).getNodeId();
            }
        }
        return "";
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }
}

