/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public class BitModeUIUtils {
    public static IStatus checkFixesSupportedPlatformsAgainstProfile(AgentJob[] jobs) {
        CicMultiStatus retStatus = Statuses.ST.createMultiStatus(Messages.Agent_unsatisfiedDependencies, new Object[0]);
        Collection profileJobsList = AgentUtil.groupByProfile((AgentJob[])jobs, (boolean)false);
        boolean multiprofile = profileJobsList.size() > 1;
        for (AgentJob[] profileJobs : profileJobsList) {
            Profile profile = profileJobs[0].getProfile();
            List fixes = AgentUtil.getFixesFromJobs((AgentJob[])profileJobs);
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            for (IFix fix : fixes) {
                IStatus status = BitModeUtils.checkSupportedPlatformsInOfferingOrFixAgainstProfile((IOfferingOrFix)fix, (IProfile)profile);
                if (status.isOK()) continue;
                statuses.add(status);
            }
            if (statuses.isEmpty()) continue;
            if (multiprofile) {
                CicMultiStatus ms = Statuses.ST.createMultiStatus(profile != null ? NLS.bind((String)Messages.Agent_unsatisfiedDependenciesInProfile, (Object)profile.getProfileId()) : Messages.Agent_unsatisfiedDependenciesInNullProfile, new Object[0]);
                ms.addAll(statuses);
                retStatus.add((IStatus)ms);
                continue;
            }
            retStatus.addAll(statuses);
        }
        return retStatus;
    }
}

