/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.preferences;

import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.downloads.FileCacheManager;
import com.ibm.cic.common.downloads.INonsecureConnectionPrompter;
import com.ibm.cic.common.downloads.NonsecureConnectionManager;
import com.ibm.cic.common.downloads.NonsecureConnectionPrompter;
import com.ibm.cic.common.downloads.NonsecureConnectionSessionState;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class InternetPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button useNonsecureMode;
    private Button permanent;
    private Button sessionOnly;

    public InternetPreferencePage() {
        this.setPreferenceStore(AgentUI.getDefault().getAgentPreferenceStore());
    }

    public void createControl(Composite parent) {
        Button restoreDefaultButton;
        super.createControl(parent);
        if (!SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)ICicPreferenceConstants.SSL_NONSECURE_MODE) && (restoreDefaultButton = this.getDefaultsButton()) != null) {
            restoreDefaultButton.setEnabled(false);
        }
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cic.agent.ui.InternetPreferencePage");
        this.initializeDialogUnits((Control)parent);
        Font font = parent.getFont();
        Composite rootComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        rootComposite.setLayout((Layout)layout);
        rootComposite.setLayoutData((Object)new GridData(1808));
        this.createNoteComposite(font, rootComposite, com.ibm.cic.agent.core.sharedUI.Messages.PreferencePage_Internet_Note, com.ibm.cic.agent.core.sharedUI.Messages.PreferencePage_Internet_NoteMsg);
        Group sslGroup = new Group(rootComposite, 0);
        layout = new GridLayout();
        layout.verticalSpacing = 8;
        sslGroup.setLayout((Layout)layout);
        sslGroup.setLayoutData((Object)new GridData(768));
        sslGroup.setText(com.ibm.cic.agent.core.sharedUI.Messages.PreferencePage_Internet_SSLGroup);
        Label sslLabel = new Label((Composite)sslGroup, 64);
        sslLabel.setFont(font);
        sslLabel.setText(com.ibm.cic.agent.core.sharedUI.Messages.PreferencePage_Internet_SSLLabel);
        GridData data = new GridData(768);
        data.widthHint = 220;
        sslLabel.setLayoutData((Object)data);
        Label sessionNoteLabel = new Label((Composite)sslGroup, 64);
        sessionNoteLabel.setFont(font);
        sessionNoteLabel.setText(com.ibm.cic.agent.core.sharedUI.Messages.PreferencePage_Internet_SessionNote);
        data = new GridData(768);
        data.widthHint = 220;
        sessionNoteLabel.setLayoutData((Object)data);
        this.useNonsecureMode = new Button((Composite)sslGroup, 32);
        this.useNonsecureMode.setFont(font);
        this.useNonsecureMode.setText(Messages.PreferencePage_Internet_NonsecureModeButton);
        this.useNonsecureMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (InternetPreferencePage.this.useNonsecureMode.getSelection()) {
                    InternetPreferencePage.this.permanent.setEnabled(true);
                    InternetPreferencePage.this.sessionOnly.setEnabled(true);
                } else {
                    InternetPreferencePage.this.permanent.setEnabled(false);
                    InternetPreferencePage.this.sessionOnly.setEnabled(false);
                }
            }
        });
        this.permanent = new Button((Composite)sslGroup, 16);
        this.permanent.setFont(font);
        this.permanent.setText(Messages.PreferencePage_Internet_Permanent);
        data = new GridData();
        data.horizontalIndent = 20;
        this.permanent.setLayoutData((Object)data);
        this.permanent.setEnabled(false);
        this.sessionOnly = new Button((Composite)sslGroup, 16);
        this.sessionOnly.setFont(font);
        this.sessionOnly.setText(Messages.PreferencePage_Internet_SessionOnly);
        data = new GridData();
        data.horizontalIndent = 20;
        this.sessionOnly.setLayoutData((Object)data);
        this.sessionOnly.setEnabled(false);
        this.loadValues();
        return rootComposite;
    }

    protected Composite createNoteComposite(Font font, Composite composite, String title, String message) {
        Composite messageComposite = new Composite(composite, 0);
        GridLayout messageLayout = new GridLayout();
        messageLayout.numColumns = 2;
        messageLayout.marginWidth = 0;
        messageLayout.marginHeight = 0;
        messageComposite.setLayout((Layout)messageLayout);
        messageComposite.setLayoutData((Object)new GridData(256));
        messageComposite.setFont(font);
        final Label noteLabel = new Label(messageComposite, 1);
        noteLabel.setText(title);
        noteLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        noteLabel.setLayoutData((Object)new GridData(2));
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.bannerfont".equals(event.getProperty())) {
                    noteLabel.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(fontListener);
        noteLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                JFaceResources.getFontRegistry().removeListener(fontListener);
            }
        });
        Label messageLabel = new Label(messageComposite, 64);
        messageLabel.setText(message);
        messageLabel.setFont(font);
        GridData data = new GridData(768);
        data.widthHint = 180;
        messageLabel.setLayoutData((Object)data);
        return messageComposite;
    }

    private void loadValues() {
        IPreferenceStore pStore = this.getPreferenceStore();
        boolean nonsecureMode = pStore.getBoolean(ICicPreferenceConstants.SSL_NONSECURE_MODE.key());
        if (nonsecureMode) {
            this.useNonsecureMode.setSelection(true);
            this.permanent.setEnabled(true);
            this.permanent.setSelection(true);
            this.sessionOnly.setEnabled(true);
            this.sessionOnly.setSelection(false);
        } else if (NonsecureConnectionSessionState.INSTANCE.isNonsecureMode()) {
            this.useNonsecureMode.setSelection(true);
            this.permanent.setEnabled(true);
            this.permanent.setSelection(false);
            this.sessionOnly.setEnabled(true);
            this.sessionOnly.setSelection(true);
        } else {
            this.useNonsecureMode.setSelection(false);
            this.permanent.setEnabled(false);
            this.permanent.setSelection(false);
            this.sessionOnly.setEnabled(false);
            this.sessionOnly.setSelection(true);
        }
        if (!SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)ICicPreferenceConstants.SSL_NONSECURE_MODE)) {
            this.useNonsecureMode.setEnabled(false);
            this.permanent.setEnabled(false);
            this.sessionOnly.setEnabled(false);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.loadValues();
        }
        super.setVisible(visible);
    }

    public void init(IWorkbench workbench) {
    }

    public void performApply() {
        super.performApply();
        this.checkRepositoryStatus();
        AgentUI.getDefault().getAgent().resetPassportAdvantageRepository();
    }

    private void checkRepositoryStatus() {
        FileCacheManager.getInstance().reset();
        INonsecureConnectionPrompter previousPrompter = NonsecureConnectionPrompter.INSTANCE.getPrompter();
        NonsecureConnectionPrompter.INSTANCE.setPrompter(null);
        try {
            IPreferencePage page;
            PreferenceDialog prefDialog = (PreferenceDialog)this.getContainer();
            IPreferenceNode repositoryNode = prefDialog.getPreferenceManager().find("com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage");
            if (repositoryNode != null && (page = repositoryNode.getPage()) != null && page instanceof AgentMainPreferencePage) {
                ((AgentMainPreferencePage)page).resetAccessibility();
                ((AgentMainPreferencePage)page).updateRepositoryTableViewer();
            }
        }
        finally {
            NonsecureConnectionPrompter.INSTANCE.setPrompter(previousPrompter);
        }
    }

    public boolean performOk() {
        if (this.useNonsecureMode.getSelection()) {
            if (this.sessionOnly.getSelection()) {
                NonsecureConnectionSessionState.INSTANCE.setNonsecureMode(true);
                this.getPreferenceStore().setValue(ICicPreferenceConstants.SSL_NONSECURE_MODE.key(), false);
            } else {
                NonsecureConnectionSessionState.INSTANCE.setNonsecureMode(false);
                this.getPreferenceStore().setValue(ICicPreferenceConstants.SSL_NONSECURE_MODE.key(), true);
            }
        } else {
            NonsecureConnectionSessionState.INSTANCE.setNonsecureMode(false);
            this.getPreferenceStore().setValue(ICicPreferenceConstants.SSL_NONSECURE_MODE.key(), false);
        }
        NonsecureConnectionManager.INSTANCE.dropConnections();
        return true;
    }

    protected void performDefaults() {
        if (SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)ICicPreferenceConstants.SSL_NONSECURE_MODE)) {
            boolean permanentNonsecureMode = this.getPreferenceStore().getDefaultBoolean(ICicPreferenceConstants.SSL_NONSECURE_MODE.key());
            if (permanentNonsecureMode) {
                this.useNonsecureMode.setSelection(true);
                this.permanent.setEnabled(true);
                this.permanent.setSelection(false);
                this.sessionOnly.setEnabled(true);
                this.sessionOnly.setSelection(true);
            } else {
                this.useNonsecureMode.setSelection(false);
                this.permanent.setEnabled(false);
                this.permanent.setSelection(false);
                this.sessionOnly.setEnabled(false);
                this.sessionOnly.setSelection(true);
            }
            NonsecureConnectionManager.INSTANCE.dropConnections();
        }
        super.performDefaults();
    }
}

