/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.actions;

import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.dialogs.ZipFilesDialog;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ExportDataAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public ExportDataAction(IWorkbenchWindow window) {
        this.window = window;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow windows) {
        this.window = windows;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        final IStatus[] result_status = new IStatus[1];
        ZipFilesDialog zipDlg = new ZipFilesDialog(this.window.getShell());
        if (zipDlg.open() == 0) {
            final String destinationFile = zipDlg.getZipDestinationFile();
            try {
                CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        try {
                            monitor.beginTask(Messages.LogSection_zip_progress, 10);
                            result_status[0] = AgentUtil.zipAgentAppDataWithAdditionalFiles((String)destinationFile, null, (IProgressMonitor)monitor);
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e1) {
                AgentUI.reportException(e1);
            }
            catch (InterruptedException e2) {
                AgentUI.reportException(e2);
            }
        }
        if (result_status[0] != null) {
            String errorMsg;
            if (result_status[0].matches(4)) {
                errorMsg = result_status[0].getMessage();
                if (errorMsg == null || errorMsg.trim().length() == 0) {
                    WrapDetailUIDErrorDialog.openError((Shell)this.window.getShell(), null, (String)Messages.LogSection_zipErrorOccurred, (IStatus)result_status[0]);
                } else {
                    WrapDetailUIDErrorDialog.openError((Shell)this.window.getShell(), null, null, (IStatus)result_status[0]);
                }
            } else if (result_status[0].matches(8)) {
                errorMsg = result_status[0].getMessage();
                if (errorMsg == null || errorMsg.trim().length() == 0) {
                    Status constructedStatus = new Status(result_status[0].getSeverity(), result_status[0].getPlugin(), result_status[0].getCode(), Messages.LogSection_zippingWasCanceled, result_status[0].getException());
                    WrapDetailUIDErrorDialog.openError((Shell)this.window.getShell(), null, null, (IStatus)constructedStatus, (int)8);
                } else {
                    WrapDetailUIDErrorDialog.openError((Shell)this.window.getShell(), null, (String)Messages.LogSection_zippingWasCanceled, (IStatus)result_status[0], (int)8);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

