/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.actions;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.sharedUI.SharedUpdateAgentUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.utils.UpdateAgentUtils;
import com.ibm.cic.agent.ui.extensions.AbstractAgentUIAction;
import com.ibm.cic.common.core.sharedUI.Messages;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AgentUIAction
extends AbstractAgentUIAction {
    public AgentUIAction(IWorkbenchWindow window) {
        super(window);
    }

    public AgentUIAction() {
    }

    protected IStatus checkRepositories(IProgressMonitor monitor) {
        try {
            IStatus status;
            SubProgressMonitor sm;
            block11: {
                block10: {
                    IStatus iStatus;
                    String msg = com.ibm.cic.agent.core.sharedUI.Messages.ProgressDialog_Checking_Repositories;
                    monitor.beginTask(msg, 2);
                    monitor.setTaskName(msg);
                    monitor.worked(1);
                    sm = new SubProgressMonitor(monitor, 1);
                    try {
                        status = AgentUI.getDefault().getAgent().getRepositoryGroupStatus(true, (IProgressMonitor)sm);
                        if (!status.matches(8)) break block10;
                        iStatus = status;
                    }
                    catch (Throwable throwable) {
                        sm.done();
                        throw throwable;
                    }
                    sm.done();
                    return iStatus;
                }
                if (!monitor.isCanceled()) break block11;
                IStatus iStatus = Status.CANCEL_STATUS;
                sm.done();
                return iStatus;
            }
            this.displayMessages(status);
            IStatus iStatus = Status.OK_STATUS;
            sm.done();
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected IStatus checkForUpdates(IProgressMonitor monitor) {
        try {
            IStatus status;
            SubProgressMonitor sm;
            block11: {
                block10: {
                    CicMultiStatus cicMultiStatus;
                    String msg = com.ibm.cic.agent.core.sharedUI.Messages.ProgressDialog_Checking_Agent_Update;
                    monitor.beginTask(msg, 2);
                    monitor.setTaskName(msg);
                    sm = new SubProgressMonitor(monitor, 1);
                    try {
                        if (Agent.getInstance().searchForAgentUpdate()) break block10;
                        cicMultiStatus = Statuses.ST.createMultiStatus(-51, null, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        sm.done();
                        throw throwable;
                    }
                    sm.done();
                    return cicMultiStatus;
                }
                status = UpdateAgentUtils.checkForAgentUpdateNDisplayServiceRepStatus((IProgressMonitor)sm);
                if (!StatusUtil.isCancel((IStatus)status)) break block11;
                CicMultiStatus cicMultiStatus = Statuses.ST.createMultiStatus(-51, null, new Object[0]);
                sm.done();
                return cicMultiStatus;
            }
            monitor.worked(1);
            IStatus iStatus = status;
            sm.done();
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private void displayMessages(final IStatus status) {
        DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AgentUIAction.this.doDisplayMessages(status);
            }
        });
    }

    private void doDisplayMessages(IStatus status) {
        Boolean[] isWarning = new Boolean[]{Boolean.FALSE};
        CicMultiStatus crStatus = SharedUpdateAgentUtils.getConnectionAndRepositoryMessageStatus((IStatus)status, (Boolean[])isWarning);
        if (!status.isOK()) {
            crStatus.mapErrorToWarning();
            Logger.getGlobalLogger().status((IStatus)crStatus);
            Shell shell = CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell();
            WrapDetailUIDErrorDialog errorDialog = new WrapDetailUIDErrorDialog(shell, Messages.DialogTitle_Warning, null, (IStatus)crStatus, 15);
            errorDialog.open();
        } else {
            String repMessages = crStatus.getMessage();
            if (repMessages.length() > 0) {
                Shell shell = CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell();
                if (isWarning[0].booleanValue()) {
                    MessageDialog.openWarning((Shell)shell, (String)Messages.AddRepositoryDialog_RepWarning, (String)repMessages);
                } else {
                    MessageDialog.openInformation((Shell)shell, (String)Messages.AddRepositoryDialog_RepInfo, (String)repMessages);
                }
            }
        }
    }

    protected void runChecksForRepositoriesAndAgentUpdate() throws InvocationTargetException, InterruptedException {
        final boolean[] notSwitchPerspective = new boolean[1];
        CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                SubProgressMonitor sm = null;
                monitor.beginTask("", 3);
                try {
                    sm = new SubProgressMonitor(monitor, 1);
                    IStatus return_value = AgentUIAction.this.checkRepositories((IProgressMonitor)sm);
                    if (!return_value.isOK()) {
                        notSwitchPerspective[0] = true;
                        return;
                    }
                    sm = new SubProgressMonitor(monitor, 1);
                    return_value = AgentUIAction.this.checkForUpdates((IProgressMonitor)sm);
                    if (StatusUtil.isErrorOrCancel((IStatus)return_value) || return_value.getCode() != -51) {
                        notSwitchPerspective[0] = true;
                        return;
                    }
                    sm = new SubProgressMonitor(monitor, 1);
                    AgentUIAction.this.run((IProgressMonitor)sm);
                    if (sm.isCanceled()) {
                        notSwitchPerspective[0] = true;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
        if (!notSwitchPerspective[0]) {
            this.showWizardPerspective();
        }
    }
}

