/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.internal.dialogs.YesNoErrorDialog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CheckAgentRequirementInteraction
implements Runnable {
    private CicMultiStatus status;
    private final IOffering offering;
    private String buttonLabel1 = null;
    private String buttonLabel2 = null;

    public CheckAgentRequirementInteraction(IOffering offering, CicMultiStatus status) {
        this.offering = offering;
        this.status = status;
    }

    public CheckAgentRequirementInteraction(IOffering offering, CicMultiStatus status, String buttonLabel1, String buttonLabel2) {
        this(offering, status);
        this.buttonLabel1 = buttonLabel1;
        this.buttonLabel2 = buttonLabel2;
    }

    @Override
    public void run() {
        YesNoErrorDialog dialog = null;
        dialog = this.buttonLabel1 == null && this.buttonLabel2 == null ? new YesNoErrorDialog(CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell(), Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, null, (IStatus)this.status, 2) : new YesNoErrorDialog(CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell(), Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, null, (IStatus)this.status, 2, this.buttonLabel1, this.buttonLabel2);
        if (dialog.open() != 2) {
            this.status = Statuses.ST.createMultiStatusWithChild(Status.CANCEL_STATUS, "", new Object[0]);
            this.status.setCode(-50);
            return;
        }
        IStatus agentRequirementStatus = Agent.getInstance().checkAgentRequirement((IOfferingOrFix)this.offering, AgentUI.getDefault().getAgentPreferenceStore().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key()));
        if (!agentRequirementStatus.isOK()) {
            CicMultiStatus displayStatus = Statuses.ST.createMultiStatus(agentRequirementStatus.getPlugin(), agentRequirementStatus.getSeverity(), agentRequirementStatus.getCode(), null, null, agentRequirementStatus.getMessage());
            displayStatus.add((IStatus)new Status(4, "com.ibm.cic.agent.ui", 0, com.ibm.cic.agent.core.sharedUI.Messages.AgentUIAction_agentUpdateNotPossible, null));
            new WrapDetailUIDErrorDialog(CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell(), Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, null, (IStatus)displayStatus, 4).open();
            this.status = Statuses.ST.createMultiStatusWithChild(Status.CANCEL_STATUS, "", new Object[0]);
            return;
        }
        this.status = Statuses.ST.createMultiStatus();
    }

    public CicMultiStatus getStatus() {
        return this.status;
    }
}

