/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentRelaunch;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.CommandRecorder;
import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.application.AAgentApplication;
import com.ibm.cic.agent.core.application.HeadlessApplication;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.utils.InstallJobTracker;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUIWorkbenchAdvisor;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.dialogs.DataLocationDialog;
import com.ibm.cic.agent.internal.ui.dialogs.EnterpriseDeploymentToolsDialog;
import com.ibm.cic.agent.internal.ui.dialogs.PasswordDialog;
import com.ibm.cic.common.core.api.utils.EncryptionUtils;
import com.ibm.cic.common.core.auth.AuthorizationInfo;
import com.ibm.cic.common.core.auth.AuthorizationInfoFromSecureStorage;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.JettyDataKeeper;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.downloads.CredentialStore;
import com.ibm.cic.common.downloads.NonsecureConnectionManager;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.EncryptStringDialog;
import com.ibm.cic.common.ui.internal.dialogs.PasswordKeyDialog;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class AgentUIApplication
extends AAgentApplication {
    private Display m_display = null;
    private static final String PASSPHRASE = "passphrase";

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        Object result = this.launch(context, args);
        if (this.m_display != null && !this.m_display.isDisposed()) {
            try {
                this.m_display.dispose();
            }
            catch (Throwable t) {
                AgentUI.reportException(t, false);
            }
        }
        PlatformUtils.disableErrorOutput();
        return AgentRelaunch.getInstance().checkForRelaunch(result);
    }

    protected void reportError(IStatus a_status, String message) {
        AgentUI.reportStatus(a_status, false);
        if (this.m_display == null) {
            super.reportError(a_status, message);
            Agent.getInstance().flushStdoutBuffer();
        } else {
            Shell shell = this.m_display.getActiveShell();
            String title = null;
            title = a_status.matches(1) ? Messages.AgentUIWorkbenchWindowAdvisor_windowTitle : com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error;
            WrapDetailUIDErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)a_status);
        }
    }

    protected void reportInfo(String message) {
        if (this.m_display == null) {
            super.reportInfo(message);
            Agent.getInstance().flushStdoutBuffer();
        } else {
            Shell shell = this.m_display.getActiveShell();
            MessageDialog.openInformation((Shell)shell, (String)com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Info, (String)message);
        }
    }

    protected int promptForDataLocation() {
        DataLocationDialog dlg = new DataLocationDialog(this.getShell());
        return dlg.open();
    }

    private boolean initDisplay() {
        if (this.m_display == null) {
            try {
                CicCommonUiPlugin.getDefault().clearCache();
                this.m_display = PlatformUI.createDisplay();
            }
            catch (UnsatisfiedLinkError ule) {
                AgentUI.reportException(ule, false);
            }
        }
        if (this.m_display != null) {
            DisplayKeeper.INSTANCE.setDisplay(this.m_display);
        }
        return this.m_display != null;
    }

    /*
     * Unable to fully structure code
     */
    private Object launch(IApplicationContext context, String[] args) {
        block80: {
            block79: {
                block75: {
                    block76: {
                        block77: {
                            block78: {
                                block73: {
                                    block74: {
                                        block72: {
                                            block71: {
                                                block70: {
                                                    block69: {
                                                        block68: {
                                                            block81: {
                                                                block67: {
                                                                    block66: {
                                                                        cmd_status = CmdLine.CL.loadCommandLineData(args);
                                                                        if (!CicCommonSettings.isWindows()) {
                                                                            this.updateUmask();
                                                                        }
                                                                        if (CmdLine.CL.isSilentMode()) {
                                                                            return HeadlessApplication.runHeadlessApplication(null, (String[])args);
                                                                        }
                                                                        if (CmdLine.CL.isServerMode() && !this.initWebClient()) {
                                                                            return 1;
                                                                        }
                                                                        if (!this.initDisplay()) {
                                                                            this.reportInfo(NLS.bind((String)Messages.StartUp_DispalyFailedToInitialize, (Object)Platform.getLogFileLocation()));
                                                                            return 1;
                                                                        }
                                                                        if (!cmd_status.isOK()) {
                                                                            this.reportError(cmd_status, Messages.AgentUIApplication_IncorrectCommandLine);
                                                                            return 1;
                                                                        }
                                                                        return_value = this.processCommonCommandLineArguments();
                                                                        if (return_value != null) {
                                                                            return IApplication.EXIT_OK;
                                                                        }
                                                                        display = this.m_display;
                                                                        advisor = null;
                                                                        try {
                                                                            accessRightsStatus = Agent.getAccessRightsStatus();
                                                                            if (accessRightsStatus.isOK()) ** GOTO lbl43
                                                                            if (accessRightsStatus.getSeverity() != 4) break block66;
                                                                            this.reportError(accessRightsStatus, null);
                                                                            var20_8 = IApplication.EXIT_OK;
                                                                        }
                                                                        catch (Throwable var19_58) {
                                                                            try {
                                                                                this.endSplash(context, advisor);
                                                                            }
                                                                            catch (Throwable t) {
                                                                                AgentUI.reportException(t, false);
                                                                            }
                                                                            throw var19_58;
                                                                        }
                                                                        try {
                                                                            this.endSplash(context, advisor);
                                                                        }
                                                                        catch (Throwable t) {
                                                                            AgentUI.reportException(t, false);
                                                                        }
                                                                        return var20_8;
                                                                    }
                                                                    MessageDialog.openWarning((Shell)display.getActiveShell(), null, (String)accessRightsStatus.getMessage());
lbl43:
                                                                    // 2 sources

                                                                    if ((instanceAreaStatus = CicCommonSettings.setInstanceArea()).isOK()) break block67;
                                                                    this.reportError(instanceAreaStatus, null);
                                                                    var20_9 = IApplication.EXIT_OK;
                                                                    try {
                                                                        this.endSplash(context, advisor);
                                                                    }
                                                                    catch (Throwable t) {
                                                                        AgentUI.reportException(t, false);
                                                                    }
                                                                    return var20_9;
                                                                }
                                                                value = CmdLine.CL.getParam1StrVal("-passwordKey");
                                                                if (value != null) break block68;
                                                                if (!CmdLine.CL.containsCommand("-passwordKey")) ** GOTO lbl76
                                                                pwd = new PasswordKeyDialog(display.getActiveShell());
                                                                if (pwd.open() != 0) break block81;
                                                                EncryptionUtils.setPasswordKey((String)pwd.getPasswordKey());
                                                                ** GOTO lbl76
                                                            }
                                                            agentStartStatus = new Status(4, Agent.PI_AGENT, 0, com.ibm.cic.common.core.internal.Messages.PasswordKey_KeyWasNotSetByTheUser, null);
                                                            AgentUI.reportStatus((IStatus)agentStartStatus, false);
                                                            var20_10 = IApplication.EXIT_OK;
                                                            try {
                                                                this.endSplash(context, advisor);
                                                            }
                                                            catch (Throwable t) {
                                                                AgentUI.reportException(t, false);
                                                            }
                                                            return var20_10;
                                                        }
                                                        EncryptionUtils.setPasswordKey((String)value);
lbl76:
                                                        // 3 sources

                                                        if ((value = CmdLine.CL.getParam1StrVal("encryptString")) == null) break block69;
                                                        pwd = new EncryptStringDialog(display.getActiveShell(), value);
                                                        pwd.open();
                                                        var20_11 = IApplication.EXIT_OK;
                                                        try {
                                                            this.endSplash(context, advisor);
                                                        }
                                                        catch (Throwable t) {
                                                            AgentUI.reportException(t, false);
                                                        }
                                                        return var20_11;
                                                    }
                                                    recordFile = CmdLine.CL.getParam1StrVal("-record");
                                                    if (recordFile == null || (status = CommandRecorder.validateRecordFile((String)recordFile)).isOK()) break block70;
                                                    this.reportError(status, null);
                                                    var20_12 = 1;
                                                    try {
                                                        this.endSplash(context, advisor);
                                                    }
                                                    catch (Throwable t) {
                                                        AgentUI.reportException(t, false);
                                                    }
                                                    return var20_12;
                                                }
                                                agentInstallCheck = AgentInstall.getInstance().checkForAgentInstall();
                                                if (agentInstallCheck.isOK()) break block71;
                                                this.reportError(agentInstallCheck, null);
                                                var20_13 = IApplication.EXIT_OK;
                                                try {
                                                    this.endSplash(context, advisor);
                                                }
                                                catch (Throwable t) {
                                                    AgentUI.reportException(t, false);
                                                }
                                                return var20_13;
                                            }
                                            if (!AgentRelaunch.getInstance().needsRelaunch()) break block72;
                                            var20_14 = IApplication.EXIT_RESTART;
                                            try {
                                                this.endSplash(context, advisor);
                                            }
                                            catch (Throwable t) {
                                                AgentUI.reportException(t, false);
                                            }
                                            return var20_14;
                                        }
                                        if (!AgentInstall.getInstance().isInstallFromMultipleDisks()) break block73;
                                        d = new TopLevelProgressMonitorDialog(display.getActiveShell());
                                        status = new IStatus[]{Status.OK_STATUS};
                                        try {
                                            d.run(true, true, new IRunnableWithProgress(){

                                                public void run(IProgressMonitor monitor) {
                                                    status[0] = AgentInstall.getInstance().relaunchWithTemporaryInstaller(monitor);
                                                }
                                            });
                                        }
                                        catch (Exception e) {
                                            status[0] = new Status(4, Agent.PI_AGENT, 0, e.toString(), null);
                                        }
                                        if (!status[0].isOK() || d.getProgressMonitor().isCanceled()) {
                                            cancelStatus = AgentInstall.getInstance().cancelRelaunchWithTemporaryInstaller();
                                            if (status[0].isOK()) {
                                                status[0] = cancelStatus;
                                            }
                                        }
                                        if (!status[0].isOK()) break block74;
                                        var20_15 = IApplication.EXIT_RESTART;
                                        try {
                                            this.endSplash(context, advisor);
                                        }
                                        catch (Throwable t) {
                                            AgentUI.reportException(t, false);
                                        }
                                        return var20_15;
                                    }
                                    this.reportError(status[0], null);
                                    var20_16 = IApplication.EXIT_OK;
                                    try {
                                        this.endSplash(context, advisor);
                                    }
                                    catch (Throwable t) {
                                        AgentUI.reportException(t, false);
                                    }
                                    return var20_16;
                                }
                                if (!CmdLine.CL.isEnterpriseDeploymentTools()) break block75;
                                dlg = new EnterpriseDeploymentToolsDialog(this.m_display.getActiveShell());
                                if (dlg.open() != 0) break block76;
                                if (!dlg.isGenResponseFileSkipInstall()) break block77;
                                skipInstallDir = dlg.getGenResponseFileSkipInstDir();
                                newCommands = new String[]{"-skipInstall", skipInstallDir, "-record", responseFile = dlg.getGenResponseFileSkipInstFile()};
                                loadCommandStatus = CmdLine.CL.loadCommandLineData(newCommands);
                                if (loadCommandStatus.isOK()) break block78;
                                this.reportError(loadCommandStatus, null);
                                var20_17 = IApplication.EXIT_OK;
                                try {
                                    this.endSplash(context, advisor);
                                }
                                catch (Throwable t) {
                                    AgentUI.reportException(t, false);
                                }
                                return var20_17;
                            }
                            status = AgentUtil.validateAndSetDataLocation();
                            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                                AgentUI.reportStatus(status, false);
                            }
                            if ((setInstanceAreaStatus = CicCommonSettings.setInstanceArea()).isOK()) break block75;
                            this.reportError(setInstanceAreaStatus, null);
                            var20_18 = IApplication.EXIT_OK;
                            try {
                                this.endSplash(context, advisor);
                            }
                            catch (Throwable t) {
                                AgentUI.reportException(t, false);
                            }
                            return var20_18;
                        }
                        if (dlg.isPortableInstall()) {
                            CicCommonSettings.setPortable((boolean)true);
                            break block75;
                        }
                        if (dlg.isGenResponseFileInstalledPkg()) {
                            AgentInput.getInstance().setMode(1);
                            AgentInput.getInstance().setWizardSubMode(7);
                            break block75;
                        }
                        if (dlg.isGenResponseFilePkg()) {
                            AgentInput.getInstance().setMode(1);
                            AgentInput.getInstance().setWizardSubMode(8);
                            break block75;
                        }
                        var20_19 = IApplication.EXIT_OK;
                        try {
                            this.endSplash(context, advisor);
                        }
                        catch (Throwable t) {
                            AgentUI.reportException(t, false);
                        }
                        return var20_19;
                    }
                    var20_20 = IApplication.EXIT_OK;
                    try {
                        this.endSplash(context, advisor);
                    }
                    catch (Throwable t) {
                        AgentUI.reportException(t, false);
                    }
                    return var20_20;
                }
                advisor = new AgentUIWorkbenchAdvisor();
                returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)advisor);
                if (!AgentRelaunch.getInstance().needsRelaunch() || !CmdLine.CL.isServerMode()) break block79;
                var20_21 = IApplication.EXIT_RESTART;
                try {
                    this.endSplash(context, advisor);
                }
                catch (Throwable t) {
                    AgentUI.reportException(t, false);
                }
                return var20_21;
            }
            if (returnCode != 1) break block80;
            var20_22 = IApplication.EXIT_RESTART;
            try {
                this.endSplash(context, advisor);
            }
            catch (Throwable t) {
                AgentUI.reportException(t, false);
            }
            return var20_22;
        }
        if (returnCode == 2) {
            throw new IllegalStateException();
        }
        var20_23 = IApplication.EXIT_OK;
        try {
            this.endSplash(context, advisor);
        }
        catch (Throwable t) {
            AgentUI.reportException(t, false);
        }
        return var20_23;
    }

    private boolean initWebClient() {
        IAgentJob job;
        Object clientPassphrase;
        boolean result = true;
        AgentInput.getInstance().setMode(3);
        if (!UiServices.getInstance().isWebPlatformActive()) {
            return false;
        }
        UiServices.getInstance().configureSession();
        String serverPassphrase = JettyDataKeeper.INSTANCE.getPasscode();
        if (!(serverPassphrase == null || (clientPassphrase = UiServices.getInstance().getServerAttribute(PASSPHRASE)) != null && clientPassphrase.equals(serverPassphrase))) {
            Shell shell = this.getShell();
            PasswordDialog dialog = new PasswordDialog(shell, Messages.AgentUIApplication_serverPasswordDialogTitle, Messages.AgentUIApplication_serverPasswordDialogMessage, "", null);
            boolean correctUserInput = false;
            while (!correctUserInput) {
                if (dialog.open() == 0) {
                    String userValue = dialog.getValue();
                    if (userValue.equals(serverPassphrase)) {
                        try {
                            correctUserInput = true;
                            UiServices.getInstance().setServerAttribute(PASSPHRASE, userValue);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        dialog.close();
                        continue;
                    }
                    MessageDialog.openError((Shell)shell, (String)Messages.AgentUIApplication_badPassphraseTitle, (String)Messages.AgentUIApplication_badPassphraseMessage);
                    continue;
                }
                UiServices.getInstance().sendServerError(403, null);
                result = false;
            }
        }
        if ((job = InstallJobTracker.INSTANCE.current()) != null) {
            JettyDataKeeper.INSTANCE.setUISessionDestroyed(true);
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.AgentUIApplication_anotherSessionRunningTitle, (String)NLS.bind((String)Messages.AgentUIApplication_anotherSessionFail, (Object)job.toString()));
            result = false;
        } else {
            Display display = DisplayKeeper.INSTANCE.getDisplay();
            if (display != null && !display.isDisposed()) {
                result = false;
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.AgentUIApplication_anotherSessionRunningTitle, (String)Messages.AgentUIApplication_anotherSessionTakeover)) {
                    this.terminateAgentSession(display);
                } else {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, (String)Messages.AgentUIApplication_SessionAbortedMessage);
                    UiServices.getInstance().sendServerError(403, Messages.AgentUIApplication_SessionAbortedMessage);
                }
            }
        }
        return result;
    }

    private void terminateAgentSessionWithoutServerRestart(Display display) {
        if (!AuthorizationInfo.isLegacyKeyringActive()) {
            AuthorizationInfoFromSecureStorage.clearCache();
        }
        CredentialStore.INSTANCE.clearCache();
        NonsecureConnectionManager.INSTANCE.dropConnections();
        UiServices.getInstance().killSession(display);
        this.m_display = null;
    }

    private void terminateAgentSession(Display display) {
        UiServices.getInstance().restartWorkbench();
        this.m_display = null;
    }

    private Display getDisplay() {
        Display display = this.m_display;
        if (display == null) {
            this.m_display = display = Display.getDefault();
        }
        return this.m_display;
    }

    private Shell getShell() {
        Shell shell = this.getDisplay().getActiveShell();
        if (shell == null) {
            shell = new Shell(this.getDisplay());
        }
        return shell;
    }

    private void endSplash(IApplicationContext context, AgentUIWorkbenchAdvisor advisor) {
        if (advisor != null && advisor.isPostStartup()) {
            return;
        }
        context.applicationRunning();
    }

    private void updateUmask() {
        String accessRightsValue = CmdLine.CL.getParam1StrVal("-accessRights");
        if (accessRightsValue != null && CicCommonSettings.AccessRights.GROUP_MODE.isMode(accessRightsValue)) {
            PlatformUtils.setGroupBitUmaskForCurrentIMProcess();
        } else {
            PlatformUtils.updateUmaskforCurrentIMProcess((int)0, (int)18);
        }
    }

    private static class TopLevelProgressMonitorDialog
    extends ProgressMonitorDialog {
        public TopLevelProgressMonitorDialog(Shell parent) {
            super(parent);
            this.setShellStyle(this.getShellStyle() | 0x40);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.AgentUIWorkbenchWindowAdvisor_windowTitle);
        }

        protected void aboutToRun() {
            super.aboutToRun();
            this.clearCursors();
        }

        protected void handleShellCloseEvent() {
            this.cancelPressed();
        }
    }
}

