/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.history.impl;

import com.ibm.cic.agent.internal.core.history.IActivity;
import com.ibm.cic.agent.internal.core.history.IHistory;
import com.ibm.cic.agent.internal.core.history.IOfferingInfo;
import com.ibm.cic.agent.internal.core.history.impl.XMLElement;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.LogUtil;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ActivityImpl
extends XMLElement
implements IActivity {
    private static final String STATUS_INCOMPLETE = "INCOMPLETE";
    private static final String STATUS_FAIL = "FAIL";
    private static final String STATUS_CANCEL = "CANCEL";
    private static final String STATUS_SUCCESS = "SUCCESS";
    private static final String[] ACTIVITY_NAMES = new String[]{"install", "uninstall", "rollback", "update"};
    private final int activityType;
    private File logFile = null;
    private IStatus status = null;
    private IHistory history = null;

    public ActivityImpl(int activityType) {
        super(ACTIVITY_NAMES[activityType]);
        this.activityType = activityType;
    }

    @Override
    public void addAttribute(String attrName, String attrValue) {
        int i;
        if ("logfile".equals(attrName) && (i = attrValue.lastIndexOf(File.separatorChar)) >= 0) {
            attrValue = attrValue.substring(i + 1);
        }
        super.addAttribute(attrName, attrValue);
    }

    @Override
    public void addOffering(IOfferingInfo offering) {
        super.addChild(offering);
    }

    @Override
    public int getActivityType() {
        return this.activityType;
    }

    @Override
    public Iterator getAllOfferings() {
        return super.getChildren();
    }

    @Override
    public String getEndTime() {
        String endTime = super.getAttribute("end");
        if (endTime == null) {
            endTime = super.getAttribute("start");
        }
        return endTime;
    }

    @Override
    public File getLogFile() {
        if (this.logFile == null) {
            this.logFile = new File(LogManager.getDirectory(), super.getAttribute("logfile"));
        }
        return this.logFile;
    }

    @Override
    public String getStartTime() {
        return super.getAttribute("start");
    }

    @Override
    public IStatus getStatus() {
        if (this.status == null) {
            String statusAttr = super.getAttribute("status");
            this.status = STATUS_INCOMPLETE.equals(statusAttr) ? null : (STATUS_SUCCESS.equals(statusAttr) ? Status.OK_STATUS : Statuses.ERROR.get(null, new Object[0]));
        }
        return this.status;
    }

    @Override
    public void setEndTime(String endTime) {
        super.addAttribute("end", endTime);
    }

    @Override
    public void setStartTime(String startTime) {
        super.addAttribute("start", startTime);
    }

    @Override
    public void setLogFile(File logFile) {
        if (logFile != null) {
            super.addAttribute("logfile", logFile.getName());
            this.logFile = logFile;
        }
    }

    @Override
    public void setStatus(IStatus status) {
        this.status = status;
        String statusAttr = status == null ? STATUS_INCOMPLETE : (!StatusUtil.isErrorOrCancel((IStatus)status) ? STATUS_SUCCESS : (status.matches(8) ? STATUS_CANCEL : STATUS_FAIL));
        super.addAttribute("status", statusAttr);
    }

    @Override
    public void setHistory(IHistory history) {
        this.history = history;
    }

    @Override
    public void endActivity() {
        this.setEndTime(LogUtil.toISO8601((long)System.currentTimeMillis()));
        this.history.endActivity(this);
    }

    @Override
    public IHistory getHistory() {
        return this.history;
    }

    @Override
    public IOfferingInfo[] getAllOfferingArray() {
        List children = super.getChildrenAsList();
        return children.toArray(new IOfferingInfo[children.size()]);
    }

    @Override
    public boolean activityEmptiedProfile() {
        return Boolean.parseBoolean(super.getAttribute("emptiedProfile"));
    }

    @Override
    public void setActivityEmptiedProfile(boolean emptiedProfile) {
        if (emptiedProfile) {
            super.addAttribute("emptiedProfile", Boolean.TRUE.toString());
        }
    }
}

