/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.RollbackJob;
import com.ibm.cic.common.core.artifactrepo.AssignArtifacts;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.impl.DiskUtil;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IFixApplicableOffering;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class VisibleDiskSetsUtil
implements AssignArtifacts.IDetermineDiskSetsPriorities {
    private static final Logger log = Logger.getLogger(VisibleDiskSetsUtil.class);
    private final AgentJob[] jobs;
    private final LinkedHashMap mapJobToHelper;
    private static final AllVisibleHelper ALL_VISIBLE_HELPER = new AllVisibleHelper();

    public VisibleDiskSetsUtil(AgentJob[] jobs) {
        this.jobs = jobs;
        this.mapJobToHelper = new LinkedHashMap(jobs.length);
    }

    private IDeterminePriorityForJob getJobHelper(AgentJob job) {
        IDeterminePriorityForJob jobHelper = (IDeterminePriorityForJob)this.mapJobToHelper.get(job);
        if (jobHelper != null) {
            return jobHelper;
        }
        AgentJob.AgentJobType jobType = job.getType();
        if (jobType.isInstall()) {
            IOfferingOrFix oof = job.getOfferingOrFix();
            if (oof != null) {
                if (oof instanceof IOffering) {
                    IOffering offering = (IOffering)oof;
                    Version ov = offering.getVersion();
                    VersionRange offeringTolerance = new VersionRange(new Version(ov.getMajor(), 0, 0), true, ov, true);
                    jobHelper = new OfferingRangeHelper(offering.getIdentity(), offeringTolerance);
                } else if (oof instanceof IFix) {
                    IFix fix = (IFix)oof;
                    jobHelper = new InstallFixHelper(fix);
                }
            }
        } else if (jobType.isUpdate()) {
            IOffering targetOffering = job.getOffering();
            if (targetOffering != null) {
                Version ov = targetOffering.getVersion();
                VersionRange offeringTolerance = new VersionRange(new Version(ov.getMajor(), 0, 0), true, ov, true);
                jobHelper = new OfferingRangeHelper(targetOffering.getIdentity(), offeringTolerance);
            }
        } else if (jobType.isModify()) {
            IOffering offering = job.getOffering();
            if (offering != null) {
                Version ov = offering.getVersion();
                VersionRange offeringTolerance = new VersionRange(new Version(ov.getMajor(), 0, 0), true, ov, true);
                jobHelper = new ModifyHelper(offering.getIdentity(), offeringTolerance);
            }
        } else if (jobType.isUninstall()) {
            jobHelper = ALL_VISIBLE_HELPER;
        } else if (jobType.isRollback() && job instanceof RollbackJob) {
            RollbackJob rollbackJob = (RollbackJob)job;
            IOffering to = rollbackJob.getOffering();
            Version ov = to.getVersion();
            VersionRange offeringTolerance = new VersionRange(new Version(ov.getMajor(), 0, 0), true, ov, true);
            jobHelper = new OfferingRangeHelper(to.getIdentity(), offeringTolerance);
        }
        if (jobHelper == null) {
            jobHelper = ALL_VISIBLE_HELPER;
        }
        this.mapJobToHelper.put(job, jobHelper);
        return jobHelper;
    }

    public AssignArtifacts.DiskSetPriority determineDiskSetsPriority(IVolumeAccessByDisk diskRepo, IArtifactSession session, IVolumeAccessByDisk.IDiskSet[] allDiskSets, IProgressMonitor monitor) throws CoreException, IOException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        sm.setWorkRemaining(this.jobs.length);
        LinkedHashSet setAllPrimaryDiskSets = new LinkedHashSet(allDiskSets.length);
        AgentJob[] agentJobArray = this.jobs;
        int n = this.jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IDeterminePriorityForJob jobHelper = this.getJobHelper(job);
            if (jobHelper != null) {
                jobHelper.addPrimaryDiskSetsForJob(session, setAllPrimaryDiskSets, allDiskSets, diskRepo, (IProgressMonitor)sm.newChild(1));
            }
            ++n2;
        }
        LinkedHashSet setSecondaryDiskSets = new LinkedHashSet(allDiskSets.length);
        AgentJob[] agentJobArray2 = this.jobs;
        int n3 = this.jobs.length;
        n = 0;
        while (n < n3) {
            AgentJob job = agentJobArray2[n];
            IDeterminePriorityForJob jobHelper = this.getJobHelper(job);
            if (jobHelper != null) {
                jobHelper.addSecondaryDiskSetsForJob(session, setSecondaryDiskSets, allDiskSets, (IProgressMonitor)sm.newChild(1));
            }
            ++n;
        }
        Iterator iterator = setSecondaryDiskSets.iterator();
        while (iterator.hasNext()) {
            IVolumeAccessByDisk.IDiskSet diskSet = (IVolumeAccessByDisk.IDiskSet)iterator.next();
            if (!setAllPrimaryDiskSets.contains(diskSet)) continue;
            iterator.remove();
        }
        IVolumeAccessByDisk.IDiskSet[] allPrimaryDiskSets = setAllPrimaryDiskSets.toArray(new IVolumeAccessByDisk.IDiskSet[setAllPrimaryDiskSets.size()]);
        IVolumeAccessByDisk.IDiskSet[] secondaryDiskSets = setSecondaryDiskSets.toArray(new IVolumeAccessByDisk.IDiskSet[setSecondaryDiskSets.size()]);
        AssignArtifacts.DiskSetPriority dsp = new AssignArtifacts.DiskSetPriority(allPrimaryDiskSets, secondaryDiskSets);
        return dsp;
    }

    private static void addRemainingAsSecondary(Set secondaryDiskSets, IVolumeAccessByDisk.IDiskSet[] allDiskSets, Collection primaryDiskSets) {
        boolean dropPseudoDiskSet = true;
        IVolumeAccessByDisk.IDiskSet[] secondary = VisibleDiskSetsUtil.getRemainingDiskSets(allDiskSets, primaryDiskSets.toArray(new IVolumeAccessByDisk.IDiskSet[primaryDiskSets.size()]), dropPseudoDiskSet);
        secondaryDiskSets.addAll(Arrays.asList(secondary));
    }

    private static List getUpdatesOrOfferings(IRepository repo, IIdentity offeringId, VersionRange tolerance, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        List allOfferings = repo.getAllOfferings((IProgressMonitor)sm.newChild(1));
        ArrayList list = VisibleDiskSetsUtil.filterUpdatesOrOfferings(allOfferings, offeringId, tolerance);
        List allUpdates = repo.getAllUpdates(offeringId, null, (IProgressMonitor)sm.newChild(1));
        list.addAll(VisibleDiskSetsUtil.filterUpdatesOrOfferings(allUpdates, offeringId, tolerance));
        return list;
    }

    private static ArrayList filterUpdatesOrOfferings(List offerings, IIdentity offeringId, VersionRange tolerance) {
        ArrayList<IOffering> list = new ArrayList<IOffering>(offerings.size());
        for (IOffering offering : offerings) {
            log.debug("Considering offering {0}", new Object[]{offering});
            if (!offering.getIdentity().equals(offeringId) || tolerance != null && !tolerance.isIncluded(offering.getVersion())) continue;
            list.add(offering);
        }
        list.trimToSize();
        return list;
    }

    public static void addPrimaryDiskSetsForOfferings(Collection primaryDiskSets, IArtifactSession session, IVolumeAccessByDisk diskRepo, IIdentity id, VersionRange tolerance, IProgressMonitor monitor) throws CoreException, IOException {
        log.debug("Enter adding primary disks for offering and updates id={0} tolerance={1}.\n\tLooking in {2}", new Object[]{id, tolerance, diskRepo.getRepository().getLocation()});
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        List offerings = VisibleDiskSetsUtil.getUpdatesOrOfferings(diskRepo.getRepository(), id, tolerance, (IProgressMonitor)sm.newChild(1));
        sm.setWorkRemaining(offerings.size());
        for (IOffering offering : offerings) {
            VisibleDiskSetsUtil.addPackageDiskSets(primaryDiskSets, session, diskRepo, (IOfferingOrFix)offering, (IProgressMonitor)sm.newChild(1));
        }
        log.debug("Done adding primary disks for offering and updates id={0} tolerance={1}.", new Object[]{id, tolerance});
    }

    private static void addDiskSet(Collection primaryDiskSets, IOfferingOrFix oof, IVolumeAccessByDisk.IDiskSet diskSet) {
        if (primaryDiskSets.contains(diskSet)) {
            log.debug("Primary disk set had already been added: {0} ({1})", new Object[]{diskSet.getId(), oof});
        } else {
            log.debug("Adding primary disk set: {0} ({1})", new Object[]{diskSet.getId(), oof});
            primaryDiskSets.add(diskSet);
        }
    }

    private static void addPrimaryDiskSetsForFix(Collection primaryDiskSets, IArtifactSession session, IVolumeAccessByDisk diskRepo, IFix fix, IProgressMonitor monitor) throws CoreException, IOException {
        List list = fix.getApplicableOfferings();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)list.size());
        for (IFixApplicableOffering applicable : list) {
            VisibleDiskSetsUtil.addPrimaryDiskSetsForFix(primaryDiskSets, session, diskRepo, fix, applicable, (IProgressMonitor)sm.newChild(1));
        }
    }

    private static void addPrimaryDiskSetsForFix(Collection primaryDiskSets, IArtifactSession session, IVolumeAccessByDisk diskRepo, IFix fix, IFixApplicableOffering applicable, IProgressMonitor monitor) throws CoreException, IOException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        log.debug("Enter adding primary disks for fix {0} of applicable offering {1} {2}", new Object[]{fix, applicable.getIdentity(), applicable.getTolerance()});
        VisibleDiskSetsUtil.addPrimaryDiskSetsForOfferings(primaryDiskSets, session, diskRepo, applicable.getIdentity(), applicable.getTolerance(), (IProgressMonitor)sm.newChild(1));
        IFix diskFix = diskRepo.getRepository().findFix(fix.getIdentity(), fix.getVersion(), (IProgressMonitor)sm.newChild(1));
        log.debug("Looking for fix {0}in {1}: result={2}", new Object[]{fix, diskRepo.getRepository().getLocation(), diskFix});
        if (diskFix != null) {
            VisibleDiskSetsUtil.addPackageDiskSets(primaryDiskSets, session, diskRepo, (IOfferingOrFix)diskFix, (IProgressMonitor)sm);
        }
        log.debug("Done adding primary disks for fix {0} of applicable offering {1} {2}", new Object[]{fix, applicable.getIdentity(), applicable.getTolerance()});
    }

    private static void addPackageDiskSets(Collection primaryDiskSets, IArtifactSession session, IVolumeAccessByDisk diskRepo, IOfferingOrFix oof, IProgressMonitor monitor) throws CoreException, IOException {
        IVolumeAccessByDisk.IDiskSet[] diskSets = DiskUtil.getPackageDiskSets((IArtifactSession)session, (IRepository)diskRepo.getRepository(), (IOfferingOrFix)oof, (IProgressMonitor)monitor);
        if (diskSets == null || diskSets.length == 0) {
            log.debug("No primary disk set for {0}", new Object[]{oof});
        } else {
            VisibleDiskSetsUtil.addDiskSets(primaryDiskSets, oof, diskSets);
        }
    }

    private static void addDiskSets(Collection primaryDiskSets, IOfferingOrFix oof, IVolumeAccessByDisk.IDiskSet[] diskSets) {
        IVolumeAccessByDisk.IDiskSet[] iDiskSetArray = diskSets;
        int n = diskSets.length;
        int n2 = 0;
        while (n2 < n) {
            IVolumeAccessByDisk.IDiskSet diskSet = iDiskSetArray[n2];
            VisibleDiskSetsUtil.addDiskSet(primaryDiskSets, oof, diskSet);
            ++n2;
        }
    }

    private static IVolumeAccessByDisk.IDiskSet[] getRemainingDiskSets(IVolumeAccessByDisk.IDiskSet[] allDiskSets, IVolumeAccessByDisk.IDiskSet[] primaryDiskSets, boolean dropPseudoDiskSet) {
        IVolumeAccessByDisk.IDiskSet[] allConsideredSets = allDiskSets;
        if (dropPseudoDiskSet) {
            allConsideredSets = DiskUtil.filterPseudoDisksSets((IVolumeAccessByDisk.IDiskSet[])allConsideredSets);
        }
        IVolumeAccessByDisk.IDiskSet[] secondaryDiskSets = DiskUtil.getOtherDisksSets((IVolumeAccessByDisk.IDiskSet[])allConsideredSets, (IVolumeAccessByDisk.IDiskSet[])primaryDiskSets);
        return secondaryDiskSets;
    }

    private static class AllVisibleHelper
    implements IDeterminePriorityForJob {
        @Override
        public void addPrimaryDiskSetsForJob(IArtifactSession session, Collection primaryDiskSets, IVolumeAccessByDisk.IDiskSet[] allDiskSets, IVolumeAccessByDisk diskRepo, IProgressMonitor monitor) {
            primaryDiskSets.addAll(Arrays.asList(allDiskSets));
        }

        @Override
        public void addSecondaryDiskSetsForJob(IArtifactSession session, Set setSecondaryDiskSets, IVolumeAccessByDisk.IDiskSet[] allDiskSets, IProgressMonitor monitor) {
        }
    }

    public static interface IDeterminePriorityForJob {
        public void addPrimaryDiskSetsForJob(IArtifactSession var1, Collection var2, IVolumeAccessByDisk.IDiskSet[] var3, IVolumeAccessByDisk var4, IProgressMonitor var5) throws CoreException, IOException;

        public void addSecondaryDiskSetsForJob(IArtifactSession var1, Set var2, IVolumeAccessByDisk.IDiskSet[] var3, IProgressMonitor var4);
    }

    private static class InstallFixHelper
    implements IDeterminePriorityForJob {
        private final IFix fix;
        private LinkedHashSet primaryDiskSetForJob;

        public InstallFixHelper(IFix fix) {
            this.fix = fix;
        }

        @Override
        public void addPrimaryDiskSetsForJob(IArtifactSession session, Collection primaryDiskSets, IVolumeAccessByDisk.IDiskSet[] allDiskSets, IVolumeAccessByDisk diskRepo, IProgressMonitor monitor) throws CoreException, IOException {
            this.primaryDiskSetForJob = new LinkedHashSet(allDiskSets.length);
            VisibleDiskSetsUtil.addPrimaryDiskSetsForFix(this.primaryDiskSetForJob, session, diskRepo, this.fix, monitor);
            primaryDiskSets.addAll(this.primaryDiskSetForJob);
        }

        @Override
        public void addSecondaryDiskSetsForJob(IArtifactSession session, Set setSecondaryDiskSets, IVolumeAccessByDisk.IDiskSet[] allDiskSets, IProgressMonitor monitor) {
            assert (this.primaryDiskSetForJob != null);
            VisibleDiskSetsUtil.addRemainingAsSecondary(setSecondaryDiskSets, allDiskSets, this.primaryDiskSetForJob);
        }
    }

    private static class ModifyHelper
    implements IDeterminePriorityForJob {
        private final IIdentity offeringId;
        private final VersionRange tolerance;

        public ModifyHelper(IIdentity offeringId, VersionRange tolerance) {
            this.offeringId = offeringId;
            this.tolerance = tolerance;
        }

        @Override
        public void addPrimaryDiskSetsForJob(IArtifactSession session, Collection primaryDiskSets, IVolumeAccessByDisk.IDiskSet[] allDiskSets, IVolumeAccessByDisk diskRepo, IProgressMonitor monitor) throws CoreException, IOException {
            VisibleDiskSetsUtil.addPrimaryDiskSetsForOfferings(primaryDiskSets, session, diskRepo, this.offeringId, this.tolerance, monitor);
            primaryDiskSets.addAll(primaryDiskSets);
        }

        @Override
        public void addSecondaryDiskSetsForJob(IArtifactSession session, Set setSecondaryDiskSets, IVolumeAccessByDisk.IDiskSet[] allDiskSets, IProgressMonitor monitor) {
        }
    }

    private static class OfferingRangeHelper
    implements IDeterminePriorityForJob {
        private final IIdentity offeringId;
        private final VersionRange tolerance;
        private LinkedHashSet primaryDiskSetForJob;

        public OfferingRangeHelper(IIdentity offeringId, VersionRange tolerance) {
            this.offeringId = offeringId;
            this.tolerance = tolerance;
        }

        @Override
        public void addPrimaryDiskSetsForJob(IArtifactSession session, Collection primaryDiskSets, IVolumeAccessByDisk.IDiskSet[] allDiskSets, IVolumeAccessByDisk diskRepo, IProgressMonitor monitor) throws CoreException, IOException {
            this.primaryDiskSetForJob = new LinkedHashSet(allDiskSets.length);
            VisibleDiskSetsUtil.addPrimaryDiskSetsForOfferings(this.primaryDiskSetForJob, session, diskRepo, this.offeringId, this.tolerance, monitor);
            primaryDiskSets.addAll(this.primaryDiskSetForJob);
        }

        @Override
        public void addSecondaryDiskSetsForJob(IArtifactSession session, Set setSecondaryDiskSets, IVolumeAccessByDisk.IDiskSet[] allDiskSets, IProgressMonitor monitor) {
            assert (this.primaryDiskSetForJob != null);
            VisibleDiskSetsUtil.addRemainingAsSecondary(setSecondaryDiskSets, allDiskSets, this.primaryDiskSetForJob);
        }
    }
}

