/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.userdata.parser;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.CustomPanelData;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.api.ICustomPanelData;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.UserDataValidator;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class OfferingUserDataExtParser {
    private static final String TAG_OFFERING_USER_DATA_EXTENSION = "offeringUserData";
    private static final String TAG_OFFERING_DATA = "offeringData";
    private static final String TAG_DATA_KEY = "dataKey";
    private static final String TAG_DATA_DES = "dataDes";
    private static final String TAG_DATA_DEFAULT_VALUE = "dataDefaultValue";
    private static final String TAG_DATA_SENSITIVE = "sensitive";
    private static final String TAG_DATA_VALIDATION_CLASS = "validationClass";
    private static final String TAG_OFFERING_BINDING = "offeringBinding";
    private static final String TAG_OFFERING_ID = "offeringId";
    private static final String TAG_OFFERING_VERSION_RANGE = "offeringVersionRange";
    private static OfferingUserDataExtParser instance = null;
    private Map offeringToDataMap = new HashMap();
    private AgentJob[] profileJobs = null;
    private AgentJob[] allJobs = null;

    static {
        instance = new OfferingUserDataExtParser();
    }

    public static OfferingUserDataExtParser getInstance() {
        return instance;
    }

    public void initializeOfferingUserDataExtensions(AgentJob[] jobs, AgentJob[] groupJobs) {
        this.profileJobs = groupJobs;
        this.allJobs = jobs;
        this.offeringToDataMap = new HashMap();
        this.createOfferingUserDataGroup();
    }

    public void initializeOfferingUserDataExtensions(AgentJob[] jobs) {
        this.allJobs = jobs;
        this.profileJobs = null;
        this.offeringToDataMap = new HashMap();
        this.createOfferingUserDataGroup();
    }

    public void reset() {
        this.allJobs = null;
        this.profileJobs = null;
        this.offeringToDataMap = null;
    }

    private IOfferingOrFix[] extractOfferingOrFixFromJob(AgentJob[] jobArray) {
        ArrayList<IOfferingOrFix> offeringList = new ArrayList<IOfferingOrFix>();
        if (jobArray != null && jobArray.length > 0) {
            AgentJob[] agentJobArray = jobArray;
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob element = agentJobArray[n2];
                IOfferingOrFix offeringOrFix = element.getOfferingOrFix();
                if (offeringOrFix != null) {
                    offeringList.add(offeringOrFix);
                }
                ++n2;
            }
        }
        return offeringList.toArray(new IOfferingOrFix[offeringList.size()]);
    }

    public String[] getOfferingUserDataKeys(IOfferingOrFix offeringOrFix) {
        Map keyToOfferingDataMap = (Map)this.offeringToDataMap.get(offeringOrFix);
        if (keyToOfferingDataMap != null && !keyToOfferingDataMap.isEmpty()) {
            Set keySet = keyToOfferingDataMap.keySet();
            return keySet.toArray(new String[keySet.size()]);
        }
        return new String[0];
    }

    public String getOfferingUserDataDefaultValue(IOfferingOrFix offeringOrFix, String key) {
        OfferingUserData data;
        Map keyToOfferingDataMap = (Map)this.offeringToDataMap.get(offeringOrFix);
        if (keyToOfferingDataMap != null && !keyToOfferingDataMap.isEmpty() && (data = (OfferingUserData)keyToOfferingDataMap.get(key)) != null) {
            return data.getOfferingUserDataDefaultValue();
        }
        return "";
    }

    public String getOfferingUserDataDescription(IOfferingOrFix offeringOrFix, String key) {
        OfferingUserData data;
        Map keyToOfferingDataMap = (Map)this.offeringToDataMap.get(offeringOrFix);
        if (keyToOfferingDataMap != null && !keyToOfferingDataMap.isEmpty() && (data = (OfferingUserData)keyToOfferingDataMap.get(key)) != null) {
            return data.getOfferingUserDataDes();
        }
        return "";
    }

    public IStatus getOfferingUserDataValidationStatus(IOfferingOrFix offeringOrFix, Map keyValuePair) {
        CicMultiStatus return_status = Statuses.ST.createMultiStatus();
        Map keyToOfferingDataMap = (Map)this.offeringToDataMap.get(offeringOrFix);
        if (keyToOfferingDataMap != null && !keyToOfferingDataMap.isEmpty()) {
            Set keySet = keyValuePair.keySet();
            for (String key : keySet) {
                IStatus status;
                OfferingUserData data = (OfferingUserData)keyToOfferingDataMap.get(key);
                if (data == null || (status = data.getValidationStatus(keyValuePair)) == null) continue;
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    return status;
                }
                return_status.add(status);
            }
        }
        if (!return_status.isOK()) {
            Status new_return_status = new Status(return_status.getSeverity(), return_status.getPlugin(), MultiStatusUtil.getFailureMessage((IStatus)return_status));
            return new_return_status;
        }
        return return_status;
    }

    private void createOfferingUserDataGroup() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(ComIbmCicCommonCorePlugin.getPluginId(), TAG_OFFERING_USER_DATA_EXTENSION).getExtensions();
        if (extensions == null || extensions.length == 0) {
            return;
        }
        if (this.profileJobs != null) {
            this.parseExtensions(extensions, this.profileJobs);
        } else {
            Collection jobArrays = AgentUtil.groupByProfile(this.allJobs, false);
            for (AgentJob[] jobsInOneProfile : jobArrays) {
                this.parseExtensions(extensions, jobsInOneProfile);
            }
        }
    }

    private void parseExtensions(IExtension[] extensions, AgentJob[] jobsInOneProfile) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseDefinitions(extension, jobsInOneProfile);
            ++n2;
        }
    }

    private boolean inRange(Version offeringVersion, String versionRange) {
        try {
            VersionRange offeringVersionRange = new VersionRange(versionRange);
            return offeringVersionRange.isIncluded(offeringVersion);
        }
        catch (IllegalArgumentException iae) {
            ExceptionUtil.debugLogToReview((Throwable)iae);
            return false;
        }
    }

    private IOfferingOrFix getSelectedOffering(String offeringId, String offeringVersionRange, AgentJob[] jobsInOneProfile) {
        IOfferingOrFix[] offerings;
        IOfferingOrFix[] iOfferingOrFixArray = offerings = this.extractOfferingOrFixFromJob(jobsInOneProfile);
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix offering = iOfferingOrFixArray[n2];
            if (offering != null && offering.getIdentity().getId().equals(offeringId) && this.inRange(offering.getVersion(), offeringVersionRange)) {
                return offering;
            }
            ++n2;
        }
        return null;
    }

    private void parseDefinitions(IExtension extension, AgentJob[] jobsInOneProfile) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements != null && elements.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] userDataElements;
                String offeringVersionRange;
                String offeringId;
                IOfferingOrFix selectedOffering;
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(TAG_OFFERING_BINDING) && (selectedOffering = this.getSelectedOffering(offeringId = element.getAttribute(TAG_OFFERING_ID), offeringVersionRange = element.getAttribute(TAG_OFFERING_VERSION_RANGE), jobsInOneProfile)) != null && (userDataElements = element.getChildren(TAG_OFFERING_DATA)) != null && userDataElements.length > 0) {
                    IConfigurationElement[] iConfigurationElementArray2 = userDataElements;
                    int n3 = userDataElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement userDataElement = iConfigurationElementArray2[n4];
                        this.parseElement(selectedOffering, userDataElement, jobsInOneProfile);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private void parseElement(IOfferingOrFix offering, IConfigurationElement element, final AgentJob[] jobsInOneProfile) {
        String dataKey = element.getAttribute(TAG_DATA_KEY);
        String dataDes = element.getAttribute(TAG_DATA_DES);
        String dataDefaultValue = element.getAttribute(TAG_DATA_DEFAULT_VALUE);
        boolean sensitive = Boolean.valueOf(element.getAttribute(TAG_DATA_SENSITIVE));
        String validatorClass = element.getAttribute(TAG_DATA_VALIDATION_CLASS);
        if (dataKey == null || dataKey.trim().length() == 0) {
            return;
        }
        if (dataDes == null) {
            dataDes = "";
        }
        if (dataDefaultValue == null) {
            dataDefaultValue = "";
        }
        Profile profile = jobsInOneProfile[0].getProfile();
        if (sensitive) {
            profile.setSensitiveUserData(dataKey, offering.getIdentity().getId());
        }
        UserDataValidator validator = null;
        try {
            if (validatorClass != null && validatorClass.trim().length() > 0) {
                Object obj = element.createExecutableExtension(TAG_DATA_VALIDATION_CLASS);
                if (!(obj instanceof UserDataValidator)) {
                    throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "class specified by offering user data validation must be an instance of UserDataValidator", null));
                }
                validator = (UserDataValidator)obj;
                validator.init(new IAdaptable(){

                    public Object getAdapter(Class adapter) {
                        if (IAgent.class.equals((Object)adapter)) {
                            return Agent.getInstance();
                        }
                        if (IAgentJob[].class.equals((Object)adapter)) {
                            return jobsInOneProfile;
                        }
                        if (ICustomPanelData.class.equals((Object)adapter)) {
                            return new CustomPanelData(OfferingUserDataExtParser.this.allJobs, jobsInOneProfile);
                        }
                        return null;
                    }
                });
            }
        }
        catch (CoreException e) {
            Agent.getLogger().error((Throwable)e);
        }
        OfferingUserData data = new OfferingUserData(offering, dataKey, dataDes, dataDefaultValue, validator);
        HashMap<String, OfferingUserData> keyToUserDataMap = (HashMap<String, OfferingUserData>)this.offeringToDataMap.get(offering);
        if (keyToUserDataMap == null) {
            keyToUserDataMap = new HashMap<String, OfferingUserData>();
            this.offeringToDataMap.put(offering, keyToUserDataMap);
        }
        keyToUserDataMap.put(data.getOfferingUserDataKey(), data);
    }

    static class OfferingUserData {
        private final IOfferingOrFix offeringOrFix;
        private final String offeringDataKey;
        private String offeringDataDes = "";
        private String offeringDataDefaultValue = "";
        private UserDataValidator offeringDataValidator = null;

        OfferingUserData(IOfferingOrFix offering, String key, String des, String defaultValue, UserDataValidator validator) {
            this.offeringOrFix = offering;
            this.offeringDataKey = key;
            this.offeringDataDes = des;
            this.offeringDataDefaultValue = defaultValue;
            this.offeringDataValidator = validator;
        }

        public IOfferingOrFix getOfferingOrFix() {
            return this.offeringOrFix;
        }

        public String getOfferingUserDataKey() {
            return this.offeringDataKey;
        }

        public String getOfferingUserDataDes() {
            return this.offeringDataDes;
        }

        public String getOfferingUserDataDefaultValue() {
            return this.offeringDataDefaultValue;
        }

        public IStatus getValidationStatus(Map nameValuePair) {
            if (this.offeringDataValidator == null) {
                return Status.OK_STATUS;
            }
            if (!this.offeringDataValidator.shouldSkipValidation(nameValuePair)) {
                return this.offeringDataValidator.validateUserData(nameValuePair);
            }
            return Status.OK_STATUS;
        }
    }
}

