/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.expander;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.expander.AgentSelectorExpander;
import com.ibm.cic.agent.core.internal.expander.ExpansionResult;
import com.ibm.cic.agent.core.internal.expander.IExpanderInput;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.Comparators;
import com.ibm.cic.common.logging.Logger;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

class ExpanderCache {
    private static final Logger log2 = Logger.getLogger();
    private final Map<String, ExpansionResult> cache;

    ExpanderCache(int size) {
        this.cache = size == 0 ? null : new MaxSizeLruCache(size);
    }

    void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public String toString() {
        if (this.cache == null) {
            return "no cache";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ExpansionResult> entry : this.cache.entrySet()) {
            sb.append(entry.getValue().isOK() ? "OK" : "ERROR").append(" <- ").append(entry.getKey()).append('\n');
        }
        return sb.toString();
    }

    ExpansionResult get(AgentSelectorExpander expander) {
        if (this.cache == null) {
            return null;
        }
        String key = ExpanderCache.toKey(expander);
        if (key == null) {
            return null;
        }
        ExpansionResult result = this.cache.get(key);
        if (result == null) {
            log2.debug("Not found in cache: {0}", new Object[]{key});
            return null;
        }
        String key2 = ExpanderCache.toKey(result);
        if (!key.equals(key2)) {
            log2.debug("Key changed while in cache: {0} {1}", new Object[]{key, key2});
            return null;
        }
        log2.debug("Found in cache: {0}", new Object[]{key});
        result.reset(expander.getProfile());
        return result;
    }

    void put(AgentSelectorExpander expander, ExpansionResult expansionResult) {
        if (this.cache == null) {
            return;
        }
        String key = ExpanderCache.toKey(expander);
        if (key != null) {
            log2.debug("Add to cache: {0}", new Object[]{key});
            expansionResult.setCache(this);
            this.cache.put(key, expansionResult);
        }
    }

    private static String toKey(IExpanderInput state) {
        StringBuilder sb = new StringBuilder();
        String jobType = ExpanderCache.getJobType(state);
        if (jobType == null) {
            return null;
        }
        sb.append(jobType);
        Profile profile = state.getProfile();
        sb.append(' ').append(profile.getProfileId());
        String[] stringArray = profile.getAllData().getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (!profile.hasDefaultValue(key)) {
                sb.append(' ').append(key).append('=').append(profile.getData(key));
            }
            ++n2;
        }
        for (Map.Entry<IOffering, Collection<IFeature>> entry : state.getOfferings().entrySet()) {
            IOffering offering = entry.getKey();
            sb.append(' ').append(offering.getIdentity()).append(' ').append(offering.getVersion()).append(' ');
            ExpanderCache.appendFeatures(sb, offering, entry.getValue());
        }
        for (IFix fix : state.getFixes()) {
            sb.append(' ').append(fix.getIdentity()).append(' ').append(fix.getVersion());
        }
        return sb.toString();
    }

    private static String getJobType(IExpanderInput state) {
        AgentJob[] jobs = state.getJobs();
        if (jobs.length == 0) {
            return "NONE";
        }
        String jobType = jobs[0].getType().getJobType();
        int i = 1;
        while (i < jobs.length) {
            if (!jobType.equals(jobs[i].getType().getJobType())) {
                return null;
            }
            ++i;
        }
        return jobType;
    }

    private static void appendFeatures(StringBuilder sb, IOffering offering, Collection<IFeature> featuresCollection) {
        TreeSet<IFeature> features = new TreeSet<IFeature>(Comparators.FEATURE);
        features.addAll(featuresCollection);
        List<IFeature> baseFeatures = Arrays.asList(OfferingUtil.getAllFeatures((IOffering)offering));
        if (features.containsAll(baseFeatures)) {
            sb.append("ALL");
        } else {
            baseFeatures = Arrays.asList(OfferingUtil.getDefaultFeaturesIgnoreBundles((IOffering)offering));
            if (features.containsAll(baseFeatures)) {
                sb.append("DEFAULT");
            } else {
                baseFeatures = Arrays.asList(OfferingUtil.getRequiredFeatures((IOffering)offering));
                if (features.containsAll(baseFeatures)) {
                    sb.append("REQUIRED");
                } else {
                    sb.append("NONE");
                }
            }
        }
        features.removeAll(baseFeatures);
        for (IFeature feature : features) {
            sb.append(' ').append(feature.getIdentity());
        }
    }

    private static class MaxSizeLruCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;

        MaxSizeLruCache(int maxSize) {
            super(maxSize * 3, 0.75f, false);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

