/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.XMLWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class XMLElement {
    private final String name;
    private final List<XMLElement> children = new ArrayList<XMLElement>();
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private List<List<String>> comments = Collections.emptyList();

    public XMLElement(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addComment(String comment) {
        this.addComment(Collections.singletonList(comment));
    }

    public void addComment(List<String> lines) {
        if (this.comments.isEmpty()) {
            this.comments = new ArrayList<List<String>>(2);
        }
        this.comments.add(lines);
    }

    public void addAttribute(String attrName, String attrValue) {
        this.attributes.put(attrName, attrValue);
    }

    public Iterable<XMLElement> children() {
        return this.children;
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public String getAttribute(String attrName) {
        return this.attributes.get(attrName);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    protected String getAttribute(String attrName, boolean maskSensitiveAttrs) {
        return this.getAttribute(attrName);
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public void addChild(XMLElement child) {
        this.children.add(child);
    }

    public XMLElement getChild(int index) {
        return this.children.get(index);
    }

    public void save(XMLWriter writer, boolean maskSensitiveAttrs) {
        for (List<String> lines : this.comments) {
            writer.comment(lines);
        }
        writer.start(this.getName());
        for (String attrName : this.attributes.keySet()) {
            String attrValue = this.getAttribute(attrName, maskSensitiveAttrs);
            writer.attribute(attrName, (Object)attrValue);
        }
        for (XMLElement child : this.children) {
            child.save(writer, maskSensitiveAttrs);
        }
        writer.end(this.getName());
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLWriter writer = new XMLWriter((OutputStream)os, false);
        this.save(writer, false);
        writer.close();
        return Encodings.UTF8.toString(os);
    }
}

