/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.AbstractCommand;
import com.ibm.cic.agent.core.internal.commands.XMLElement;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.core.internal.headless.IServerCommand;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.agent.internal.core.notify.EnableImportEventManager;
import com.ibm.cic.common.core.console.PrompterUtils;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ServerCommand
extends AbstractCommand
implements IServerCommand {
    public ServerCommand() {
        super("server");
    }

    @Override
    public IStatus execute(Agent agent, IProgressMonitor monitor) {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        PrompterUtils.ConsoleCredentialPrompter credentialPrompts = CmdLine.CL.getConsoleCredentialPrompter();
        try {
            for (XMLElement child : this.children()) {
                result.add(this.execute(agent, child));
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            agent.configureRepositoryGroup((IProgressMonitor)subMonitor.newChild(1));
            if (agent.isRepositoryGroupSet() && AgentUtil.checkImportEnabledFromRepositories(agent.getRepositoryGroup(), (IProgressMonitor)subMonitor.newChild(1))) {
                CicPreferenceManager.getInstance().setBoolean(ICicPreferenceConstants.IMPORT_ENABLED, true);
                if (!agent.isSilentMode()) {
                    EnableImportEventManager.getInstance().fireEnableImportEvent(null);
                }
            }
        }
        finally {
            credentialPrompts.restore();
        }
        return result;
    }

    private IStatus execute(Agent agent, XMLElement unit) {
        boolean result;
        String unitName = unit.getName();
        String location = unit.getAttribute("location");
        String temporary = unit.getAttribute("temporary");
        boolean isTemporary = Boolean.TRUE.toString().equals(temporary) ? true : (Boolean.FALSE.toString().equals(temporary) ? false : agent.isTemporaryMode());
        if ("metadata".equals(unitName)) {
            result = this.addRepositoryToAgent(agent, location, isTemporary);
        } else if ("artifact".equals(unitName)) {
            result = this.addRepositoryToAgent(agent, location, isTemporary);
        } else if ("repository".equals(unitName)) {
            result = this.addRepositoryToAgent(agent, location, isTemporary);
        } else {
            throw new AssertionError();
        }
        if (result) {
            return Status.OK_STATUS;
        }
        return new Status(4, Agent.PI_AGENT, 4, NLS.bind((String)Messages.HeadlessApplication_FailedToExecuteCommand, (Object)this), null);
    }

    private boolean addRepositoryToAgent(Agent agent, String location, boolean isTemporary) {
        CicPreferenceManager pm;
        String[] locations;
        int index;
        String specialSettings = null;
        String normalizedLocation = this.getNormalizedLocation(location, null);
        if (this.shouldSkipAgentRepoLocation(normalizedLocation)) {
            this.getInput().setAgentRepoSkipped(true);
            return true;
        }
        if (!AgentInstall.getInstance().isAgentInstallerRunning() && System.getProperty("cic.agentRelaunched") != null && location.equals("@osgi.install.area")) {
            this.getInput().setAgentRepoSkipped(true);
            return true;
        }
        if (this.isHttpLocation(location) && (index = normalizedLocation.indexOf("?")) > -1) {
            if (index != normalizedLocation.length() - 1) {
                specialSettings = normalizedLocation.substring(index + 1).trim();
            }
            normalizedLocation = normalizedLocation.substring(0, index);
        }
        if ((locations = (pm = CicPreferenceManager.getInstance()).getStringArray(ICicPreferenceConstants.REPOSITORY_LOCATIONS.key())) != null) {
            String[] stringArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                String location2 = stringArray[n2];
                if (location2.equalsIgnoreCase(normalizedLocation)) {
                    this.updateLocationPreferences(normalizedLocation, specialSettings, Boolean.TRUE);
                    return true;
                }
                ++n2;
            }
        }
        pm.addFirstValue(ICicPreferenceConstants.REPOSITORY_LOCATIONS, normalizedLocation, isTemporary);
        this.updateLocationPreferences(normalizedLocation, specialSettings, Boolean.TRUE);
        return true;
    }

    private boolean isHttpLocation(String location) {
        try {
            URL url = new URL(location);
            String protocol = url.getProtocol();
            if ("http".equals(protocol) || "https".equals(protocol)) {
                return true;
            }
        }
        catch (MalformedURLException e) {
            ExceptionUtil.debugLogToReview((Throwable)e);
        }
        return false;
    }

    private void updateLocationPreferences(String location, String specialSettings, Boolean isRepoOpen) {
        CicPreferenceManager pm = CicPreferenceManager.getInstance();
        ICicPreferenceConstants.ComposedPreferenceTag repoIsOpenTag = new ICicPreferenceConstants.ComposedPreferenceTag(ICicPreferenceConstants.REPOSITORY_LOCATIONS, location, ICicPreferenceConstants.REPOSITORY_IS_OPEN);
        pm.setValue((ICicPreferenceConstants.PreferenceTag)repoIsOpenTag, isRepoOpen.toString());
        if (specialSettings != null && !"".equals(specialSettings)) {
            ICicPreferenceConstants.ComposedPreferenceTag specialSettingsTag = new ICicPreferenceConstants.ComposedPreferenceTag(ICicPreferenceConstants.REPOSITORY_LOCATIONS, location, ICicPreferenceConstants.REPOSITORY_SPECIAL_SETTINGS);
            pm.setValue((ICicPreferenceConstants.PreferenceTag)specialSettingsTag, specialSettings);
        }
    }

    @Override
    public int getExecutionPoint() {
        return 2;
    }

    @Override
    public void setRepositories(String metadata, String[] artifacts) {
        XMLElement metadataElm = new XMLElement("metadata");
        metadataElm.addAttribute("location", metadata);
        this.addChild(metadataElm);
        String[] stringArray = artifacts;
        int n = artifacts.length;
        int n2 = 0;
        while (n2 < n) {
            String artifact = stringArray[n2];
            XMLElement artifactElm = new XMLElement("artifact");
            artifactElm.addAttribute("location", artifact);
            this.addChild(artifactElm);
            ++n2;
        }
    }

    @Override
    public boolean addRepository(String repositoryLocation) {
        return this.addRepository(repositoryLocation, IServerCommand.TemporaryLocation.UNDEFINED);
    }

    @Override
    public boolean addRepository(String repositoryLocation, IServerCommand.TemporaryLocation temporary) {
        if (this.isLocationAdded(repositoryLocation)) {
            return false;
        }
        XMLElement locationElm = new XMLElement("repository");
        locationElm.addAttribute("location", repositoryLocation);
        if (temporary.equals(IServerCommand.TemporaryLocation.IS_TEMP)) {
            locationElm.addAttribute("temporary", Boolean.TRUE.toString());
        } else if (temporary.equals(IServerCommand.TemporaryLocation.NOT_TEMP)) {
            locationElm.addAttribute("temporary", Boolean.FALSE.toString());
        }
        this.addChild(locationElm);
        return true;
    }

    @Override
    public List getRepositories() {
        ArrayList<String> result = new ArrayList<String>();
        for (XMLElement unit : this.children()) {
            String location = unit.getAttribute("location");
            if (location == null) continue;
            result.add(this.getNormalizedLocation(location, null));
        }
        return result;
    }

    private boolean isLocationAdded(String repoLocation) {
        for (XMLElement child : this.children()) {
            String location = child.getAttribute("location");
            if (!location.equals(repoLocation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setRootDirectory(String root) {
    }

    @Override
    public void normalizeLocations(IInput.ILocationNormalizer locationNormalizer) {
        for (XMLElement unit : this.children()) {
            String location = unit.getAttribute("location");
            if (location == null) continue;
            String normalizedLocation = this.getNormalizedLocation(location, locationNormalizer);
            unit.addAttribute("location", normalizedLocation);
        }
    }

    private boolean shouldSkipAgentRepoLocation(String location) {
        if (AgentInstall.getInstance().isAgentInstallerRunning()) {
            return false;
        }
        String[] properties = new String[]{"eclipse.launcher", "cic.agentRelaunched"};
        File locationFile = new File(location);
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            String launcher = System.getProperty(property);
            if (launcher != null) {
                File launcherLocation = new File(launcher);
                try {
                    String locationPath;
                    String launcherPath;
                    if (launcherLocation.isFile()) {
                        launcherLocation = launcherLocation.getParentFile();
                    }
                    if ((launcherPath = launcherLocation.getCanonicalPath()).equals(locationPath = locationFile.getCanonicalPath())) {
                        return true;
                    }
                }
                catch (Exception e) {
                    ExceptionUtil.debugLogToReview((Throwable)e);
                }
            }
            ++n2;
        }
        return false;
    }
}

