/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.internal.response.IDocumentRoot;
import com.ibm.cic.agent.core.internal.response.IElement;
import com.ibm.cic.agent.core.internal.response.IResponseFactory;
import com.ibm.cic.agent.core.internal.response.impl.ResponseFactory;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResponseParser
extends DefaultHandler {
    private static ServiceTracker xmlTracker = null;
    private final BundleContext context;
    private final Stack elementStack = new Stack();
    private IElement currentElement;
    private final IResponseFactory nodeFactory = ResponseFactory.getInstance();
    private final CicMultiStatus parserStatus = Statuses.ST.createMultiStatus();
    private IDocumentRoot root = null;
    private static final Logger log = Logger.getLogger(ResponseParser.class, (Plugin)AgentActivator.getDefault());

    public static SAXParserFactory acquireXMLParsing(BundleContext context) {
        if (xmlTracker == null) {
            xmlTracker = new ServiceTracker(context, "javax.xml.parsers.SAXParserFactory", null);
            xmlTracker.open();
        }
        return (SAXParserFactory)xmlTracker.getService();
    }

    public static void releaseXMLParsing() {
        if (xmlTracker != null) {
            xmlTracker.close();
        }
    }

    public ResponseParser(BundleContext context) {
        this.context = context;
    }

    public IDocumentRoot parse(InputStream input, CicMultiStatus status) throws IOException, SAXException, ParserConfigurationException {
        this.getParser().parse(input, (DefaultHandler)this);
        if (!this.parserStatus.isOK()) {
            log.status((IStatus)this.parserStatus);
            status.add((IStatus)this.parserStatus);
        }
        return this.root;
    }

    public IElement parse(File file, CicMultiStatus status) throws IOException, SAXException, ParserConfigurationException {
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(file.getCanonicalFile()));
        try {
            IDocumentRoot iDocumentRoot = this.parse(input, status);
            return iDocumentRoot;
        }
        finally {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {}
        }
    }

    private SAXParser getParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = ResponseParser.acquireXMLParsing(this.context);
        if (factory == null) {
            throw new SAXException(Messages.InputParser_No_SAX_Parser_Found);
        }
        factory.setNamespaceAware(true);
        factory.setFeature("http://xml.org/sax/features/string-interning", true);
        factory.setValidating(false);
        return factory.newSAXParser();
    }

    @Override
    public void startDocument() {
        this.root = this.nodeFactory.createDocumentRoot();
        this.currentElement = this.root;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        this.elementStack.push(this.currentElement);
        this.currentElement = this.createElement(this.currentElement, localName, attrs);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.currentElement = (IElement)this.elementStack.pop();
    }

    private IElement createElement(IElement parentElement, String elmName, Attributes attrs) {
        IElement element = this.createElement(elmName);
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                element.setAttribute(attrs.getLocalName(i), attrs.getValue(i));
                ++i;
            }
        }
        parentElement.addChild(element);
        return element;
    }

    private IElement createElement(String elmName) {
        return this.nodeFactory.createNode(elmName);
    }
}

