/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.AbstractCommand;
import com.ibm.cic.agent.core.internal.commands.IListInstalledPackagesCommand;
import com.ibm.cic.agent.core.internal.commands.ListCommandUtil;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.cmd.ListPackagesUtil;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ListInstalledPackagesCommand
extends AbstractCommand
implements IListInstalledPackagesCommand {
    public ListInstalledPackagesCommand() {
        super("listInstalledPackages");
    }

    private IStatus listProfile(final Profile p, final Agent agent, OutputFormatter output, boolean verbose, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        if (CmdLine.CL.containsCommand("-verbose")) {
            if (p.shouldBeVisible()) {
                ListCommandUtil.listProfile(output, p, false, true);
                ListCommandUtil.listInstalledOfferings(output, p, agent);
            }
        } else {
            ListPackagesUtil.PackagesLister lister = new ListPackagesUtil.PackagesLister(CmdLine.CL, output){

                protected void outputFeatures(IOffering offering) {
                    Collection<IFeature> visibleInstalledFeatures = AgentUtil.getVisibleOptionalInstalledFeatures(agent, p, offering);
                    this.output.appendNT(new String[]{" : ", Util.toFeatureIdString(visibleInstalledFeatures)});
                }

                protected void outputRollbackVersions(IOffering offering) {
                    List<IOffering> rollbackOfferings = agent.getRollbackOfferings(p, offering);
                    if (rollbackOfferings.isEmpty()) {
                        this.output.appendNT(new String[]{" : ", ""});
                    } else {
                        this.output.appendNT(new String[]{" : ", Util.toVersionsString(rollbackOfferings)});
                    }
                }
            };
            if (p.shouldBeVisible()) {
                status = ListPackagesUtil.listPackagesCheckUseServiceRepositories((ListPackagesUtil.PackagesLister)lister, (String)p.getInstallLocation(), Arrays.asList(p.getInstalledOfferings()), Arrays.asList(p.getInstalledFixes()), (IProgressMonitor)monitor);
            }
            if (!status.isOK()) {
                return status;
            }
        }
        return status;
    }

    @Override
    public IStatus execute(Agent agent, IProgressMonitor monitor) {
        OutputFormatter output = new OutputFormatter();
        String installationDirectory = CmdLine.CL.getInstallationDirectory();
        boolean verbose = CmdLine.CL.containsCommand("-verbose");
        if (verbose) {
            ListCommandUtil.listSharedInformation(output, false, true);
        }
        if (installationDirectory != null) {
            Profile p = agent.getProfileByInstallLocation(installationDirectory);
            if (p == null) {
                return Statuses.ERROR.get(Messages.Cmd_installationDirectory_notFound, new Object[]{installationDirectory});
            }
            IStatus status = this.listProfile(p, agent, output, verbose, monitor);
            if (!status.isOK()) {
                return status;
            }
        } else {
            Collection<InstallRegistry.ProfileInstallRegistry> pirs = InstallRegistry.getInstance().getProfileInstallRegistries();
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, pirs.size());
            for (InstallRegistry.ProfileInstallRegistry pir : pirs) {
                IStatus status = this.listProfile(pir.getProfile(), agent, output, verbose, spm.next());
                if (status.isOK()) continue;
                return status;
            }
        }
        System.out.print(output.toString());
        return Status.OK_STATUS;
    }

    @Override
    public int getExecutionPoint() {
        return 4;
    }
}

