/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.ResponseFileBuilder;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.core.internal.headless.IVariablesCommand;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.MapSet;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.osgi.framework.Version;

public abstract class ResponseFileGenerator {
    public static final Version ANY_VERSION = new Version(0, 0, 0);
    private static final String INSTALL_LOCATION_VAR = "installLocation";
    protected final ResponseFileBuilder rfb;
    private final Map<IIdentity, Version> packages = new HashMap<IIdentity, Version>();
    private final MapSet<IIdentity, Version> included = MapSet.newHash();

    public ResponseFileGenerator() {
        this.rfb = new ResponseFileBuilder();
    }

    protected abstract void doGenerate() throws CoreException;

    protected abstract IStatus missingPackageError(String var1);

    protected abstract IStatus nothingIncludedError();

    public void addPackage(IIdentity id) {
        this.addPackage(id, ANY_VERSION);
    }

    public void addPackage(IIdentity id, Version version) {
        this.packages.put(id, version);
    }

    public void generate(File output) throws CoreException {
        this.generate();
        this.rfb.save(output);
    }

    public IInput generate() throws CoreException {
        this.doGenerate();
        this.checkPackages();
        if (this.nothingIncluded()) {
            throw new CoreException(this.nothingIncludedError());
        }
        return this.rfb.getAsInput();
    }

    protected <T extends IOfferingOrFix> Collection<T> filterPackages(T[] pkgs) {
        return this.filterPackages(Arrays.asList(pkgs));
    }

    protected <T extends IOfferingOrFix> Collection<T> filterPackages(Collection<T> pkgs) {
        ArrayList<IOfferingOrFix> result = new ArrayList<IOfferingOrFix>(pkgs.size());
        for (IOfferingOrFix pkg : pkgs) {
            if (!this.includePackage(pkg)) continue;
            result.add(pkg);
        }
        return result;
    }

    private boolean nothingIncluded() {
        return this.included.isEmpty();
    }

    private void includes(IOfferingOrFix pkg) {
        this.included.add((Object)pkg.getIdentity(), (Object)pkg.getVersion());
    }

    protected IVariablesCommand.IVariable profile(String profileId, String installLoc, boolean multiProfile, Collection<? extends IOfferingOrFix> pkgs) {
        String varName = INSTALL_LOCATION_VAR;
        if (multiProfile) {
            varName = String.valueOf(varName) + '.' + profileId.replaceAll("[^a-zA-Z0-9_.]+", "_");
        }
        IVariablesCommand.IVariable variable = this.rfb.addVariable(varName, installLoc);
        if (pkgs.size() > 1) {
            variable.addComment(Messages.ResponseFileFromRepositories_Install_Location_For);
            for (IOfferingOrFix iOfferingOrFix : pkgs) {
                variable.addComment("  " + iOfferingOrFix.getName());
            }
        } else {
            IOfferingOrFix iOfferingOrFix = pkgs.iterator().next();
            variable.addComment(NLS.bind((String)Messages.ResponseFileFromRepositories_Install_Location_For_Offering, (Object)iOfferingOrFix.getName()));
        }
        this.rfb.profile(profileId, new File(PlatformUtils.variableRef((String)varName)));
        return variable;
    }

    protected void install(IOffering offering, String features) {
        this.rfb.install(offering, features);
        this.includes((IOfferingOrFix)offering);
    }

    protected void install(IOffering offering, Collection<IFeature> features) {
        this.rfb.install(offering, features);
        this.includes((IOfferingOrFix)offering);
    }

    protected void install(IFix fix) {
        this.rfb.install(fix);
        this.includes((IOfferingOrFix)fix);
    }

    private void checkPackages() throws CoreException {
        if (this.packages.isEmpty()) {
            return;
        }
        for (Map.Entry<IIdentity, Version> entry : this.packages.entrySet()) {
            IIdentity id = entry.getKey();
            Version version = entry.getValue();
            String idv = id.getId();
            if (version != ANY_VERSION) {
                idv = String.valueOf(idv) + '_' + version.toString();
            }
            if (this.wasIncluded(id, version)) continue;
            throw new CoreException(this.missingPackageError(idv));
        }
    }

    private boolean wasIncluded(IIdentity id, Version version) {
        if (version == ANY_VERSION) {
            return this.included.contains((Object)id);
        }
        return this.included.contains((Object)id, (Object)version);
    }

    private boolean includePackage(IOfferingOrFix pkg) {
        if (Agent.getInstance().isAgentOffering(pkg)) {
            return false;
        }
        if (this.packages.isEmpty()) {
            return true;
        }
        Version version = this.packages.get(pkg.getIdentity());
        return version == ANY_VERSION || pkg.getVersion().equals((Object)version);
    }
}

