/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AbstractInstallOperation;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.InstallOperationEventManager;
import com.ibm.cic.common.core.model.Phases;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

class LoggerInstallOperationDebug
implements LogManager.ILogDirChangeListener,
InstallOperationEventManager.IInstallOperationListener {
    private static final Logger log = Logger.getLogger((String)"InstallOperation");
    private static String prefix = "";
    public static final LoggerInstallOperationDebug INSTANCE = new LoggerInstallOperationDebug();
    private static final String UNDOING_PREFIX = "UNDOING ";
    private final Actions actions = new Actions();

    private LoggerInstallOperationDebug() {
        LogManager.addLogDirChangeListener((LogManager.ILogDirChangeListener)this);
        this.logDirChanged(null);
    }

    private boolean isEnabled() {
        return log.isDebugLoggable() || !this.actions.isEmpty();
    }

    public void start() {
        if (this.isEnabled()) {
            InstallOperationEventManager.INSTANCE.addListener(this);
        }
    }

    public void stop() {
        InstallOperationEventManager.INSTANCE.removeListener(this);
    }

    public String toString() {
        return "actions: " + this.actions;
    }

    @Override
    public InstallOperationEventManager.IAction perform(AbstractInstallOperation op, CicMultiStatus result, IProgressMonitor monitor) {
        if (!this.isEnabled()) {
            return Action.NOTHING;
        }
        String desc = Descriptor.getDesc(op);
        log.debug(desc);
        String xml = op.getData().toXML(false);
        log.debug(xml);
        result.add(this.getAction(When.BEFORE, desc, xml).perform(op, Status.OK_STATUS, monitor));
        return this.getAction(When.AFTER, desc, xml);
    }

    private Action getAction(When when, String desc, String opDataXml) {
        return this.actions.get(when, desc, opDataXml).and(this.actions.get(when, "*"));
    }

    public void logDirChanged(File newDir) {
        this.actions.refresh();
        LoggerInstallOperationDebug.refreshPrefix();
        if (this.isEnabled()) {
            InstallOperationEventManager.INSTANCE.addListener(this);
        } else {
            InstallOperationEventManager.INSTANCE.removeListener(this);
        }
    }

    private static void refreshPrefix() {
        String p = log.getAttr("prefix");
        prefix = p == null ? "" : String.valueOf(p) + ' ';
    }

    private static abstract class Action
    implements InstallOperationEventManager.IAction {
        public static final Action NOTHING = new NullAction();
        public static final Action CANCEL = new CancelAction();
        public static final Action ERROR = new ErrorAction();
        public static final Action WARNING = new WarningAction();
        public static final Action PAUSE = new PauseAction();
        public static final Action PAUSE_ON_ERROR = new PauseOnError();
        public static final Action PAUSE_ON_WARNING = new PauseOnWarning();
        public final String name;

        private Action(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public abstract IStatus perform(AbstractInstallOperation var1, IStatus var2, IProgressMonitor var3);

        public void parseAttr(When when, Map<String, Action> map) {
            String attrName = (String.valueOf(this.getName()) + '.' + when.name()).toLowerCase(Locale.ENGLISH);
            String value = log.getAttr(attrName);
            if (value == null || value.length() == 0) {
                return;
            }
            String expr = "^([^:,]+):([^:,]+):([^:,]+)(?:|:(\\d+)|:/(.*?)/)($|,)";
            Pattern pattern = Pattern.compile(expr);
            int i = 0;
            while (i < value.length()) {
                String v = value.substring(i);
                Matcher matcher = pattern.matcher(v);
                try {
                    if (matcher.find()) {
                        String desc = matcher.group();
                        i += desc.length();
                        String phaseName = matcher.group(1);
                        if (phaseName.startsWith(LoggerInstallOperationDebug.UNDOING_PREFIX)) {
                            if (!this.supportsUndoingOperations()) {
                                throw new ParseException("UNDOING operation not allowed for " + attrName + " property");
                            }
                            phaseName = phaseName.substring(LoggerInstallOperationDebug.UNDOING_PREFIX.length());
                        }
                        if (Phases.nameToPhase((String)phaseName) == -1) {
                            throw new ParseException("Invalid phase name: " + phaseName);
                        }
                        if (desc.endsWith(",")) {
                            desc = desc.substring(0, desc.length() - 1);
                        }
                        this.addTo(desc, map);
                        continue;
                    }
                    i += v.length();
                    Descriptor.parseError(v);
                }
                catch (ParseException e) {
                    log.errorNoUid("Error parsing \"{0}\" in debug option {1}/{2}={3}\n  {4}", new Object[]{v, log.getName(), attrName, value, e.getMessage()});
                }
            }
        }

        protected boolean supportsUndoingOperations() {
            return false;
        }

        protected void addTo(String desc, Map<String, Action> map) {
            map.put(desc, this.and(map.get(desc)));
        }

        public Action and(final Action action2) {
            final Action action1 = this;
            return action2 == null || action2 == NOTHING ? action1 : new Action(action1 + " and " + action2){

                @Override
                public IStatus perform(AbstractInstallOperation op, IStatus status, IProgressMonitor monitor) {
                    CicMultiStatus result = Statuses.ST.createMultiStatus();
                    result.add(action1.perform(op, status, monitor));
                    result.add(action2.perform(op, status, monitor));
                    return StatusUtil.toSingleStatus((IStatus)result);
                }
            };
        }

        private static class CancelAction
        extends Action {
            public CancelAction() {
                super("CANCEL");
            }

            @Override
            public IStatus perform(AbstractInstallOperation op, IStatus status, IProgressMonitor monitor) {
                String desc = Descriptor.getDesc(op);
                System.out.println(NLS.bind((String)"Operation \"{0}\" canceled due to debug option", (Object)desc));
                monitor.setCanceled(true);
                return Status.OK_STATUS;
            }
        }

        private static class ErrorAction
        extends StatusSeverityAction {
            public ErrorAction() {
                super(4);
            }
        }

        private static class NullAction
        extends Action {
            public NullAction() {
                super("NOTHING");
            }

            @Override
            public IStatus perform(AbstractInstallOperation op, IStatus status, IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }

            @Override
            public Action and(Action action2) {
                return action2;
            }
        }

        private static class PauseAction
        extends Action {
            public PauseAction() {
                super("PAUSE");
            }

            @Override
            public IStatus perform(AbstractInstallOperation op, IStatus status, IProgressMonitor monitor) {
                String desc = Descriptor.getDesc(op);
                System.out.print(NLS.bind((String)"Hit enter to continue install from pause of operation \"{0}\" ...", (Object)desc));
                System.out.flush();
                try {
                    int c;
                    while ((c = System.in.read()) != -1 && c != 10) {
                    }
                }
                catch (IOException e) {
                    ExceptionUtil.debugLogToReview((Throwable)e);
                }
                System.out.println("Continuing");
                return Status.OK_STATUS;
            }

            @Override
            protected boolean supportsUndoingOperations() {
                return true;
            }
        }

        private static class PauseOnError
        extends PauseOnSeverity {
            public PauseOnError() {
                super(4);
            }
        }

        private static abstract class PauseOnSeverity
        extends Action {
            private final int severity;
            private boolean havePaused = false;

            public PauseOnSeverity(int severity) {
                super("PAUSE.ON_" + StatusUtil.severityToString((int)severity));
                this.severity = severity;
            }

            @Override
            public IStatus perform(AbstractInstallOperation op, IStatus status, IProgressMonitor monitor) {
                if (!this.havePaused && status.matches(this.severity)) {
                    String desc = Descriptor.getDesc(op);
                    System.out.println(NLS.bind((String)"Pausing operation \"{0}\" due to {1}:", (Object)desc, (Object)StatusUtil.severityToString((int)this.severity).toLowerCase(Locale.ENGLISH)));
                    System.out.println(LogUtil.toString((IStatus)status));
                    PAUSE.perform(op, status, monitor);
                    this.havePaused = true;
                }
                return Status.OK_STATUS;
            }

            @Override
            public void parseAttr(When when, Map<String, Action> map) {
                if (when == When.AFTER) {
                    String attrName = this.getName();
                    String value = log.getAttr(attrName);
                    if (Boolean.valueOf(value).booleanValue()) {
                        this.addTo("*", map);
                    }
                }
            }
        }

        private static class PauseOnWarning
        extends PauseOnSeverity {
            public PauseOnWarning() {
                super(2);
            }
        }

        private static abstract class StatusSeverityAction
        extends Action {
            private final int severity;

            public StatusSeverityAction(int severity) {
                super(StatusUtil.severityToString((int)severity));
                this.severity = severity;
            }

            @Override
            public IStatus perform(AbstractInstallOperation op, IStatus status, IProgressMonitor monitor) {
                String desc = Descriptor.getDesc(op);
                return new Status(this.severity, Agent.PI_AGENT, 0, NLS.bind((String)"Operation \"{0}\" returned {1} due to debug option", (Object)desc, (Object)this.getName().toLowerCase(Locale.ENGLISH)), null);
            }

            @Override
            protected boolean supportsUndoingOperations() {
                return true;
            }
        }

        private static class WarningAction
        extends StatusSeverityAction {
            public WarningAction() {
                super(2);
            }
        }
    }

    private static class Actions {
        public static final List<Action> ALL = Arrays.asList(Action.CANCEL, Action.ERROR, Action.WARNING, Action.PAUSE, Action.PAUSE_ON_ERROR, Action.PAUSE_ON_WARNING);
        private final Map<When, Map<String, Action>> actions = Actions.getInitActions();

        public String toString() {
            return this.actions.toString();
        }

        public Action get(When when, String desc) {
            Action action = this.actions.get((Object)when).get(desc);
            return action == null ? Action.NOTHING : action;
        }

        public Action get(When when, String desc, String opDataXml) {
            Map<String, Action> map;
            Action action;
            if (prefix.length() > 0 && desc.startsWith(prefix)) {
                desc = desc.substring(prefix.length());
            }
            if ((action = (map = this.actions.get((Object)when)).get(desc)) != null) {
                return action;
            }
            for (Map.Entry<String, Action> entry : map.entrySet()) {
                String regex;
                Pattern pattern;
                Matcher matcher;
                String p;
                String key = entry.getKey();
                int i = key.indexOf("/");
                int j = key.lastIndexOf("/");
                if (i <= 0 || j + 1 != key.length() || !desc.startsWith(p = key.substring(0, i - 1)) || !(matcher = (pattern = Pattern.compile(regex = key.substring(i + 1, key.length() - 1))).matcher(opDataXml)).find()) continue;
                return entry.getValue();
            }
            return Action.NOTHING;
        }

        public void refresh() {
            When[] whenArray = When.values();
            int n = whenArray.length;
            int n2 = 0;
            while (n2 < n) {
                When when = whenArray[n2];
                Map<String, Action> map = this.actions.get((Object)when);
                map.clear();
                for (Action action : ALL) {
                    action.parseAttr(when, map);
                }
                ++n2;
            }
        }

        public boolean isEmpty() {
            for (Map<String, Action> map : this.actions.values()) {
                if (map.isEmpty()) continue;
                return false;
            }
            return true;
        }

        private static Map<When, Map<String, Action>> getInitActions() {
            TreeMap<When, Map<String, Action>> actions = new TreeMap<When, Map<String, Action>>();
            actions.put(When.BEFORE, new TreeMap());
            actions.put(When.AFTER, new TreeMap());
            return actions;
        }
    }

    private static class Descriptor {
        public static final String ANY = "*";
        private static final String SEPARATOR = ":";
        private static final String REGEX_QUOTE = "/";

        private Descriptor() {
        }

        public static String getDesc(AbstractInstallOperation op) {
            String opName = op.getData().getElementName();
            String phaseName = Phases.phaseToName((int)op.getPhase());
            String iuId = op.getUnit().getQualifiedId().getId();
            int opIndex = op.getOperationIndex();
            if (op.isUndoing()) {
                return String.valueOf(prefix) + LoggerInstallOperationDebug.UNDOING_PREFIX + Descriptor.create(phaseName, iuId, opName, opIndex);
            }
            return String.valueOf(prefix) + Descriptor.create(phaseName, iuId, opName, opIndex);
        }

        public static void parseError(String desc) throws ParseException {
            String[] d = desc.split(SEPARATOR, 4);
            try {
                if (d.length < 3 || d.length > 4) {
                    throw new ParseException("Expected 2 or 3 colons, found " + (d.length - 1));
                }
                if (Phases.nameToPhase((String)d[0]) == -1) {
                    throw new ParseException("Invalid phase name: " + d[0]);
                }
                if (d.length == 4 && d[3].startsWith(REGEX_QUOTE) && d[3].endsWith(REGEX_QUOTE)) {
                    throw new ParseException("Unknown Error - passed all checks");
                }
                if (d.length == 4 && d[3].length() >= 0) {
                    Integer.parseInt(d[3]);
                }
                throw new ParseException("Unknown Error - passed all checks");
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid count or regular expression: " + d[3]);
            }
        }

        private static String create(String phaseName, String iuId, String opName, int num) {
            StringBuffer sb = new StringBuffer(32);
            sb.append(phaseName).append(SEPARATOR).append(iuId).append(SEPARATOR).append(opName);
            if (num > 0) {
                sb.append(SEPARATOR).append(num);
            }
            return sb.toString();
        }
    }

    private static class ParseException
    extends Exception {
        public ParseException(String msg) {
            super(msg);
        }
    }

    private static enum When {
        BEFORE,
        AFTER;

    }
}

