/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.VariableSubstitution;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.Input;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.cmd.CmdCommand;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.ConvertUtil;
import com.ibm.cic.common.core.utils.DeviceSystem;
import com.ibm.cic.common.core.utils.EclipseUtil;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.SplitIdVersionUtil;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.downloads.FormatUtil;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.osgi.framework.Version;

public class AgentRelaunch {
    private static final String ORG_ECLIPSE_UI_INTERNAL_REGISTRY_UI_EXTENSION_TRACKER = "org.eclipse.ui.internal.registry.UIExtensionTracker";
    private static final Logger log = Logger.getLogger(AgentRelaunch.class);
    private static AgentRelaunch instance = null;
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final String EXIT_DATA_ARG = "-exitdata";
    private static final String NL_ARG = "-nl";
    private static final String WS_ARG = "-ws";
    private static final String OS_ARG = "-os";
    private static final String ARCH_ARG = "-arch";
    private static final String KEYRING_ARG = "-keyring";
    private static final String PASSWORD_ARG = "-password";
    private static final String TEMPORARY_INSTALLER = ".temporary-installer";
    private static final String CLEANER_EXE = "cleaner.exe";
    public static final String CLEANUP_TEMPORARY_INSTALLER = "cleanup.temporary.installer";
    public static final String INI_EXT = ".ini";
    private static final String UNINSTALL_DIR = "uninstall";
    private String relaunchVm = null;
    private String[] relaunchVmArgs = null;
    private String[] relaunchProgramArgs = null;
    private String[] relaunchApplicationArgs = null;
    private String relaunchWs = null;
    private String relaunchArch = null;
    private boolean needsRelaunch = false;
    private boolean relaunchOfAgent = true;
    private File relaunchTemporaryInstaller = null;
    private String relaunchLauncher = null;
    private String[] eclipseCommands = null;
    private boolean isAgentPostUpdateInProgress = false;
    private IAgentApp agentApp = new DefaultAgentApp();

    public static AgentRelaunch getInstance() {
        if (instance == null) {
            instance = new AgentRelaunch();
        }
        return instance;
    }

    @Deprecated
    public static void refresh() {
        instance = null;
    }

    public String setDefaultRelaunchArguments(String launcher, String vm, String[] vmargs, String[] programargs, String ws, String arch) {
        assert (launcher != null) : "setDefaultRelaunchArguments(): launcher is null";
        assert (vm != null) : "setDefaultRelaunchArguments(): vm is null";
        assert (vmargs != null) : "setDefaultRelaunchArguments(): vmargs is null";
        assert (programargs != null) : "setDefaultRelaunchArguments(): programargs is null";
        assert (ws != null) : "setDefaultRelaunchArguments(): ws is null";
        assert (arch != null) : "setDefaultRelaunchArguments(): arch is null";
        if (CmdLine.CL.isSilentMode()) {
            launcher = this.getSilentLauncher(launcher);
        }
        if (this.isTemporaryInstaller()) {
            this.relaunchLauncher = launcher;
        }
        this.relaunchVm = vm;
        this.relaunchVmArgs = vmargs;
        this.relaunchProgramArgs = programargs;
        this.relaunchApplicationArgs = this.agentApp.getApplicationArgs();
        this.relaunchWs = ws;
        this.relaunchArch = arch;
        return launcher;
    }

    private String getSilentLauncher(String launcher) {
        boolean isWin32 = "win32".equals(Platform.getOS());
        if (!isWin32 || launcher.endsWith("c.exe")) {
            return launcher;
        }
        File silentLauncher = new File(String.valueOf(launcher.substring(0, launcher.length() - 4)) + "c.exe");
        return silentLauncher.isFile() ? silentLauncher.getPath() : launcher;
    }

    public boolean setRelaunchWithLauncherIniArguments() {
        File agentDir = Agent.getInstance().getAgentInstanceLocation();
        return this.getLauncherIniArguments(agentDir, null) != null;
    }

    public void setRelaunchForUninstall(File installLocation) {
        installLocation = AgentInstall.getInstance().getLogicalInstallLocation(installLocation);
        String[] dirsToDelete = new String[]{installLocation.getPath(), CicCommonSettings.getApplicationDataLocation()};
        File helper = new File(AgentRelaunch.getUninstallDir(), "UninstallHelper.exe");
        this.setRelaunchForCleanup(dirsToDelete, helper);
        this.deleteImInstallerState();
    }

    public boolean setRelaunchWithInstalledLauncherIniArguments(File agentDir) {
        String launcher = this.getLauncherIniArguments(agentDir, null);
        if (launcher != null && (this.isVmInLauncher() || AgentInstall.getInstance().isInstallFromMultipleDisks())) {
            this.relaunchLauncher = launcher;
        }
        return launcher != null;
    }

    public boolean setRelaunchWithInstalledLauncherIniArguments(File agentDir, File pluginsDir, File configIni, boolean forceLauncher) {
        String launcher = this.getLauncherIniArguments(agentDir, null, pluginsDir, configIni);
        if (launcher != null && (this.isVmInLauncher() || AgentInstall.getInstance().isInstallFromMultipleDisks()) || forceLauncher) {
            this.relaunchLauncher = launcher;
        }
        return launcher != null;
    }

    public void setRelaunchApplicationArguments(String[] appargs) {
        assert (appargs != null) : "setRelaunchApplicationArguments(): appargs is null";
        assert (this.relaunchVm != null) : "setRelaunchApplicationArguments(): relaunchVm is null";
        this.relaunchApplicationArgs = appargs;
    }

    public void addRelaunchApplicationArguments(String[] appargs) {
        assert (appargs != null) : "setRelaunchApplicationArguments(): appargs is null";
        assert (this.relaunchVm != null) : "setRelaunchApplicationArguments(): relaunchVm is null";
        assert (this.relaunchApplicationArgs != null) : "setRelaunchApplicationArguments(): relaunchApplicationArgs is null";
        String[] newappargs = new String[this.relaunchApplicationArgs.length + appargs.length];
        System.arraycopy(this.relaunchApplicationArgs, 0, newappargs, 0, this.relaunchApplicationArgs.length);
        System.arraycopy(appargs, 0, newappargs, this.relaunchApplicationArgs.length, appargs.length);
        this.relaunchApplicationArgs = newappargs;
    }

    public String[] getRelaunchProgramArguments() {
        return this.relaunchProgramArgs;
    }

    public String[] getRelaunchApplicationArguments() {
        return this.relaunchApplicationArgs;
    }

    public String getSuggestedIniFile() {
        String return_value = null;
        String toolId = CmdLine.CL.getParam1StrVal("-toolId");
        if ("macosx".equals(Platform.getOS())) {
            if ("install".equals(toolId)) {
                return_value = "Install.app/Contents/MacOS/install.ini";
            } else if ("installc".equals(toolId)) {
                return_value = "installc.ini";
            } else if ("userinst".equals(toolId)) {
                return_value = "Userinst.app/Contents/MacOS/userinst.ini";
            } else if ("userinstc".equals(toolId)) {
                return_value = "userinstc.ini";
            } else if ("groupinst".equals(toolId)) {
                return_value = "Groupinst.app/Contents/MacOS/groupinst.ini";
            } else if ("groupinstc".equals(toolId)) {
                return_value = "groupinstc.ini";
            }
        } else if ("install".equals(toolId)) {
            return_value = "install.ini";
        } else if ("installc".equals(toolId)) {
            return_value = "installc.ini";
        } else if ("userinst".equals(toolId)) {
            return_value = "userinst.ini";
        } else if ("userinstc".equals(toolId)) {
            return_value = "userinstc.ini";
        } else if ("groupinst".equals(toolId)) {
            return_value = "groupinst.ini";
        } else if ("groupinstc".equals(toolId)) {
            return_value = "groupinstc.ini";
        }
        return return_value;
    }

    private File createSecureTempDir(String prefix, boolean isWindows) throws IOException {
        int previousUmask = 0;
        if (!isWindows) {
            previousUmask = PlatformUtils.getUmask();
        }
        try {
            if (!isWindows) {
                PlatformUtils.setUmask((int)63);
            }
            File file = FileUtil.createTempDir((String)prefix, null, null);
            return file;
        }
        finally {
            if (!isWindows) {
                PlatformUtils.setUmask((int)previousUmask);
            }
        }
    }

    public IStatus setRelaunchWithTemporaryInstaller(File installerLocation, String[] fileExclusions, IProgressMonitor monitor) {
        File dest;
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, Messages.AgentRelaunch_copyInstallationManager, new int[]{1, 98, 1});
        try {
            boolean isWin32 = "win32".equals(Platform.getOS());
            dest = this.createSecureTempDir("IBMIM", isWin32);
            File mountPoint = DeviceSystem.getMountPoint((File)dest);
            long freeSpace = DeviceSystem.getFreeSpace((File)mountPoint);
            long requiredSpace = FileUtil.getFileSizeOnDisk4kBlocks((File)installerLocation);
            if (requiredSpace > freeSpace) {
                return new Status(4, AgentActivator.getPluginId(), 0, NLS.bind((String)Messages.AgentRelaunch_insufficientSpaceToCopyInstallationManager, (Object[])new Object[]{dest.getPath(), FormatUtil.formatBytes((long)freeSpace), FormatUtil.formatBytes((long)requiredSpace)}), null);
            }
            this.relaunchTemporaryInstaller = dest;
            if (isWin32) {
                this.unzipCleaner(installerLocation, dest);
            }
            File tiFile = new File(dest, TEMPORARY_INSTALLER);
            FileUtil.writeFile((File)tiFile, (String)"");
            pm.next().done();
            FileUtil.copyDir((File)installerLocation, (File)dest, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (String)"", (IProgressMonitor)pm.next());
            if (monitor.isCanceled()) {
                return Status.OK_STATUS;
            }
            if (!isWin32) {
                FileUtil.chmod((String)"u+rx", (boolean)true, (String[])new String[]{dest.getPath()});
            }
            String[] stringArray = fileExclusions;
            int n = fileExclusions.length;
            int n2 = 0;
            while (n2 < n) {
                String fileExclusion = stringArray[n2];
                File excludedFile = new File(dest, fileExclusion);
                if (excludedFile.isFile() && !excludedFile.delete()) {
                    return Statuses.ERROR.get(Messages.CacheManager_Failed_To_DeleteError, new Object[]{excludedFile.getPath()});
                }
                ++n2;
            }
        }
        catch (IOException e) {
            return new Status(4, AgentActivator.getPluginId(), 0, e.toString(), null);
        }
        String launcher = this.getLauncherIniArguments(dest, this.getSuggestedIniFile());
        if (launcher == null) {
            return new Status(4, AgentActivator.getPluginId(), 0, NLS.bind((String)Messages.AgentRelaunch_relaunchProblem, (Object)LogManager.getDefaultLogFile().getPath()), null);
        }
        File vm = new File(this.relaunchVm);
        if (!vm.isAbsolute()) {
            vm = "macosx".equals(Platform.getOS()) && this.relaunchVm.startsWith("../../../") ? new File(dest, this.relaunchVm.substring(9)) : new File(dest, this.relaunchVm);
        }
        try {
            this.relaunchVm = vm.getCanonicalPath();
        }
        catch (IOException e) {
            this.relaunchVm = vm.getPath();
        }
        if ("macosx".equals(Platform.getOS())) {
            this.createMacosxJreSymlink(dest);
        }
        if (this.isLibraryVM(this.relaunchVm) && !"macosx".equals(Platform.getOS())) {
            String newVm = this.findJavaExe(dest, this.relaunchVm);
            if (newVm == null) {
                return new Status(4, AgentActivator.getPluginId(), 0, NLS.bind((String)Messages.AgentRelaunch_relaunchProblem, (Object)LogManager.getDefaultLogFile().getPath()), null);
            }
            this.relaunchVm = newVm;
        }
        try {
            this.normalizeInput(installerLocation, dest);
        }
        catch (IOException e) {
            return new Status(4, AgentActivator.getPluginId(), 0, e.toString(), null);
        }
        this.setNeedsRelaunch(true);
        this.relaunchLauncher = launcher;
        pm.next().done();
        return Status.OK_STATUS;
    }

    private void createMacosxJreSymlink(File installerLocation) {
        if (installerLocation == null || !installerLocation.isDirectory()) {
            return;
        }
        File[] jreDirs = installerLocation.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() && f.getName().startsWith("jre_");
            }
        });
        if (jreDirs == null) {
            return;
        }
        File[] fileArray = jreDirs;
        int n = jreDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File jrePath = fileArray[n2];
            File libjli = new File(jrePath, "jre/Contents/MacOS/libjli.dylib");
            if (!PlatformUtils.isSymlink((File)libjli)) {
                libjli.delete();
                PlatformUtils.createSymlink((String)(jrePath + "/jre/Contents/Home/lib/jli/libjli.dylib"), (String)libjli.getAbsolutePath());
            }
            ++n2;
        }
    }

    public IStatus cancelRelaunchWithTemporaryInstaller() {
        this.relaunchVm = null;
        this.relaunchVmArgs = null;
        this.relaunchProgramArgs = null;
        this.relaunchApplicationArgs = null;
        this.relaunchWs = null;
        this.relaunchArch = null;
        this.needsRelaunch = false;
        this.relaunchLauncher = null;
        if (this.relaunchTemporaryInstaller != null && this.relaunchTemporaryInstaller.isDirectory()) {
            FileUtil.rm_r((File)this.relaunchTemporaryInstaller, (boolean)true);
            this.relaunchTemporaryInstaller = null;
        }
        return new Status(1, AgentActivator.getPluginId(), 0, Messages.AgentRelaunch_copyInterrupted, null);
    }

    public boolean needsRelaunch() {
        return this.needsRelaunch;
    }

    public void setNeedsRelaunch(boolean needsRelaunch) {
        this.needsRelaunch = needsRelaunch;
    }

    private void addToVmArgs(String newVmArg) {
        String[] newVmArgs = new String[this.relaunchVmArgs.length + 1];
        newVmArgs[0] = newVmArg;
        System.arraycopy(this.relaunchVmArgs, 0, newVmArgs, 1, this.relaunchVmArgs.length);
        this.relaunchVmArgs = newVmArgs;
    }

    public Object checkForRelaunch(Object exitCode) {
        if (IApplication.EXIT_RESTART.equals(exitCode)) {
            this.needsRelaunch = true;
        }
        if (this.relaunchVm == null) {
            this.needsRelaunch = false;
        }
        boolean temporaryInstaller = this.isTemporaryInstaller();
        if (!this.needsRelaunch && temporaryInstaller) {
            this.setRelaunchForTemporaryInstallerCleanup();
        }
        if (!this.needsRelaunch) {
            return exitCode;
        }
        if (this.relaunchOfAgent) {
            String agentRelaunchedFrom;
            if (temporaryInstaller) {
                File installerLocation = this.getAgentInstallerLocation();
                this.addToVmArgs("-Dcleanup.temporary.installer=" + installerLocation.getPath());
            }
            if ((agentRelaunchedFrom = System.getProperty("cic.agentRelaunched")) == null) {
                agentRelaunchedFrom = Agent.getInstance().getAgentSelfLocation().getAbsolutePath();
            }
            this.addToVmArgs("-Dcic.agentRelaunched=" + agentRelaunchedFrom);
        }
        return this.setRelaunchProperties();
    }

    public boolean isLibraryVM(String vm) {
        if ("macosx".equals(Platform.getOS())) {
            return !this.isLauncherRunningJvmOutOfProc() && this.relaunchTemporaryInstaller == null;
        }
        String lcVm = vm.toLowerCase();
        return lcVm.endsWith(".dll") || lcVm.endsWith(".so");
    }

    public boolean isVmInLauncher() {
        String currVm = System.getProperty(PROP_VM);
        if (currVm == null) {
            return false;
        }
        return this.isLibraryVM(currVm);
    }

    public String findJavaExe(File installLocation, String vm) {
        File dir;
        File file = new File(vm);
        if (!file.isAbsolute()) {
            file = "macosx".equals(Platform.getOS()) && vm.startsWith("../../../") ? new File(installLocation, vm.substring(9)) : new File(installLocation, vm);
        }
        if (!"bin".equalsIgnoreCase((dir = file.getParentFile()).getName())) {
            File binDir;
            do {
                if ((dir = dir.getParentFile()) != null) continue;
                log.error("findJavaExe(): cannot find location of java exe for this JVM: \"{0}\"", new Object[]{vm});
                return null;
            } while (!(binDir = new File(dir, "bin")).isDirectory());
            dir = binDir;
        }
        file = "win32".equals(Platform.getOS()) ? (this.isSilentInstall(this.agentApp.getApplicationArgs()) ? new File(dir, "java.exe") : new File(dir, "javaw.exe")) : new File(dir, "java");
        if (!file.isFile()) {
            log.error("findJavaExe(): cannot find location of java exe for this JVM: \"{0}\"", new Object[]{vm});
            return null;
        }
        return file.getPath();
    }

    public void logArguments() {
        String none = "<none>";
        log.debug("eclipse.vm={0}", new Object[]{System.getProperty(PROP_VM, none)});
        log.debug("eclipse.vmargs={0}", new Object[]{System.getProperty(PROP_VMARGS, none)});
        log.debug("eclipse.commands={0}", new Object[]{System.getProperty(PROP_COMMANDS, none)});
        String[] args = this.agentApp.getApplicationArgs();
        String formattedArgs = none;
        if (args.length != 0) {
            StringBuffer sb = new StringBuffer();
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                sb.append(String.valueOf(arg) + '\n');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
            formattedArgs = sb.toString();
        }
        log.debug("getApplicationArgs()={0}", new Object[]{formattedArgs});
    }

    private String getLauncher(File iniFile) {
        String return_value = AgentRelaunch.getLauncherPath(iniFile);
        if (return_value == null) {
            log.error("getLauncher(): cannot find exe location for launcher ini \"{0}\"", new Object[]{iniFile.getPath()});
        }
        return return_value;
    }

    private String getMacosxLauncherLibrary(File pluginsDir) {
        String macosxLauncherPlugin = this.getLauncherPluginLocation(pluginsDir, "com.ibm.cic.agent.core.launcher.macosx");
        File macosxLauncherPluginBinary = new File(new File(macosxLauncherPlugin, "binary"), "macosx.cocoa.x86_64");
        File[] libs = macosxLauncherPluginBinary.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("eclipse_") && name.endsWith(".so");
            }
        });
        if (libs != null && libs.length > 0) {
            return libs[0].getPath();
        }
        return null;
    }

    private String getLauncherPluginLocation(File pluginsDir, String pluginId) {
        final String pluginPrefix = String.valueOf(pluginId) + '_';
        File[] plugins = pluginsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(pluginPrefix);
            }
        });
        if (plugins == null || plugins.length == 0) {
            log.error("getLauncherPluginLocation(): cannot find location for launcher plugin \"{0}\"", new Object[]{pluginId});
            return null;
        }
        Version maxVersion = Version.emptyVersion;
        File maxPlugin = null;
        File[] fileArray = plugins;
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            File plugin = fileArray[n2];
            Object[] idAndVersion = SplitIdVersionUtil.splitIdUnderscoreVersion((String)plugin.getName());
            Version version = (Version)idAndVersion[1];
            if (version != null && version.compareTo(maxVersion) > 0) {
                maxVersion = version;
                maxPlugin = plugin;
            }
            ++n2;
        }
        if (maxPlugin == null) {
            maxPlugin = plugins[0];
        }
        return maxPlugin.getPath();
    }

    public static File getUninstallDir() {
        return new File(CicCommonSettings.getApplicationDataLocation(), UNINSTALL_DIR);
    }

    public static File[] getLauncherIniFiles(File agentDir) {
        File[] return_value = agentDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(AgentRelaunch.INI_EXT);
            }
        });
        return return_value;
    }

    private static File getLauncherIniFile(File agentDir, String suggestedIni) {
        File launcherDir;
        File[] iniFiles;
        File iniCandidate;
        File return_value = null;
        if (suggestedIni != null && (iniCandidate = new File(agentDir, suggestedIni)).exists() && AgentRelaunch.getLauncherPath(iniCandidate) != null) {
            return_value = iniCandidate;
        }
        if (return_value == null && (iniFiles = AgentRelaunch.getLauncherIniFiles(launcherDir = "macosx".equals(Platform.getOS()) && !CmdLine.CL.isServerMode() ? new File(new File(new File(agentDir, "IBMIM.app"), "Contents"), "MacOS") : agentDir)) != null) {
            File[] fileArray = iniFiles;
            int n = iniFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File iniFile = fileArray[n2];
                if (!"launcher.ini".equals(iniFile.getName()) && AgentRelaunch.getLauncherPath(iniFile) != null) {
                    return_value = iniFile;
                    break;
                }
                ++n2;
            }
        }
        return return_value;
    }

    private static String getLauncherPath(File iniFile) {
        File launcher;
        String return_value = null;
        String path = iniFile.getPath();
        String launcherPath = path.substring(0, path.length() - INI_EXT.length());
        if ("win32".equals(Platform.getOS())) {
            launcherPath = String.valueOf(launcherPath) + ".exe";
        }
        if ((launcher = new File(launcherPath)).isFile()) {
            return_value = launcher.getPath();
        }
        return return_value;
    }

    private String getLauncherIniArguments(File agentDir, String suggestedIni) {
        File pluginsDir = new File(agentDir, "plugins");
        File configIni = new File(agentDir, "configuration/config.ini");
        return this.getLauncherIniArguments(agentDir, suggestedIni, pluginsDir, configIni);
    }

    public String getLauncherIniArguments(File agentDir, String suggestedIni, File pluginsDir, File configIni) {
        String ws;
        String arch;
        ArrayList<String> programArgs;
        ArrayList<String> vmArgs;
        String newVm;
        File iniFile;
        block30: {
            iniFile = AgentRelaunch.getLauncherIniFile(agentDir, suggestedIni);
            if (iniFile == null) {
                log.error("getLauncherIniArguments(): launcher .ini file not found");
                return null;
            }
            newVm = null;
            vmArgs = new ArrayList<String>();
            programArgs = new ArrayList<String>();
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = CicCommonSettings.isZOS() ? new BufferedReader(Encodings.EBCDIC.reader(iniFile)) : new BufferedReader(Encodings.DEFAULT.reader(iniFile));
                    boolean readingVmArgs = false;
                    while ((line = reader.readLine()) != null) {
                        if (line.length() == 0) continue;
                        if (line.equals("-vm")) {
                            newVm = reader.readLine();
                            if (newVm != null) continue;
                            break;
                        }
                        if (line.equals("-vmargs")) {
                            readingVmArgs = true;
                            continue;
                        }
                        if (readingVmArgs) {
                            vmArgs.add(line);
                            continue;
                        }
                        programArgs.add(line);
                    }
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            log.error((Throwable)e2);
                        }
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        log.error((Throwable)e);
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
        if (newVm == null) {
            log.error("getLauncherIniArguments(): cannot find -vm argument in launcher .ini file");
            return null;
        }
        if (!this.isVmInLauncher() && this.isLibraryVM(newVm) && (newVm = this.findJavaExe(agentDir, newVm)) == null) {
            return null;
        }
        String launcher = this.getLauncher(iniFile);
        if (launcher == null) {
            return null;
        }
        String launcherStartupPluginId = "org.eclipse.equinox.launcher";
        String launcherStartupPluginLocation = this.getLauncherPluginLocation(pluginsDir, launcherStartupPluginId);
        if (launcherStartupPluginLocation == null) {
            return null;
        }
        try {
            Properties properties = FileUtil.readProperties((File)configIni);
            arch = properties.getProperty("osgi.arch", Platform.getOSArch());
            ws = properties.getProperty("osgi.ws", Platform.getWS());
        }
        catch (IOException e) {
            log.error((Throwable)e);
            return null;
        }
        String launcherLibraryPluginLocation = null;
        if ("macosx".equals(Platform.getOS())) {
            launcherLibraryPluginLocation = this.getMacosxLauncherLibrary(pluginsDir);
        } else {
            String launcherLibraryPluginId = String.valueOf(launcherStartupPluginId) + '.' + ws + '.' + Platform.getOS() + '.' + arch;
            launcherLibraryPluginLocation = this.getLauncherPluginLocation(pluginsDir, launcherLibraryPluginId);
        }
        if (launcherLibraryPluginLocation == null) {
            return null;
        }
        if (!this.isVmInLauncher()) {
            vmArgs.add("-jar");
            vmArgs.add(launcherStartupPluginLocation);
        }
        if (!this.isVmInLauncher()) {
            programArgs.add("-launcher");
            programArgs.add(launcher);
        }
        programArgs.add("--launcher.library");
        programArgs.add(launcherLibraryPluginLocation);
        programArgs.add("-startup");
        programArgs.add(launcherStartupPluginLocation);
        return this.setDefaultRelaunchArguments(launcher, newVm, vmArgs.toArray(new String[vmArgs.size()]), programArgs.toArray(new String[programArgs.size()]), ws, arch);
    }

    private Object setRelaunchProperties() {
        String relaunchVmArg;
        int n;
        String[] stringArray;
        int startIndex;
        StringBuffer commandLine = new StringBuffer();
        String currVm = System.getProperty(PROP_VM);
        if (currVm != null && this.isLibraryVM(currVm)) {
            commandLine.append(currVm).append('\n');
            String currVmargs = System.getProperty(PROP_VMARGS);
            if (currVmargs != null) {
                commandLine.append(currVmargs);
                if (!currVmargs.endsWith("\n")) {
                    commandLine.append('\n');
                }
            }
            startIndex = commandLine.length();
        } else {
            commandLine.append(this.relaunchVm).append('\n');
            stringArray = this.relaunchVmArgs;
            n = this.relaunchVmArgs.length;
            int n2 = 0;
            while (n2 < n) {
                relaunchVmArg = stringArray[n2];
                commandLine.append(relaunchVmArg).append('\n');
                ++n2;
            }
            startIndex = commandLine.length();
            if (this.relaunchOfAgent) {
                String currCommands = System.getProperty(PROP_COMMANDS);
                String showSplashArg = "-showsplash";
                if (currCommands != null && currCommands.indexOf(showSplashArg) >= 0) {
                    commandLine.append(showSplashArg).append('\n');
                }
                if ("macosx".equals(Platform.getOS()) && commandLine.indexOf("--launcher.runJvmOutOfProc") < 0 && this.relaunchTemporaryInstaller != null) {
                    commandLine.append("--launcher.runJvmOutOfProc").append('\n');
                }
            }
        }
        if (this.relaunchOfAgent) {
            String password;
            String keyring;
            String arch;
            String os;
            String ws;
            String nl;
            if (this.relaunchLauncher == null) {
                String exitData = this.getExitDataArgument();
                if (exitData == null) {
                    if (!this.isVmInLauncher()) {
                        log.warning("unable to find \"{0}\" argument in \"{1}\" property", new Object[]{EXIT_DATA_ARG, PROP_COMMANDS});
                    }
                } else {
                    commandLine.append(EXIT_DATA_ARG).append('\n');
                    commandLine.append(exitData).append('\n');
                }
            }
            if ((nl = this.getNlArgument()) != null) {
                commandLine.append(NL_ARG).append('\n');
                commandLine.append(nl).append('\n');
            }
            String string = ws = this.relaunchWs != null ? this.relaunchWs : this.getWsArgument();
            if (ws != null) {
                commandLine.append(WS_ARG).append('\n');
                commandLine.append(ws).append('\n');
            }
            if ((os = this.getOsArgument()) != null) {
                commandLine.append(OS_ARG).append('\n');
                commandLine.append(os).append('\n');
            }
            String string2 = arch = this.relaunchArch != null ? this.relaunchArch : this.getArchArgument();
            if (arch != null) {
                commandLine.append(ARCH_ARG).append('\n');
                commandLine.append(arch).append('\n');
            }
            if ((keyring = this.getKeyringArgument()) != null) {
                commandLine.append(KEYRING_ARG).append('\n');
                commandLine.append(keyring).append('\n');
            }
            if ((password = this.getPasswordArgument()) != null) {
                commandLine.append(PASSWORD_ARG).append('\n');
                commandLine.append(password).append('\n');
            }
        }
        stringArray = this.relaunchProgramArgs;
        n = this.relaunchProgramArgs.length;
        int n3 = 0;
        while (n3 < n) {
            String relaunchProgramArg = stringArray[n3];
            commandLine.append(relaunchProgramArg).append('\n');
            ++n3;
        }
        if (this.isSilentInstall(this.relaunchApplicationArgs)) {
            commandLine.append("-nosplash").append('\n');
        }
        this.adjustInputFileArgument();
        this.filterReinstallImArgument();
        stringArray = this.relaunchApplicationArgs;
        n = this.relaunchApplicationArgs.length;
        n3 = 0;
        while (n3 < n) {
            String relaunchApplicationArg = stringArray[n3];
            commandLine.append(relaunchApplicationArg).append('\n');
            ++n3;
        }
        if (this.relaunchOfAgent) {
            if (this.relaunchTemporaryInstaller != null && Agent.getInstance().dataLocationPromptRequired()) {
                commandLine.append("-dataLocation").append('\n');
                commandLine.append(CicCommonSettings.getApplicationDataLocation()).append('\n');
            }
            commandLine.append("-vm\n");
            commandLine.append(this.relaunchVm).append('\n');
            if (this.relaunchVmArgs.length != 0) {
                commandLine.append("-vmargs\n");
                stringArray = this.relaunchVmArgs;
                n = this.relaunchVmArgs.length;
                n3 = 0;
                while (n3 < n) {
                    relaunchVmArg = stringArray[n3];
                    commandLine.append(relaunchVmArg).append('\n');
                    ++n3;
                }
            }
        }
        commandLine.setLength(commandLine.length() - 1);
        log.debug(commandLine.toString());
        if (this.relaunchLauncher != null) {
            String[] launcherArgs = startIndex > commandLine.length() ? new String[]{} : commandLine.substring(startIndex).split("\n", -1);
            return this.launchLauncher(this.relaunchLauncher, launcherArgs);
        }
        System.setProperty(PROP_EXIT_CODE, IApplication.EXIT_RELAUNCH.toString());
        System.setProperty("eclipse.exitdata", commandLine.toString());
        return IApplication.EXIT_RELAUNCH;
    }

    private Object launchLauncher(String launcher, String[] launcherArgs) {
        final String[] cmdarray = new String[launcherArgs.length + 1];
        cmdarray[0] = launcher;
        System.arraycopy(launcherArgs, 0, cmdarray, 1, launcherArgs.length);
        final File workingDirectory = new File(System.getProperty("java.io.tmpdir"));
        if (CmdLine.CL.isConsoleMode()) {
            return this.createRestartScript(workingDirectory, cmdarray);
        }
        if (CmdLine.CL.isServerMode()) {
            EclipseUtil.shutdownFramework();
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    if (CmdLine.CL.isServerMode()) {
                        Thread.sleep(5000L);
                        if (AgentRelaunch.this.isAgentPostUpdateInProgress()) {
                            AgentRelaunch.this.killRunawayThreadWithUiExtensionTracker();
                            Thread.sleep(1000L);
                        }
                    }
                    ProcessBuilder pb = new ProcessBuilder(Arrays.asList(cmdarray));
                    pb.directory(workingDirectory);
                    pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                    pb.redirectError(ProcessBuilder.Redirect.INHERIT);
                    pb.start();
                }
                catch (Throwable t) {
                    log.error(t);
                }
            }
        }.start();
        return IApplication.EXIT_OK;
    }

    private boolean killRunawayThreadWithUiExtensionTracker() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        int threadCount = group.activeCount();
        if (threadCount > 0) {
            Thread[] threads = new Thread[threadCount];
            group.enumerate(threads);
            Thread[] threadArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement[] stackTrace;
                Thread thread = threadArray[n2];
                StackTraceElement[] stackTraceElementArray = stackTrace = thread.getStackTrace();
                int n3 = stackTrace.length;
                int n4 = 0;
                while (n4 < n3) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[n4];
                    if (stackTraceElement.getClassName().equals(ORG_ECLIPSE_UI_INTERNAL_REGISTRY_UI_EXTENSION_TRACKER)) {
                        thread.interrupt();
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return false;
    }

    private Object createRestartScript(File workingDirectory, String[] cmdarray) {
        String location = CmdLine.CL.getRestartScriptLocation();
        File restartScript = null;
        PrintWriter writer = null;
        boolean isWin32 = "win32".equals(Platform.getOS());
        try {
            try {
                String element;
                if (location == null) {
                    File tmpDir;
                    String suffix;
                    if (isWin32) {
                        suffix = ".bat";
                        tmpDir = null;
                    } else {
                        suffix = ".sh";
                        tmpDir = this.createSecureTempDir("restartIM", isWin32);
                    }
                    restartScript = FileUtil.createTempFile((String)"restartIM", (String)suffix, (File)tmpDir);
                } else {
                    restartScript = new File(location);
                }
                restartScript = restartScript.getCanonicalFile();
                writer = CicCommonSettings.isZOS() ? new PrintWriter(Encodings.EBCDIC.writer(restartScript)) : new PrintWriter(Encodings.DEFAULT.writer(restartScript));
                if (isWin32) {
                    writer.println("@echo off");
                    writer.println("cd /d " + this.win32QuotedArgument(workingDirectory.getCanonicalPath()));
                    String[] stringArray = cmdarray;
                    int n = cmdarray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        element = stringArray[n2];
                        writer.print(String.valueOf(this.win32QuotedArgument(element)) + " ");
                        ++n2;
                    }
                    writer.println();
                } else {
                    writer.println("#!/bin/sh");
                    writer.println("cd " + this.linuxQuotedArgument(workingDirectory.getCanonicalPath()));
                    String[] stringArray = cmdarray;
                    int n = cmdarray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        element = stringArray[n3];
                        writer.print(String.valueOf(this.linuxQuotedArgument(element)) + " ");
                        ++n3;
                    }
                    writer.println();
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                Integer n = 1;
                if (writer != null) {
                    writer.close();
                    if (!isWin32) {
                        FileUtil.chmod((String)"a+rx", (boolean)false, (String[])new String[]{restartScript.getPath()});
                    }
                }
                return n;
            }
        }
        catch (Throwable throwable) {
            if (writer != null) {
                writer.close();
                if (!isWin32) {
                    FileUtil.chmod((String)"a+rx", (boolean)false, (String[])new String[]{restartScript.getPath()});
                }
            }
            throw throwable;
        }
        if (writer != null) {
            writer.close();
            if (!isWin32) {
                FileUtil.chmod((String)"a+rx", (boolean)false, (String[])new String[]{restartScript.getPath()});
            }
        }
        if (location == null) {
            String scriptExt = isWin32 ? ".bat" : ".sh";
            log.warning(Messages.AgentRelaunch_restartScript, new Object[]{restartScript.getPath(), "con-disk-set-inst" + scriptExt});
        }
        return IApplication.EXIT_OK;
    }

    private String win32QuotedArgument(String path) {
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            if (Character.isWhitespace(c) || "&<>[]{}^=;!'+,`~".indexOf(c) >= 0) {
                return String.valueOf('\"') + path + '\"';
            }
            ++i;
        }
        return path;
    }

    private String linuxQuotedArgument(String path) {
        StringBuffer sb = new StringBuffer(path.length());
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            if (Character.isWhitespace(c) || ";&()|^<>".indexOf(c) >= 0) {
                sb.append('\\');
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    private int getInputFileArgumentIndex() {
        CmdCommand cmd = CmdLine.CL.parseCommandFromArray(this.relaunchApplicationArgs, "input");
        if (cmd != null) {
            String arg = cmd.getParamStrVal(0);
            int i = 0;
            while (i < this.relaunchApplicationArgs.length) {
                if (this.relaunchApplicationArgs[i].equals(arg)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private void adjustInputFileArgument() {
        int index = this.getInputFileArgumentIndex();
        if (index < 0) {
            return;
        }
        String inputFile = CmdLine.CL.replacePlatformLocationVar(this.relaunchApplicationArgs[index]);
        String tempInstaller = System.getProperty(CLEANUP_TEMPORARY_INSTALLER);
        if (tempInstaller != null) {
            File copiedInputFileLocation;
            String copiedInputFile;
            File tempInstallerLocation = new File(tempInstaller);
            File inputFileLocation = new File(inputFile);
            if (inputFileLocation.getPath().startsWith(tempInstallerLocation.getPath()) && (copiedInputFile = CmdLine.CL.getResponseFile()) != null && (copiedInputFileLocation = new File(copiedInputFile)).isFile()) {
                inputFile = copiedInputFile;
            }
        }
        File file = new File(inputFile);
        this.relaunchApplicationArgs[index] = inputFile = file.getAbsolutePath();
    }

    private int getReinstallImArgumentIndex() {
        int i = 0;
        while (i < this.relaunchApplicationArgs.length) {
            if ("-reinstallIM".equalsIgnoreCase(this.relaunchApplicationArgs[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void filterReinstallImArgument() {
        if (!this.relaunchOfAgent || this.relaunchTemporaryInstaller != null) {
            return;
        }
        int index = this.getReinstallImArgumentIndex();
        if (index < 0) {
            return;
        }
        String[] newRelaunchApplicationArgs = new String[this.relaunchApplicationArgs.length - 1];
        System.arraycopy(this.relaunchApplicationArgs, 0, newRelaunchApplicationArgs, 0, index);
        System.arraycopy(this.relaunchApplicationArgs, index + 1, newRelaunchApplicationArgs, index, this.relaunchApplicationArgs.length - index - 1);
        this.relaunchApplicationArgs = newRelaunchApplicationArgs;
    }

    @Deprecated
    public void setAgentApp(IAgentApp agentApp) {
        this.agentApp = agentApp;
    }

    private String getWin32SystemFolder() {
        String value;
        block3: {
            try {
                value = VariableSubstitution.getInstance().performVariableSubstitutions("${specialFolder:SYSTEM}", false);
                if (value != null && value.charAt(0) != '$') break block3;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return value;
    }

    private boolean isSilentInstall(String[] appArgs) {
        return CmdLine.CL.checkArrayForCommand(appArgs, "-silent");
    }

    private void setRelaunchForCleanup(String[] dirsToDelete, File helper) {
        this.relaunchOfAgent = false;
        this.relaunchLauncher = null;
        this.relaunchVmArgs = new String[0];
        this.relaunchProgramArgs = new String[0];
        this.relaunchWs = null;
        this.relaunchArch = null;
        String[] appArgs = null;
        if ("win32".equals(Platform.getOS())) {
            String cleanupScriptPath;
            String wscriptPath = this.getWin32WScriptPath();
            if (wscriptPath != null && (cleanupScriptPath = this.getWin32CleanupScriptPath()) != null) {
                appArgs = new String[]{"//e:jscript", cleanupScriptPath};
            }
            if (appArgs != null) {
                this.relaunchVm = wscriptPath;
            } else if (helper.isFile()) {
                this.relaunchVm = helper.getPath();
                appArgs = new String[]{};
            } else {
                File cmd;
                this.relaunchVm = "cmd.exe";
                appArgs = new String[]{"/c", "rmdir", "/q", "/s"};
                String systemFolder = this.getWin32SystemFolder();
                if (systemFolder != null && (cmd = new File(systemFolder, "cmd.exe")).isFile()) {
                    this.relaunchVm = cmd.getPath();
                }
            }
        } else {
            String cleanupScriptPath = this.getNonWin32CleanupScriptPath();
            if (cleanupScriptPath != null) {
                this.relaunchVm = cleanupScriptPath;
                appArgs = new String[]{};
            } else {
                this.relaunchVm = "rm";
                appArgs = new String[]{"-r", "-f"};
                File cmd = new File("/bin/rm");
                if (cmd.isFile()) {
                    this.relaunchVm = cmd.getPath();
                }
            }
        }
        ArrayList<String> appArgList = new ArrayList<String>();
        appArgList.addAll(Arrays.asList(appArgs));
        appArgList.addAll(Arrays.asList(dirsToDelete));
        this.relaunchApplicationArgs = appArgList.toArray(new String[appArgList.size()]);
        this.setNeedsRelaunch(true);
    }

    private void unzipCleaner(File installerLocation, File dest) {
        File nativeDir = new File(installerLocation, "native");
        final String uninstallerZipName = String.format("com.ibm.cic.agent.win32%s.uninstaller.helper_", Platform.getOSArch().equals("x86_64") ? ".x86_64" : "");
        File[] files = nativeDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(uninstallerZipName);
            }
        });
        if (files == null || files.length != 1) {
            return;
        }
        boolean sync = true;
        IStatus status = Util.unzipFile((boolean)false, (File)files[0], (File)dest, (boolean)sync);
        if (!status.isOK()) {
            return;
        }
        File helper = new File(dest, "Win32UninstallHelper.exe");
        helper.renameTo(new File(dest, CLEANER_EXE));
    }

    public boolean isTemporaryInstaller() {
        File installerLocation = this.getAgentInstallerLocation();
        if (installerLocation == null) {
            return false;
        }
        File tiFile = new File(installerLocation, TEMPORARY_INSTALLER);
        return tiFile.isFile();
    }

    private void setRelaunchForTemporaryInstallerCleanup() {
        File installerLocation = this.getAgentInstallerLocation();
        String[] dirsToDelete = new String[]{installerLocation.getPath()};
        File helper = new File(installerLocation, CLEANER_EXE);
        this.setRelaunchForCleanup(dirsToDelete, helper);
    }

    private File getAgentInstallerLocation() {
        AgentInstall agentInstall = AgentInstall.getInstance();
        if (!agentInstall.isAgentInstallerRunning()) {
            return null;
        }
        return agentInstall.getInstallerLocation();
    }

    private String[] getEclipseCommands() {
        if (this.eclipseCommands == null) {
            ArrayList<String> commandList = new ArrayList<String>();
            String commands = System.getProperty(PROP_COMMANDS);
            if (commands != null && commands.trim().length() != 0) {
                String[] args;
                String[] stringArray = args = commands.split("\n");
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg2 = stringArray[n2];
                    String arg = arg2.trim();
                    commandList.add(arg);
                    ++n2;
                }
            }
            this.eclipseCommands = commandList.toArray(new String[commandList.size()]);
        }
        return this.eclipseCommands;
    }

    String getArgument(String argName) {
        String[] args = this.getEclipseCommands();
        int i = 0;
        while (i < args.length) {
            int j;
            String arg = args[i];
            if (argName.equals(arg) && (j = i + 1) < args.length) {
                return args[j];
            }
            ++i;
        }
        return null;
    }

    private boolean isLauncherRunningJvmOutOfProc() {
        return this.getArgument("--launcher.runJvmOutOfProc") != null;
    }

    private String getExitDataArgument() {
        return this.getArgument(EXIT_DATA_ARG);
    }

    private String getNlArgument() {
        return this.getArgument(NL_ARG);
    }

    private String getWsArgument() {
        return this.getArgument(WS_ARG);
    }

    private String getOsArgument() {
        return this.getArgument(OS_ARG);
    }

    private String getArchArgument() {
        return this.getArgument(ARCH_ARG);
    }

    private String getKeyringArgument() {
        return this.getArgument(KEYRING_ARG);
    }

    private String getPasswordArgument() {
        return this.getArgument(PASSWORD_ARG);
    }

    private void normalizeInput(File installerLocation, File tempInstallerLocation) throws IOException {
        int index = this.getInputFileArgumentIndex();
        if (index < 0) {
            return;
        }
        String inputArg = CmdLine.CL.replacePlatformLocationVar(this.relaunchApplicationArgs[index]);
        this.relaunchApplicationArgs[index] = this.normalizeInput(installerLocation, tempInstallerLocation, inputArg, null);
        File postInputFile = AgentInstall.getInstance().getPostAgentInstallInputFile(inputArg);
        if (postInputFile.isFile()) {
            File normalizedPostInputFile = AgentInstall.getInstance().getPostAgentInstallInputFile(this.relaunchApplicationArgs[index]);
            this.normalizeInput(installerLocation, tempInstallerLocation, postInputFile.getPath(), normalizedPostInputFile.getPath());
        }
    }

    private String normalizeInput(File installerLocation, File tempInstallerLocation, String inputPath, String normalizedInputPath) throws IOException {
        final String rootPath = installerLocation.getPath();
        final String rootPathWithSep = String.valueOf(rootPath) + File.separatorChar;
        final String tempRootPath = tempInstallerLocation.getPath();
        final String tempRootPathWithSep = String.valueOf(tempRootPath) + File.separatorChar;
        File inputFile = new File(inputPath);
        try {
            inputFile = inputFile.getCanonicalFile();
        }
        catch (IOException e) {
            ExceptionUtil.debugLogToReview((Throwable)e);
        }
        inputPath = inputFile.getPath();
        File normalizedInputFile = normalizedInputPath != null ? new File(normalizedInputPath) : (inputPath.startsWith(rootPathWithSep) ? new File(String.valueOf(tempRootPathWithSep) + inputPath.substring(rootPathWithSep.length())) : FileUtil.createTempFile((String)"install", (String)".xml", (File)tempInstallerLocation));
        Input input = new Input();
        try {
            IStatus status = input.load(inputFile);
            if (status.getSeverity() == 4) {
                log.status(status);
                return inputPath;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return inputPath;
        }
        input.normalizeLocations(new IInput.ILocationNormalizer(){

            @Override
            public String getNormalizedLocation(String location) {
                String canon;
                File file = new File(location);
                try {
                    canon = file.getCanonicalPath();
                }
                catch (IOException e) {
                    canon = file.getPath();
                }
                if (canon.equals(rootPath)) {
                    return tempRootPath;
                }
                if (canon.startsWith(rootPathWithSep)) {
                    return String.valueOf(tempRootPathWithSep) + canon.substring(rootPathWithSep.length());
                }
                if (!file.exists()) {
                    return location;
                }
                return canon;
            }
        });
        input.save(normalizedInputFile);
        return normalizedInputFile.getCanonicalPath();
    }

    private void deleteImInstallerState() {
        File ibmDir = new File(System.getProperty("user.home"), "IBM");
        if (!ibmDir.isDirectory()) {
            return;
        }
        File imInstallerDir = new File(ibmDir, "InstallationManagerInstaller");
        if (imInstallerDir.isDirectory()) {
            FileUtil.rm_r((File)imInstallerDir, (boolean)true);
            if (!PlatformUtils.isSymlink((File)ibmDir)) {
                ibmDir.delete();
            }
        }
    }

    private String getWin32ClsidFromProgId(String progId) {
        String clsid;
        block3: {
            try {
                clsid = VariableSubstitution.getInstance().performVariableSubstitutions("${registry:HKCR\\" + progId + "\\CLSID\\}", false);
                if (clsid != null && clsid.charAt(0) != '$') break block3;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return clsid;
    }

    private String getWin32WScriptPath() {
        String systemFolder = this.getWin32SystemFolder();
        if (systemFolder == null) {
            return null;
        }
        File wscript = new File(systemFolder, "wscript.exe");
        if (!wscript.isFile()) {
            return null;
        }
        String clsid = this.getWin32ClsidFromProgId("WScript.Shell");
        if (clsid == null) {
            return null;
        }
        clsid = this.getWin32ClsidFromProgId("Scripting.FileSystemObject");
        if (clsid == null) {
            return null;
        }
        return wscript.getPath();
    }

    private String getWin32CleanupScriptPath() {
        try {
            File tempScriptPath = FileUtil.createTempFile((String)"cleanup", (String)".js");
            Class<?> cls = this.getClass();
            ClassLoader loader = cls.getClassLoader();
            InputStream input = loader.getResourceAsStream("win32/cleanup.js");
            FileUtil.copyStream((InputStream)input, (File)tempScriptPath, (IProgressMonitor)new NullProgressMonitor());
            return tempScriptPath.getCanonicalPath();
        }
        catch (IOException e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private String getNonWin32CleanupScriptPath() {
        try {
            File tmpDir = this.createSecureTempDir("cleanup", false);
            File tempScriptPath = FileUtil.createTempFile((String)"cleanup", (String)".sh", (File)tmpDir);
            Class<?> cls = this.getClass();
            ClassLoader loader = cls.getClassLoader();
            InputStream input = loader.getResourceAsStream("scripts/cleanup.sh");
            FileUtil.copyStream((InputStream)input, (File)tempScriptPath, (IProgressMonitor)new NullProgressMonitor());
            if (CicCommonSettings.isZOS()) {
                ConvertUtil.convertAndReplaceFileA2E((File)tempScriptPath);
            }
            String pathToScript = tempScriptPath.getCanonicalPath();
            boolean status = FileUtil.chmod((String)"u+x", (boolean)false, (String[])new String[]{pathToScript});
            return status ? pathToScript : null;
        }
        catch (IOException e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private AgentRelaunch() {
    }

    public boolean isAgentPostUpdateInProgress() {
        return this.isAgentPostUpdateInProgress;
    }

    public void setAgentPostUpdateInProgress(boolean value) {
        this.isAgentPostUpdateInProgress = value;
    }

    private static class DefaultAgentApp
    implements IAgentApp {
        private DefaultAgentApp() {
        }

        @Override
        public String[] getApplicationArgs() {
            String[] appargs = Platform.getApplicationArgs();
            ArrayList<String> appargsList = new ArrayList<String>(appargs.length);
            int i = 0;
            while (i < appargs.length) {
                String apparg = appargs[i];
                if (apparg.equalsIgnoreCase("-startup")) {
                    if (++i != appargs.length && appargs[i].charAt(0) != '-') {
                        ++i;
                    }
                } else {
                    appargsList.add(apparg);
                }
                ++i;
            }
            return appargsList.toArray(new String[appargsList.size()]);
        }
    }

    public static interface IAgentApp {
        public String[] getApplicationArgs();
    }
}

