/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.p2;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.IAgentEngine;
import com.ibm.cic.agent.core.IAgentEventManager;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallTransaction;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.p2.P2ArtifactsXmlWriter;
import com.ibm.cic.agent.internal.core.p2.P2EclipseQualificationHistory;
import com.ibm.cic.agent.internal.core.p2.P2EngineOperation;
import com.ibm.cic.agent.internal.core.p2.P2Services;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class P2Engine
implements IAgentEngine,
IAgentEventManager.AgentSessionListener {
    private static final String P2_ENGINE_NAME = "p2";
    private static final AgentJob[] EMPTY_JOBS = new AgentJob[0];
    private static P2Engine instance = new P2Engine();
    private AgentJob[] sessionJobs = EMPTY_JOBS;
    private P2EngineOperation operation = null;
    private P2EclipseQualificationHistory qualificationHistory = null;

    private P2Engine() {
    }

    public static P2Engine getInstance() {
        return instance;
    }

    public AgentJob[] getSessionJobs() {
        return this.sessionJobs;
    }

    public IStatus install(InstallTransaction directorTransaction, InstallableUnitPair[] ius, InstallContext context, IProgressMonitor monitor) {
        this.createOperation(directorTransaction, ius, context, this.getSessionJobs(), false);
        try {
            IStatus iStatus = this.operation.perform(monitor);
            return iStatus;
        }
        finally {
            this.disposeOperation();
        }
    }

    public IStatus uninstall(InstallTransaction directorTransaction, InstallableUnitPair[] ius, InstallContext context, IProgressMonitor monitor) {
        this.createOperation(directorTransaction, ius, context, this.getSessionJobs(), true);
        try {
            IStatus iStatus = this.operation.perform(monitor);
            return iStatus;
        }
        finally {
            boolean finalUninstall = this.operation.isFinalUninstall();
            this.disposeOperation();
            if (finalUninstall) {
                this.cleanupAfterFinalUninstall(context);
            }
        }
    }

    public IStatus getPlanAdditionsAndRemovals(InstallableUnitPair[] ius, InstallContext context, AgentJob[] jobs, Map additions, Map removals, IProgressMonitor monitor) {
        this.createOperation(null, ius, context, jobs, true);
        try {
            IStatus status;
            IStatus iStatus = status = this.operation.getAdditionsAndRemovals(additions, removals, monitor);
            return iStatus;
        }
        finally {
            this.disposeOperation();
        }
    }

    public IStatus start() {
        IAgentEventManager eventManager = Agent.getInstance().getEventManager();
        eventManager.addInstallSessionListener((IAgentEventManager.AgentSessionListener)this);
        eventManager.addUninstallSessionListener((IAgentEventManager.AgentSessionListener)this);
        return Status.OK_STATUS;
    }

    public IStatus stop() {
        IAgentEventManager eventManager = Agent.getInstance().getEventManager();
        eventManager.removeInstallSessionListener((IAgentEventManager.AgentSessionListener)this);
        eventManager.removeUninstallSessionListener((IAgentEventManager.AgentSessionListener)this);
        return Status.OK_STATUS;
    }

    public String getName() {
        return P2_ENGINE_NAME;
    }

    public IStatus beforeInstallSession(IAgentEventManager.AgentSessionEvent event) {
        this.sessionJobs = event.getAgentJobs();
        return Status.OK_STATUS;
    }

    public void afterInstallSession(IAgentEventManager.AgentSessionEvent event) {
        this.cleanupAfterSession();
        this.sessionJobs = EMPTY_JOBS;
    }

    public IStatus beforeUninstallSession(IAgentEventManager.AgentSessionEvent event) {
        this.sessionJobs = event.getAgentJobs();
        return Status.OK_STATUS;
    }

    public void afterUninstallSession(IAgentEventManager.AgentSessionEvent event) {
        this.cleanupAfterSession();
        this.sessionJobs = EMPTY_JOBS;
    }

    public P2EngineOperation getOperation() {
        return this.operation;
    }

    public P2EclipseQualificationHistory getQualificationHistory() {
        return this.qualificationHistory;
    }

    public void setQualificationHistory(P2EclipseQualificationHistory qualificationHistory) {
        this.qualificationHistory = qualificationHistory;
    }

    public void saveQualificationHistory() {
        if (this.qualificationHistory != null) {
            this.qualificationHistory.store();
            this.qualificationHistory = null;
        }
    }

    private void createOperation(InstallTransaction directorTransaction, InstallableUnitPair[] ius, InstallContext context, AgentJob[] jobs, boolean profileMustExist) {
        assert (this.operation == null);
        this.operation = new P2EngineOperation(directorTransaction, ius, context, jobs, profileMustExist);
    }

    private void disposeOperation() {
        this.operation.dispose();
        this.operation = null;
    }

    private void cleanupAfterFinalUninstall(InstallContext context) {
        String installLocation;
        File installDir;
        File p2Dir;
        if (!context.getEnclosingProfile().isExistingEclipseProfile() && (p2Dir = new File(installDir = new File(installLocation = context.getInstallLocation()), P2_ENGINE_NAME)).isDirectory()) {
            FileUtil.rm_r((File)p2Dir, (boolean)true);
        }
    }

    private void cleanupAfterSession() {
        this.setQualificationHistory(null);
        File cicCache = this.getCacheLocation();
        if (cicCache == null) {
            return;
        }
        this.removeP2Index(cicCache);
        Logger.getGlobalLogger().statusNotOK(this.rewriteArtifactsXml(cicCache));
    }

    void removeP2Index(File cicCache) {
        File file = new File(cicCache, "p2.index");
        if (file.isFile()) {
            FileUtil.rm((File)file);
        }
    }

    private IStatus rewriteArtifactsXml(File cicCache) {
        File artifactsXml = new File(cicCache, "artifacts.xml");
        if (!artifactsXml.isFile()) {
            return Status.OK_STATUS;
        }
        P2Services p2Services = null;
        try {
            File dir = new File(CicCommonSettings.getApplicationDataLocation(), P2_ENGINE_NAME);
            p2Services = new P2Services(dir);
            P2ArtifactsXmlWriter writer = new P2ArtifactsXmlWriter(cicCache, p2Services);
            IStatus iStatus = writer.store(true, (IProgressMonitor)new NullProgressMonitor());
            return iStatus;
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            if (p2Services != null) {
                p2Services.dispose();
            }
        }
    }

    private File getCacheLocation() {
        if (this.sessionJobs.length == 0) {
            return null;
        }
        Profile profile = this.sessionJobs[0].getProfile();
        if (profile == null) {
            return null;
        }
        String cacheLocation = profile.getData("cacheLocation");
        if (cacheLocation == null) {
            return null;
        }
        File cicCache = new File(cacheLocation);
        if (!cicCache.isDirectory()) {
            return null;
        }
        return cicCache;
    }
}

