/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.internal.console.ConCommandKeys;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUpdate;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUpdateVersionSelector;
import com.ibm.cic.agent.internal.console.pages.ConPageWizUpdate;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.AConViewContentProvider;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewStatus;
import com.ibm.cic.common.core.console.views.ConViewTreeList;
import com.ibm.cic.common.core.console.views.ConViewTreeListEntry;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.console.views.IConViewContentProvider;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public class ConPageUpdateFix
extends AConPage {
    private ConDataCtxtUpdate m_mainContext;
    private ConDataCtxtUpdateVersionSelector m_contextUVS;
    private ConViewTreeList m_mainList;
    private ConViewList otherOptions;
    private final ConViewStatus m_statusView = new ConViewStatus();
    private boolean m_recommendedFixOnly = true;
    private List<ConDataCtxtUpdateVersionSelector.FixesForInstalledOffering> m_lastSelectedFixContainer = null;
    ConActDisplayRecommendedOnly ConActDisplayRecommendedOnly_INSTANCE = new ConActDisplayRecommendedOnly();

    public ConPageUpdateFix(IConManager controller) {
        super(controller);
    }

    public void init() {
        this.setHeaderView(Messages.PageInstallFix_Header);
        if (this.m_mainContext == null) {
            this.m_mainContext = (ConDataCtxtUpdate)this.conManager().getDataContext(ConDataCtxtUpdate.class);
        }
        if (this.m_contextUVS == null) {
            this.m_contextUVS = (ConDataCtxtUpdateVersionSelector)this.conManager().getDataContext(ConDataCtxtUpdateVersionSelector.class);
        }
        this.m_mainList = new ConViewTreeList(Messages.PageInstallFix_Select, 1, true, true){

            protected ConViewTreeListEntry generateEntry(Object element, String label, AConActionEntry action) {
                return new UpdateFixTreeListEntry(element, label, action);
            }
        };
        this.m_mainList.setContentProvider((IConViewContentProvider)new UpdateFixContentProvider());
        this.addView((IConView)this.m_mainList);
        this.addView((IConView)this.m_statusView);
        if (AgentInput.getInstance().getMode() == 1) {
            this.m_recommendedFixOnly = !this.m_contextUVS.hasSelectedNonRecommendedFix();
        }
        this.otherOptions = new ConViewList(Messages.General_OtherOptions, true){

            public void present(OutputFormatter a_output) {
                this.clearList();
                if (ConPageUpdateFix.this.m_recommendedFixOnly) {
                    this.addEntry(Messages.PageUpdate_Pkg_ShowAll, "S", ConPageUpdateFix.this.ConActDisplayRecommendedOnly_INSTANCE);
                } else {
                    this.addEntry(Messages.PageUpdate_Pkg_ShowRecommended, "S", ConPageUpdateFix.this.ConActDisplayRecommendedOnly_INSTANCE);
                }
                if (!ConPageUpdateFix.this.m_contextUVS.getFixesForSelectedOfferingNUpdate(true).isEmpty()) {
                    this.addEntry(Messages.PageUpdate_Pkg_SelectRecommended, ConCommandKeys.keys_Recommended, (AConActionEntry)new AConActionEntry<ConViewListEntry>(){

                        public void run(IConManager manager) {
                            ConPageUpdateFix.this.m_contextUVS.selectRecommendedFixes();
                        }
                    });
                }
                super.present(a_output);
            }
        };
        this.addView((IConView)this.otherOptions);
        super.init();
    }

    public void present(OutputFormatter a_output) {
        this.m_mainList.refresh();
        this.m_statusView.setStatus(this.m_contextUVS.validateSelectedUpdates(false));
        super.present(a_output);
    }

    public boolean isPageComplete() {
        return !StatusUtil.isErrorOrCancel((IStatus)this.m_statusView.getStatus()) && (this.m_mainContext.getSelectedInstallFixJobs().containsJobs() || this.m_mainContext.getSelectedJobs().containsJobs());
    }

    private boolean sameContainerList(List<ConDataCtxtUpdateVersionSelector.FixesForInstalledOffering> list1, List<ConDataCtxtUpdateVersionSelector.FixesForInstalledOffering> list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 != null && list2 != null) {
            if (list1.size() != list2.size()) {
                return false;
            }
            ArrayList<ConDataCtxtUpdateVersionSelector.FixesForInstalledOffering> copyOfList1 = new ArrayList<ConDataCtxtUpdateVersionSelector.FixesForInstalledOffering>(list1);
            ArrayList<ConDataCtxtUpdateVersionSelector.FixesForInstalledOffering> copyOfList2 = new ArrayList<ConDataCtxtUpdateVersionSelector.FixesForInstalledOffering>(list2);
            copyOfList1.removeAll(list2);
            copyOfList2.removeAll(list1);
            return copyOfList1.isEmpty() && copyOfList2.isEmpty();
        }
        return false;
    }

    public void setVisible(boolean a_visible) {
        if (a_visible) {
            boolean offeringSelectionChanged = this.m_mainContext.getSelectedJobs().isOfferingChanged();
            boolean containerSelectionChanged = false;
            List<ConDataCtxtUpdateVersionSelector.FixesForInstalledOffering> selectedContainers = this.m_contextUVS.getSelectedFixContainer();
            if (!this.sameContainerList(this.m_lastSelectedFixContainer, selectedContainers)) {
                this.m_lastSelectedFixContainer = selectedContainers;
                containerSelectionChanged = true;
            }
            if (offeringSelectionChanged || containerSelectionChanged) {
                this.m_mainContext.getSelectedInstallFixJobs().resetChanged();
                this.m_mainContext.getSelectedInstallFixJobs().clear();
                if (this.m_contextUVS.getFixesForSelectedOfferingNUpdate(true).isEmpty()) {
                    this.m_recommendedFixOnly = false;
                } else {
                    this.m_recommendedFixOnly = true;
                    this.m_contextUVS.selectRecommendedFixes();
                }
                this.m_mainList.refresh();
            }
            ConPageWizUpdate wizard = (ConPageWizUpdate)this.conManager().getWizardPage();
            wizard.checkJobsToleranceForAgent(this.m_mainContext.getAllSelectedJobs());
        }
        super.setVisible(a_visible);
    }

    public boolean skipPage() {
        if (this.m_contextUVS == null) {
            this.m_contextUVS = (ConDataCtxtUpdateVersionSelector)this.conManager().getDataContext(ConDataCtxtUpdateVersionSelector.class);
        }
        if (this.m_contextUVS == null) {
            return true;
        }
        if (this.m_mainContext == null) {
            this.m_mainContext = (ConDataCtxtUpdate)this.conManager().getDataContext(ConDataCtxtUpdate.class);
        }
        if (this.m_mainContext == null) {
            return true;
        }
        Profile profile = this.m_mainContext.getSingleSelectedProfile();
        if (profile == null) {
            return true;
        }
        List<UpdateOfferingJob> updateWithFixes = this.m_contextUVS.getSelectedOfferingJobWithFix(false);
        if (!updateWithFixes.isEmpty()) {
            return false;
        }
        List<ConDataCtxtUpdateVersionSelector.FixesForInstalledOffering> selectedContainer = this.m_contextUVS.getSelectedFixContainer();
        return selectedContainer.isEmpty();
    }

    protected boolean hasNext() {
        return this.isPageComplete();
    }

    class ConActDisplayRecommendedOnly
    extends AConActionEntry<ConViewTreeListEntry> {
        ConActDisplayRecommendedOnly() {
        }

        public void run(IConManager a_conManager) {
            ConPageUpdateFix.this.m_recommendedFixOnly = !ConPageUpdateFix.this.m_recommendedFixOnly;
            if (ConPageUpdateFix.this.m_recommendedFixOnly) {
                ConPageUpdateFix.this.m_contextUVS.unselectNonRecommendedFixJobs();
            }
            ConPageUpdateFix.this.m_mainList.refresh();
            ConPageWizUpdate wizard = (ConPageWizUpdate)a_conManager.getWizardPage();
            wizard.checkJobsToleranceForAgent(ConPageUpdateFix.this.m_mainContext.getAllSelectedJobs());
            super.run(a_conManager);
        }
    }

    class ConActUpdateFixSelect
    extends AConActionEntry<ConViewTreeListEntry> {
        ConActUpdateFixSelect() {
        }

        public void run(IConManager a_conManager) {
            ConViewTreeListEntry entry = (ConViewTreeListEntry)this.getEntry();
            Object element = entry.getElement();
            boolean newJobSelected = false;
            if (element instanceof IOffering || element instanceof UpdateOfferingJob) {
                ConViewTreeListEntry[] children;
                boolean allSelected = entry.isSelected();
                ConViewTreeListEntry[] conViewTreeListEntryArray = children = entry.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ConViewTreeListEntry child = conViewTreeListEntryArray[n2];
                    InstallJob fixJob = (InstallJob)child.getElement();
                    if (allSelected) {
                        if (ConPageUpdateFix.this.m_mainContext.getSelectedInstallFixJobs().contains(fixJob)) {
                            ConPageUpdateFix.this.m_contextUVS.unselectInstallFixJob(fixJob);
                        }
                    } else if (!ConPageUpdateFix.this.m_mainContext.getSelectedInstallFixJobs().contains(fixJob)) {
                        ConPageUpdateFix.this.m_contextUVS.selectFixJob(fixJob, false);
                        newJobSelected = true;
                    }
                    ++n2;
                }
            } else if (element instanceof InstallJob) {
                InstallJob fixJob = (InstallJob)element;
                ConPageUpdateFix.this.m_contextUVS.flipFixJobSelection(fixJob);
                if (ConPageUpdateFix.this.m_mainContext.getSelectedInstallFixJobs().contains(fixJob)) {
                    newJobSelected = true;
                }
            }
            if (newJobSelected) {
                ConPageWizUpdate wizard = (ConPageWizUpdate)a_conManager.getWizardPage();
                wizard.checkJobsToleranceForAgent(ConPageUpdateFix.this.m_mainContext.getAllSelectedJobs());
            }
            super.run(a_conManager);
        }
    }

    class UpdateFixContentProvider
    extends AConViewContentProvider {
        UpdateFixContentProvider() {
        }

        public String getLabel(Object element) {
            InstallJob job;
            IFix fix;
            if (element instanceof IOffering) {
                return NLS.bind((String)Messages.PageInstallFix_FixNode, (Object)UpdateFixContentProvider.getLabelOfferingOrFix((IOfferingOrFix)((IOffering)element)));
            }
            if (element instanceof UpdateOfferingJob) {
                IOffering offering = ((UpdateOfferingJob)element).getOffering();
                return NLS.bind((String)Messages.PageInstallFix_FixNode, (Object)UpdateFixContentProvider.getLabelOfferingOrFix((IOfferingOrFix)offering));
            }
            if (element instanceof InstallJob && (fix = (job = (InstallJob)element).getFix()) != null) {
                return UpdateFixContentProvider.getLabelOfferingOrFix((IOfferingOrFix)fix);
            }
            return super.getLabel(element);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IOffering) {
                IOffering installed = (IOffering)parentElement;
                List<InstallJob> fixes = ConPageUpdateFix.this.m_contextUVS.getAvailableFixJobs(installed, ConPageUpdateFix.this.m_recommendedFixOnly);
                return fixes.toArray();
            }
            if (parentElement instanceof UpdateOfferingJob) {
                UpdateOfferingJob update = (UpdateOfferingJob)parentElement;
                List<InstallJob> fixes = ConPageUpdateFix.this.m_contextUVS.getAvailableFixJobsForUpdate(update, ConPageUpdateFix.this.m_recommendedFixOnly);
                return fixes.toArray();
            }
            return null;
        }

        public Object[] getElements() {
            LinkedList<Object> return_value = new LinkedList<Object>();
            List<ConDataCtxtUpdateVersionSelector.FixesForInstalledOffering> selectedContainers = ConPageUpdateFix.this.m_contextUVS.getSelectedFixContainer();
            for (ConDataCtxtUpdateVersionSelector.FixesForInstalledOffering container : selectedContainers) {
                List<InstallJob> fixes;
                IOffering installed = container.getInstalledOffering();
                List<InstallJob> list = fixes = ConPageUpdateFix.this.m_recommendedFixOnly ? container.getRecommendedFixes() : container.getAllFixes();
                if (fixes.isEmpty()) continue;
                return_value.add(installed);
            }
            List<UpdateOfferingJob> updateWithFixes = ConPageUpdateFix.this.m_contextUVS.getSelectedOfferingJobWithFix(ConPageUpdateFix.this.m_recommendedFixOnly);
            return_value.addAll(updateWithFixes);
            return return_value.toArray();
        }

        public void updateEntry(ConViewTreeListEntry entry) {
            Object element = entry.getElement();
            if (element instanceof IOffering || element instanceof UpdateOfferingJob) {
                ConViewTreeListEntry[] children;
                boolean allChildrenSelected = true;
                ConViewTreeListEntry[] conViewTreeListEntryArray = children = entry.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ConViewTreeListEntry child = conViewTreeListEntryArray[n2];
                    InstallJob childJob = (InstallJob)child.getElement();
                    if (!ConPageUpdateFix.this.m_mainContext.getSelectedInstallFixJobs().contains(childJob)) {
                        allChildrenSelected = false;
                        break;
                    }
                    ++n2;
                }
                if (allChildrenSelected) {
                    entry.setSelected(true);
                } else {
                    entry.setSelected(false);
                }
            } else if (element instanceof InstallJob) {
                InstallJob job = (InstallJob)element;
                if (ConPageUpdateFix.this.m_mainContext.getSelectedInstallFixJobs().contains(job)) {
                    entry.setSelected(true);
                } else {
                    entry.setSelected(false);
                }
            }
        }

        public AConActionEntry getAction(Object element) {
            if (element instanceof InstallJob || element instanceof IOffering) {
                return new ConActUpdateFixSelect();
            }
            return super.getAction(element);
        }
    }

    static class UpdateFixTreeListEntry
    extends ConViewTreeListEntry {
        public UpdateFixTreeListEntry(Object elem, String a_name, AConActionEntry a_action) {
            super(elem, a_name, a_action);
        }

        public void setSelected(boolean a_selected) {
            if (this.m_selected != a_selected && this.m_parent != null) {
                this.m_parent.setCollapsed(false);
            }
            this.m_selected = a_selected;
        }
    }
}

