/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.internal.console.ConCommandKeys;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtInst;
import com.ibm.cic.agent.internal.console.pages.ConPageWizInstall;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.dialogs.ConStatusMessageDialog;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.AConViewContentProvider;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewStatus;
import com.ibm.cic.common.core.console.views.ConViewTreeList;
import com.ibm.cic.common.core.console.views.ConViewTreeListEntry;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.console.views.IConViewContentProvider;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public class ConPageInstFix
extends AConPage {
    private ConDataCtxtInst m_context;
    private ConViewTreeList m_mainList;
    private ConViewList otherOptions;
    private final ConViewStatus m_statusView = new ConViewStatus();
    private boolean m_recommendedFixOnly = true;
    ConActDisplayRecommendedOnly ConActDisplayRecommendedOnly_INSTANCE = new ConActDisplayRecommendedOnly();

    public ConPageInstFix(IConManager controller) {
        super(controller);
    }

    public void init() {
        this.setHeaderView(Messages.PageInstallFix_Header);
        if (this.m_context == null) {
            this.m_context = (ConDataCtxtInst)this.conManager().getDataContext(ConDataCtxtInst.class);
        }
        this.m_mainList = new ConViewTreeList(Messages.PageInstallFix_Select, 1, true, true){

            protected ConViewTreeListEntry generateEntry(Object element, String label, AConActionEntry action) {
                return new InstallFixTreeListEntry(element, label, action);
            }
        };
        this.m_mainList.setContentProvider((IConViewContentProvider)new InstallFixContentProvider());
        this.addView((IConView)this.m_mainList);
        this.addView((IConView)this.m_statusView);
        if (AgentInput.getInstance().getMode() == 1) {
            this.m_recommendedFixOnly = !this.m_context.hasSelectedNonRecommendedFix();
        }
        this.otherOptions = new ConViewList(Messages.General_OtherOptions, true){

            public void present(OutputFormatter a_output) {
                this.clearList();
                if (ConPageInstFix.this.m_recommendedFixOnly) {
                    this.addEntry(Messages.PageUpdate_Pkg_ShowAll, "S", ConPageInstFix.this.ConActDisplayRecommendedOnly_INSTANCE);
                } else {
                    this.addEntry(Messages.PageUpdate_Pkg_ShowRecommended, "S", ConPageInstFix.this.ConActDisplayRecommendedOnly_INSTANCE);
                }
                if (ConPageInstFix.this.m_context.hasRecommendedFixes()) {
                    this.addEntry(Messages.PageUpdate_Pkg_SelectRecommended, ConCommandKeys.keys_Recommended, (AConActionEntry)new AConActionEntry<ConViewListEntry>(){

                        public void run(IConManager manager) {
                            ConPageInstFix.this.m_context.selectRecommendedFixes();
                        }
                    });
                }
                ConPageInstFix.this.otherOptions.addEntry(Messages.PageInstallFix_CheckForFix, "O", (AConActionEntry)new ConActionCheckOtherFixes());
                super.present(a_output);
            }
        };
        this.addView((IConView)this.otherOptions);
        super.init();
    }

    public void present(OutputFormatter a_output) {
        this.m_mainList.refresh();
        this.m_statusView.setStatus(this.m_context.getSelectedJobsStatus());
        super.present(a_output);
    }

    public boolean isPageComplete() {
        return !StatusUtil.isErrorOrCancel((IStatus)this.m_statusView.getStatus());
    }

    public void setVisible(boolean a_visible) {
        if (a_visible) {
            boolean offeringSelectionChanged = this.m_context.getSelectedJobs().isOfferingChanged();
            if (offeringSelectionChanged) {
                this.m_context.getSelectedJobs().resetFixChanged();
                this.m_context.getSelectedJobs().getSelectedFixJobs().clear();
                if (!this.m_context.hasRecommendedFixes()) {
                    this.m_recommendedFixOnly = false;
                } else {
                    this.m_recommendedFixOnly = true;
                    this.m_context.selectRecommendedFixes();
                }
                this.m_mainList.refresh();
            }
            ConPageWizInstall wizard = (ConPageWizInstall)this.conManager().getWizardPage();
            wizard.checkJobsToleranceForAgent(this.m_context.getSelectedJobs().toList());
        }
        super.setVisible(a_visible);
    }

    private List<InstallJob> getSelectedOfferingJobWithFix(boolean recommendedOnly) {
        ArrayList<InstallJob> return_result = new ArrayList<InstallJob>();
        List<InstallJob> selectedOfferingJobs = this.m_context.getSelectedJobs().getSelectedOfferingJobs();
        for (InstallJob job : selectedOfferingJobs) {
            List<InstallJob> fJobs = this.m_context.getFixJobs(job, recommendedOnly);
            if (fJobs == null || fJobs.size() <= 0) continue;
            return_result.add(job);
        }
        return return_result;
    }

    public boolean skipPage() {
        this.m_context = (ConDataCtxtInst)this.conManager().getDataContext(ConDataCtxtInst.class);
        if (this.m_context == null) {
            return true;
        }
        return this.getSelectedOfferingJobWithFix(false).isEmpty();
    }

    protected boolean hasNext() {
        return true;
    }

    class ConActDisplayRecommendedOnly
    extends AConActionEntry<ConViewTreeListEntry> {
        ConActDisplayRecommendedOnly() {
        }

        public void run(IConManager a_conManager) {
            ConPageInstFix.this.m_recommendedFixOnly = !ConPageInstFix.this.m_recommendedFixOnly;
            if (ConPageInstFix.this.m_recommendedFixOnly) {
                ConPageInstFix.this.m_context.unselectNonRecommendedFixJobs();
            }
            ConPageInstFix.this.m_mainList.refresh();
            ConPageWizInstall wizard = (ConPageWizInstall)a_conManager.getWizardPage();
            wizard.checkJobsToleranceForAgent(ConPageInstFix.this.m_context.getSelectedJobs().toList());
            super.run(a_conManager);
        }
    }

    class ConActInstallFixSelect
    extends AConActionEntry<ConViewTreeListEntry> {
        ConActInstallFixSelect() {
        }

        public void run(IConManager a_conManager) {
            ConViewTreeListEntry entry = (ConViewTreeListEntry)this.getEntry();
            InstallJob installJob = (InstallJob)entry.getElement();
            IOffering offering = installJob.getOffering();
            boolean newJobSelected = false;
            if (offering == null) {
                boolean selected = ConPageInstFix.this.m_context.getSelectedJobs().contains(installJob);
                if (selected) {
                    ConPageInstFix.this.m_context.removeSelectedJob(installJob);
                } else {
                    ConPageInstFix.this.m_context.addSelectedJob(installJob);
                    newJobSelected = true;
                }
            } else {
                ConViewTreeListEntry[] children;
                boolean allSelected = entry.isSelected();
                ConViewTreeListEntry[] conViewTreeListEntryArray = children = entry.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ConViewTreeListEntry child = conViewTreeListEntryArray[n2];
                    InstallJob fixJob = (InstallJob)child.getElement();
                    if (allSelected) {
                        if (ConPageInstFix.this.m_context.getSelectedJobs().contains(fixJob)) {
                            ConPageInstFix.this.m_context.removeSelectedJob(fixJob);
                        }
                    } else if (!ConPageInstFix.this.m_context.getSelectedJobs().contains(fixJob)) {
                        ConPageInstFix.this.m_context.addSelectedJob(fixJob);
                        newJobSelected = true;
                    }
                    ++n2;
                }
            }
            if (newJobSelected) {
                ConPageWizInstall wizard = (ConPageWizInstall)a_conManager.getWizardPage();
                wizard.checkJobsToleranceForAgent(ConPageInstFix.this.m_context.getSelectedJobs().toList());
            }
            super.run(a_conManager);
        }
    }

    private class ConActionCheckOtherFixes
    extends AConActionEntry<ConViewListEntry> {
        private ConActionCheckOtherFixes() {
        }

        public void run(IConManager a_manager) {
            ConPageWizInstall wizard = (ConPageWizInstall)a_manager.getWizardPage();
            if (wizard.checkForAgentUpdateInWizardModeIfPrefSet()) {
                return;
            }
            IStatus searchStatus = ConPageInstFix.this.m_context.searchServiceRepositories(true);
            ConStatusMessageDialog.open((IConManager)a_manager, (String)com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_updateTitle_new, null, (IStatus)searchStatus, (int)5, (boolean)false);
        }
    }

    class InstallFixContentProvider
    extends AConViewContentProvider {
        InstallFixContentProvider() {
        }

        public String getLabel(Object element) {
            if (element instanceof InstallJob) {
                InstallJob job = (InstallJob)element;
                IOffering offering = job.getOffering();
                if (offering != null) {
                    return NLS.bind((String)Messages.PageInstallFix_FixNode, (Object)InstallFixContentProvider.getLabelOfferingOrFix((IOfferingOrFix)offering));
                }
                return InstallFixContentProvider.getLabelOfferingOrFix((IOfferingOrFix)job.getOfferingOrFix());
            }
            return super.getLabel(element);
        }

        public Object[] getChildren(Object parentElement) {
            InstallJob job;
            IOffering offering;
            if (parentElement instanceof InstallJob && (offering = (job = (InstallJob)parentElement).getOffering()) != null) {
                return ConPageInstFix.this.m_context.getFixJobs(job, ConPageInstFix.this.m_recommendedFixOnly).toArray();
            }
            return null;
        }

        public Object[] getElements() {
            return ConPageInstFix.this.getSelectedOfferingJobWithFix(ConPageInstFix.this.m_recommendedFixOnly).toArray();
        }

        public void updateEntry(ConViewTreeListEntry entry) {
            Object element = entry.getElement();
            if (element instanceof InstallJob) {
                InstallJob job = (InstallJob)element;
                IFix fix = job.getFix();
                if (fix != null) {
                    if (ConPageInstFix.this.m_context.getSelectedJobs().contains(job)) {
                        entry.setSelected(true);
                    } else {
                        entry.setSelected(false);
                    }
                } else {
                    ConViewTreeListEntry[] children;
                    boolean allChildrenSelected = true;
                    ConViewTreeListEntry[] conViewTreeListEntryArray = children = entry.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ConViewTreeListEntry child = conViewTreeListEntryArray[n2];
                        InstallJob childJob = (InstallJob)child.getElement();
                        if (!ConPageInstFix.this.m_context.getSelectedJobs().contains(childJob)) {
                            allChildrenSelected = false;
                            break;
                        }
                        ++n2;
                    }
                    if (allChildrenSelected) {
                        entry.setSelected(true);
                    } else {
                        entry.setSelected(false);
                    }
                }
            }
        }

        public AConActionEntry getAction(Object element) {
            if (element instanceof InstallJob) {
                return new ConActInstallFixSelect();
            }
            return super.getAction(element);
        }
    }

    static class InstallFixTreeListEntry
    extends ConViewTreeListEntry {
        public InstallFixTreeListEntry(Object elem, String a_name, AConActionEntry a_action) {
            super(elem, a_name, a_action);
        }

        public void setSelected(boolean a_selected) {
            if (this.m_selected != a_selected && this.m_parent != null) {
                this.m_parent.setCollapsed(false);
            }
            this.m_selected = a_selected;
        }
    }
}

