/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.CommandRecorder;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.RollbackJob;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.manager.AConDataAgentWizard;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtCustomPanelList;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtCustomPanels;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPreChecks;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtRollBackVersionSelector;
import com.ibm.cic.agent.internal.console.manager.ConManager;
import com.ibm.cic.agent.internal.console.manager.JobListManager;
import com.ibm.cic.agent.internal.console.manager.ProfileListManager;
import com.ibm.cic.common.core.console.manager.IConDataCtxt;
import com.ibm.cic.common.core.console.manager.IConManager;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public class ConDataCtxtRollBack
extends AConDataAgentWizard {
    IConManager m_manager;
    private final Profile[] m_allProfiles;
    private final JobListManager m_selectedJobs = new JobListManager();
    private final ProfileListManager m_selectedProfiles = new ProfileListManager();
    ConDataCtxtRollBackVersionSelector m_contextRollBackVersion = null;
    private ConDataCtxtCustomPanels m_customPanelsContext = null;
    private ConDataCtxtCustomPanelList m_rollbackCustomPanelListCtxt = null;
    private ConDataCtxtPreChecks m_prerequisiteChecksCtxt = null;

    public ConDataCtxtRollBack(IConManager a_manager) {
        this.m_manager = a_manager;
        this.m_allProfiles = Agent.getInstance().getSortedProductProfiles(false);
        if (this.m_allProfiles.length == 1) {
            this.m_selectedProfiles.selectProfile(this.m_allProfiles[0]);
        }
    }

    public <T extends IConDataCtxt> T getAdapter(Class<T> cls) {
        if (cls == ConDataCtxtRollBackVersionSelector.class) {
            if (this.m_contextRollBackVersion != null && this.m_selectedJobs.isChanged()) {
                this.clear();
            }
            if (this.m_contextRollBackVersion == null) {
                this.m_contextRollBackVersion = new ConDataCtxtRollBackVersionSelector(this);
            }
            return (T)((Object)this.m_contextRollBackVersion);
        }
        if (cls == ConDataCtxtPreChecks.class) {
            if (this.m_prerequisiteChecksCtxt == null || this.m_selectedJobs.isChanged()) {
                this.m_prerequisiteChecksCtxt = new ConDataCtxtPreChecks(this.getSelectedJobs().toList());
            }
            return (T)((Object)this.m_prerequisiteChecksCtxt);
        }
        if (cls == ConDataCtxtCustomPanelList.class) {
            if (this.m_rollbackCustomPanelListCtxt != null && this.m_selectedJobs.isChanged()) {
                this.clear();
            }
            if (this.m_rollbackCustomPanelListCtxt == null) {
                this.m_rollbackCustomPanelListCtxt = new ConDataCtxtCustomPanelList(this.getSelectedJobs().toArray());
            }
            return (T)((Object)this.m_rollbackCustomPanelListCtxt);
        }
        if (cls == ConDataCtxtCustomPanels.class) {
            if (this.m_customPanelsContext != null && this.m_selectedJobs.isChanged()) {
                this.clear();
            }
            if (this.m_customPanelsContext == null) {
                this.m_customPanelsContext = new ConDataCtxtCustomPanels(this.getSelectedJobs().toArray());
            }
            return (T)((Object)this.m_customPanelsContext);
        }
        return (T)super.getAdapter(cls);
    }

    public Profile[] getAllProductProfiles() {
        return this.m_allProfiles;
    }

    public ProfileListManager getSelectedProfiles() {
        return this.m_selectedProfiles;
    }

    public Profile getSingleSelectedProfile() {
        if (this.m_selectedProfiles.size() == 1 && this.m_allProfiles.length > 0) {
            return this.m_selectedProfiles.get(0);
        }
        return null;
    }

    private void clear() {
        this.m_rollbackCustomPanelListCtxt = null;
        this.m_customPanelsContext = null;
        this.m_prerequisiteChecksCtxt = null;
        this.m_selectedJobs.resetChanged();
    }

    public void flipProfileSelection(Profile a_profile) {
        if (this.m_selectedProfiles.contains(a_profile)) {
            this.m_selectedProfiles.clear();
        } else {
            this.m_selectedProfiles.clear();
            this.m_selectedProfiles.selectProfile(a_profile);
        }
    }

    public IStatus getFeatureSetCheckStatus() {
        return SharedUIUtils.getFeatureSetCheckStatus(this.getSelectedJobs().toList());
    }

    public CommandRecorder getCommandRecorder() {
        List<RollbackJob> jobs = this.getSelectedJobs().toList();
        for (RollbackJob j : jobs) {
            j.setAcceptLicense(true);
            j.setSelected(true);
        }
        AgentJob[] jobsToRollback = jobs.toArray(new AgentJob[jobs.size()]);
        CommandRecorder commandRecorder = new CommandRecorder();
        commandRecorder.recordJobs(jobsToRollback, true);
        return commandRecorder;
    }

    public IStatus rollbackSelectedPackages() {
        Agent.getInstance().setSkipInstall(CmdLine.CL.containsCommand("-skipInstall"));
        IStatus return_value = ((ConManager)this.m_manager).getConsoleApp().run(this.getCommandRecorder().getRecordedCommand(), CmdLine.CL.getParam1StrVal("-record"));
        return return_value;
    }

    public JobListManager<RollbackJob> getSelectedJobs() {
        return this.m_selectedJobs;
    }
}

