/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.LocationCheckManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUtils;
import com.ibm.cic.common.core.console.manager.AConDataCtxt;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConDataCtxtInstLocation
extends AConDataCtxt {
    private final List<AbstractJob> m_selectedProductJobs;
    private Profile m_newProfile;
    private Profile[] m_recommendedExistingProfiles;
    private Profile[] m_invalidExistingProfiles;
    private Profile m_selectedProfile;
    private Map<Profile, IStatus> m_profileStatusMap;

    public ConDataCtxtInstLocation(List<? extends AbstractJob> selectedJobs) {
        this.m_selectedProductJobs = AgentUtil.getSelectedProductAbstractJobs(selectedJobs);
        this.createNewProfile();
    }

    public Profile getNewProfile() {
        return this.m_newProfile;
    }

    public Profile[] getRecommendedExistingProfiles() {
        if (this.m_recommendedExistingProfiles == null) {
            this.generateExistingProfileList();
        }
        return this.m_recommendedExistingProfiles;
    }

    public Profile[] getInvalidExistingProfiles() {
        if (this.m_invalidExistingProfiles == null) {
            this.generateExistingProfileList();
        }
        return this.m_invalidExistingProfiles;
    }

    private void generateExistingProfileList() {
        Profile[] profiles = Agent.getInstance().getProfiles();
        if (!this.hasProductProfile(profiles)) {
            this.m_recommendedExistingProfiles = new Profile[0];
            this.m_invalidExistingProfiles = new Profile[0];
        }
        this.getRecommendedProfiles();
        ArrayList<Profile> invalidProfiles = new ArrayList<Profile>();
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            if (this.isProductProfile(profile) && this.profileIsNotRecommended(profile)) {
                invalidProfiles.add(profile);
            }
            ++n2;
        }
        this.m_invalidExistingProfiles = invalidProfiles.toArray(new Profile[invalidProfiles.size()]);
    }

    public Profile getDefaultSelectedProfile() {
        if (this.m_recommendedExistingProfiles != null && this.m_recommendedExistingProfiles.length > 0) {
            Profile defaultRecommendedProfile = this.getDefaultExistingProfile();
            if (defaultRecommendedProfile != null) {
                return defaultRecommendedProfile;
            }
            if (this.m_newProfile != null) {
                return this.m_newProfile;
            }
            return this.m_recommendedExistingProfiles[0];
        }
        if (this.m_newProfile != null) {
            return this.m_newProfile;
        }
        if (this.m_invalidExistingProfiles.length > 0) {
            return this.m_invalidExistingProfiles[0];
        }
        return this.m_newProfile;
    }

    public IStatus setInstallLocation(String location) {
        if (this.m_selectedProfile != null && this.m_selectedProfile.isShadow()) {
            String oldLocation = this.m_selectedProfile.getInstallLocation();
            boolean bRevertLocationBack = false;
            CicMultiStatus status = Statuses.ST.createMultiStatus();
            if (!location.equals(oldLocation)) {
                status.add(this.m_selectedProfile.setInstallLocation(location));
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    return status;
                }
                this.m_selectedProfile.setNeedsRequalification();
                bRevertLocationBack = true;
            }
            status.add(this.validateProfileInstallLocation(this.m_selectedProfile));
            if (StatusUtil.isErrorOrCancel((IStatus)status) && bRevertLocationBack) {
                this.m_selectedProfile.setInstallLocation(oldLocation);
            }
            return status;
        }
        return new Status(4, Agent.getBundleId(), Messages.InstalLocationPage_cannotSetLocation);
    }

    public boolean isProfileSelected(Profile profile) {
        return profile == this.m_selectedProfile;
    }

    public Profile getSelectedProfile() {
        return this.m_selectedProfile;
    }

    public IStatus selectProfile(Profile profile) {
        this.m_selectedProfile = profile;
        IStatus status = this.m_profileStatusMap.get(profile);
        if (status == null) {
            status = Status.OK_STATUS;
        }
        if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
            return this.updateJobsProfile(profile);
        }
        this.m_selectedProfile = null;
        return status;
    }

    public IOffering[] getSelectedProductOfferings() {
        return ConDataCtxtUtils.getSelectedProductOfferingArray(this.m_selectedProductJobs);
    }

    private boolean profileIsNotRecommended(Profile profile) {
        if (this.m_recommendedExistingProfiles == null || this.m_recommendedExistingProfiles.length == 0) {
            return true;
        }
        Profile[] profileArray = this.m_recommendedExistingProfiles;
        int n = this.m_recommendedExistingProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile m_recommendedExistingProfile = profileArray[n2];
            if (m_recommendedExistingProfile == profile) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public IStatus updateJobsProfile(Profile profile) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        for (AbstractJob job : this.m_selectedProductJobs) {
            job.setProfile(profile);
        }
        status.add(this.validateProfileInstallLocation(profile));
        return status;
    }

    private IStatus validateProfileInstallLocation(Profile profile) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        int length = Integer.MAX_VALUE;
        status.add(SharedUIUtils.checkBitModeArtifacts(this.m_selectedProductJobs, (Profile)profile));
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        ArrayList<IFix> selectedFixes = new ArrayList<IFix>();
        for (AbstractJob job : this.m_selectedProductJobs) {
            int pathLength;
            IOfferingOrFix oof = job.getOfferingOrFix();
            if (oof instanceof IFix) {
                selectedFixes.add((IFix)oof);
            }
            if ((pathLength = PlatformUtils.getMaxInstallLocationLengthForOffering((IOffering)job.getOffering())) >= length) continue;
            length = pathLength;
        }
        profile.setMaxInstallLocationLength(length);
        if (profile.isShadow()) {
            status.add(AgentUtil.validateJobsInstallLocation(this.m_selectedProductJobs));
        }
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        status.add(AgentUtil.getOfferingsApplicability(this.m_selectedProductJobs));
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        if (selectedFixes.size() > 0) {
            status.add(BitModeUtils.checkFixBitModeSupportedAgainstProfile(selectedFixes, (Profile)profile));
        }
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        status.add(LocationCheckManager.getInstance().initializeAndPerform(AgentJob.toArray(this.m_selectedProductJobs), monitor));
        monitor.done();
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        return status;
    }

    private void getRecommendedProfiles() {
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        try {
            try {
                this.m_profileStatusMap = new LinkedHashMap<Profile, IStatus>();
                this.m_recommendedExistingProfiles = Agent.getInstance().getRecommendedProfiles(ConDataCtxtUtils.getSelectedProductOfferingArray(this.m_selectedProductJobs), this.m_profileStatusMap, monitor);
            }
            catch (CoreException e) {
                this.m_recommendedExistingProfiles = new Profile[0];
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean hasProductProfile(Profile[] profiles) {
        if (profiles == null || profiles.length == 0) {
            return false;
        }
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            if (this.isProductProfile(profile)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isProductProfile(Profile profile) {
        return profile.getProfileKind().equals("product") || profile.getProfileKind().equals("existingEclipse");
    }

    private void createNewProfile() {
        if (this.m_selectedProductJobs.isEmpty()) {
            this.m_newProfile = null;
        }
        this.m_newProfile = AgentUtil.makeNewProfileForOfferings((IOffering[])ConDataCtxtUtils.getSelectedProductOfferingArray(this.m_selectedProductJobs), this.m_selectedProductJobs);
    }

    private Profile getDefaultExistingProfile() {
        IOffering offering;
        String profileId = null;
        for (AbstractJob job : this.m_selectedProductJobs) {
            Profile jobProfile = job.getProfile();
            if (jobProfile == null || jobProfile.isAgentProfile()) continue;
            profileId = jobProfile.getProfileId();
            break;
        }
        if (profileId == null && (offering = this.getOfferingWithShortestPath(ConDataCtxtUtils.getSelectedProductOfferingArray(this.m_selectedProductJobs))) != null) {
            profileId = OfferingProperty.getDefaultProfile((IOfferingOrFix)offering);
        }
        if (profileId != null) {
            Profile[] profileArray = this.m_recommendedExistingProfiles;
            int n = this.m_recommendedExistingProfiles.length;
            int n2 = 0;
            while (n2 < n) {
                Profile m_recommendedExistingProfile = profileArray[n2];
                if (m_recommendedExistingProfile.getProfileId().equals(profileId)) {
                    return m_recommendedExistingProfile;
                }
                ++n2;
            }
        }
        return null;
    }

    private IOffering getOfferingWithShortestPath(IOffering[] offerings) {
        int minLength = Integer.MAX_VALUE;
        IOffering offering = null;
        IOffering[] iOfferingArray = offerings;
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            int pathLength;
            IOffering currentOffering = iOfferingArray[n2];
            if (!Agent.isExtensionOffering((IOfferingOrFix)currentOffering) && !LicenseUtils.isPEKOffering((IOffering)currentOffering) && (pathLength = PlatformUtils.getMaxInstallLocationLengthForOffering((IOffering)currentOffering)) < minLength) {
                minLength = pathLength;
                offering = currentOffering;
            }
            ++n2;
        }
        return offering;
    }
}

