/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.ConCustomPanel;
import com.ibm.cic.agent.core.api.ICustomPanel;
import com.ibm.cic.agent.core.sharedUI.CommonCustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.CustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.CustomPanelJobPair;
import com.ibm.cic.agent.core.sharedUI.ICustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.ITemplateCustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.core.sharedUI.TemplateCommonCustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.TemplateOfferingCustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.core.userdata.parser.CommonUserDataExtParser;
import com.ibm.cic.agent.core.userdata.parser.OfferingUserDataExtParser;
import com.ibm.cic.agent.internal.console.custompanel.ConsoleCustomPanelGenerator;
import com.ibm.cic.common.core.console.manager.AConDataCtxt;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.utils.RuntimeStatusException;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class ConDataCtxtCustomPanelList
extends AConDataCtxt {
    private static final Logger log = Logger.getLogger();
    private final AgentJob[] m_jobs;
    private List<CustomPanelJobPair> m_allConsoleCustomPanels;
    private List<CustomPanelJobPair> m_nonSkippedCustomPanels;
    private boolean m_initializeValidationData = false;

    public ConDataCtxtCustomPanelList(AgentJob[] jobs) {
        this.m_jobs = jobs;
    }

    public Map<Profile, Map<IOffering, List<CustomPanelJobPair>>> getGroupedNonSkippedConsoleCustomPanels() {
        return CustomPanelJobPair.groupCustomPanels(this.m_nonSkippedCustomPanels);
    }

    public List<CustomPanelJobPair> getAllConsoleCustomPanels() {
        return this.m_allConsoleCustomPanels;
    }

    public List<CustomPanelJobPair> getNonSkippedConsoleCustomPanels() {
        return this.m_nonSkippedCustomPanels;
    }

    public boolean shouldSkipCustomPanelListPage(WizardType wizardType) {
        this.getCustomPanelsFromExtensions(wizardType);
        this.generateNonSkippedCustomPanels();
        return this.m_nonSkippedCustomPanels.isEmpty();
    }

    private void generateNonSkippedCustomPanels() {
        Map map = CustomPanelJobPair.groupCustomPanels(this.m_allConsoleCustomPanels);
        this.m_nonSkippedCustomPanels = new ArrayList<CustomPanelJobPair>();
        for (Map offeringPairMap : map.values()) {
            for (List pairs : offeringPairMap.values()) {
                for (CustomPanelJobPair pair : pairs) {
                    try {
                        ICustomPanel panel = pair.getPanel();
                        if (panel.shouldSkip()) continue;
                        this.m_nonSkippedCustomPanels.add(pair);
                    }
                    catch (Exception e) {
                        IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((CustomPanelJobPair)pair, (Throwable)e);
                        Logger.getLogger().status(status);
                    }
                }
            }
        }
    }

    private void initializeValidationBundles() {
        if (!this.m_initializeValidationData) {
            this.m_initializeValidationData = true;
            CommonUserDataExtParser.getInstance().initializeCommonUserDataExtensions(this.m_jobs);
            OfferingUserDataExtParser.getInstance().initializeOfferingUserDataExtensions(this.m_jobs);
        }
    }

    private void getCustomPanelsFromExtensions(WizardType wizardType) {
        this.initializeValidationBundles();
        if (this.m_allConsoleCustomPanels == null) {
            ICustomPanel customPanel;
            CustomPanelJobPair panel;
            int n;
            int n2;
            CustomPanelJobPair[] customPanelJobPairArray;
            ITemplateCustomPanelFactory factory;
            this.m_allConsoleCustomPanels = new ArrayList<CustomPanelJobPair>();
            ITemplateCustomPanelFactory[] iTemplateCustomPanelFactoryArray = new ITemplateCustomPanelFactory[]{TemplateCommonCustomPanelFactory.getInstance(), TemplateOfferingCustomPanelFactory.getInstance()};
            int n3 = iTemplateCustomPanelFactoryArray.length;
            int n4 = 0;
            while (n4 < n3) {
                factory = iTemplateCustomPanelFactoryArray[n4];
                try {
                    customPanelJobPairArray = factory.createCustomPanels(ConCustomPanel.class, ConsoleCustomPanelGenerator.getInstance(), wizardType, this.m_jobs, false);
                    n2 = customPanelJobPairArray.length;
                    n = 0;
                    while (n < n2) {
                        panel = customPanelJobPairArray[n];
                        customPanel = panel.getPanel();
                        customPanel.setInitialData();
                        this.m_allConsoleCustomPanels.add(panel);
                        ++n;
                    }
                }
                catch (RuntimeStatusException e) {
                    log.status(e.getStatus());
                }
                catch (CoreException e) {
                    log.status(e.getStatus());
                }
                ++n4;
            }
            iTemplateCustomPanelFactoryArray = new ICustomPanelFactory[]{CustomPanelFactory.getInstance(), CommonCustomPanelFactory.getInstance()};
            n3 = iTemplateCustomPanelFactoryArray.length;
            n4 = 0;
            while (n4 < n3) {
                factory = iTemplateCustomPanelFactoryArray[n4];
                try {
                    customPanelJobPairArray = factory.createCustomPanels(true, ConCustomPanel.class, wizardType, this.m_jobs, false);
                    n2 = customPanelJobPairArray.length;
                    n = 0;
                    while (n < n2) {
                        panel = customPanelJobPairArray[n];
                        customPanel = panel.getPanel();
                        customPanel.setInitialData();
                        this.m_allConsoleCustomPanels.add(panel);
                        ++n;
                    }
                }
                catch (CoreException e) {
                    log.status(e.getStatus());
                }
                ++n4;
            }
        }
    }
}

