/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentRelaunch;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.sharedUI.SharedUpdateAgentUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.common.core.console.dialogs.ConMessageDialog;
import com.ibm.cic.common.core.console.dialogs.ConStatusMessageDialog;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ConUpdateAgentUtils {
    public static final int USER_CANCEL = -50;
    public static final int AGENT_UPDATE_NOT_REQUIRED = -51;

    public static IStatus checkForNewerVersionAgent(IConManager manager, AbstractJob selectedAgentJob, AbstractJob[] newAgentJob, IProgressMonitor monitor) {
        CicMultiStatus status;
        SubProgressMonitor subMonitor = null;
        CicMultiStatus result = status = Statuses.ST.createMultiStatus(com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingPage_newerIMMsg2, new Object[0]);
        monitor.beginTask(com.ibm.cic.agent.core.sharedUI.Messages.ProgressDialog_Checking_Agent_Update, 2);
        boolean otherServiceRepositoriesLoaded = SharedUpdateAgentUtils.areOtherServiceRepositoriesLoaded();
        try {
            subMonitor = new SubProgressMonitor(monitor, 1);
            HashMap repLocationMsgMap = new HashMap();
            IOffering selectedAgentOffering = selectedAgentJob.getOffering();
            IStatus loadServiceRepStatus = SharedUpdateAgentUtils.loadAgentServiceRepositories((IOffering)selectedAgentOffering, repLocationMsgMap, (IProgressMonitor)subMonitor);
            ConUpdateAgentUtils.reportRepositoryConnectionMsg(manager, loadServiceRepStatus, repLocationMsgMap);
            subMonitor = new SubProgressMonitor(monitor, 1);
            IOffering updateOffering = SharedUpdateAgentUtils.getAgentUpdateOfferingForSelectedAgentOffering((IOffering)selectedAgentOffering, (IProgressMonitor)subMonitor, (CicMultiStatus)status);
            if (updateOffering == null) {
                SharedUpdateAgentUtils.unloadServiceRepositories((boolean)otherServiceRepositoriesLoaded);
                CicMultiStatus cicMultiStatus = Statuses.ST.createMultiStatus(-51, "", new Object[0]);
                return cicMultiStatus;
            }
            newAgentJob[0] = new InstallJob((IOfferingOrFix)updateOffering);
            newAgentJob[0].setProfile(selectedAgentJob.getProfile());
            result = ConUpdateAgentUtils.checkAgentRequirementInteraction(manager, updateOffering, status, false);
            if (!result.isOK()) {
                SharedUpdateAgentUtils.unloadServiceRepositories((boolean)otherServiceRepositoriesLoaded);
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            Agent agent = Agent.getInstance();
            IOffering installedOffering = agent.getAgentOffering();
            if (installedOffering != null) {
                IStatus prepareStatus = agent.prepareAgentUpdate(installedOffering, updateOffering, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (!prepareStatus.isOK()) {
                    SharedUpdateAgentUtils.unloadServiceRepositories((boolean)otherServiceRepositoriesLoaded);
                    IStatus iStatus = prepareStatus;
                    return iStatus;
                }
                IStatus applicabilityStatus = ConUpdateAgentUtils.checkAgentApplicability(manager, newAgentJob[0]);
                if (!applicabilityStatus.isOK()) {
                    SharedUpdateAgentUtils.unloadServiceRepositories((boolean)otherServiceRepositoriesLoaded);
                    IStatus iStatus = applicabilityStatus;
                    return iStatus;
                }
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    public static IStatus checkForAgentUpdateNDisplayServiceRepStatus(IConManager manager, IProgressMonitor monitor) {
        CicMultiStatus ms;
        IOffering offering = null;
        SubProgressMonitor subMonitor = null;
        CicMultiStatus result = ms = Statuses.ST.createMultiStatus(com.ibm.cic.agent.core.sharedUI.Messages.AgentUIAction_agentUpdateAvailable, new Object[0]);
        monitor.beginTask(com.ibm.cic.agent.core.sharedUI.Messages.ProgressDialog_Checking_Agent_Update, 2);
        boolean otherServiceRepositoriesLoaded = SharedUpdateAgentUtils.areOtherServiceRepositoriesLoaded();
        try {
            subMonitor = new SubProgressMonitor(monitor, 1);
            HashMap repLocationMsgMap = new HashMap();
            IStatus loadServiceRepStatus = SharedUpdateAgentUtils.loadAgentServiceRepositories(null, repLocationMsgMap, (IProgressMonitor)subMonitor);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            ConUpdateAgentUtils.reportRepositoryConnectionMsg(manager, loadServiceRepStatus, repLocationMsgMap);
            subMonitor = new SubProgressMonitor(monitor, 1);
            offering = SharedUpdateAgentUtils.getAgentUpdateOffering((IProgressMonitor)subMonitor, (CicMultiStatus)ms);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            result = ConUpdateAgentUtils.updateAgent(manager, offering, ms);
            if (result.matches(8)) {
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
        }
        finally {
            SharedUpdateAgentUtils.unloadServiceRepositories((boolean)otherServiceRepositoriesLoaded);
            monitor.done();
        }
        if (offering != null && !monitor.isCanceled()) {
            ConUpdateAgentUtils.performPostAgentUpdate(manager, (IStatus)result, offering);
        }
        return result;
    }

    public static IStatus updateAgent(IConManager manager, IOffering offering, CicMultiStatus status) {
        if (offering == null) {
            return Statuses.ST.createMultiStatus(-51, "", new Object[0]);
        }
        IStatus result = ConUpdateAgentUtils.checkAgentRequirementInteraction(manager, offering, status);
        if (!result.isOK()) {
            return result;
        }
        Agent agent = Agent.getInstance();
        UpdateOfferingJob job = agent.createAgentUpdateOfferingJob(offering);
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        try {
            monitor.beginTask(com.ibm.cic.agent.core.sharedUI.Messages.ProgressDialog_Checking_Agent_Applicability, 1);
            IStatus prepareStatus = agent.prepareAgentUpdate(job, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!prepareStatus.isOK()) {
                IStatus iStatus = prepareStatus;
                return iStatus;
            }
        }
        finally {
            monitor.done();
        }
        IStatus applicabilityStatus = ConUpdateAgentUtils.checkAgentApplicability(manager, (AbstractJob)job);
        if (!applicabilityStatus.isOK()) {
            return applicabilityStatus;
        }
        monitor = ConsoleProgressMonitor.createMonitor();
        try {
            monitor.beginTask(com.ibm.cic.agent.core.sharedUI.Messages.ProgressDialog_Updating_Agent, 1);
            IStatus iStatus = agent.updateAgent(job, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public static void performPostAgentUpdate(IConManager manager, IStatus status, IOffering offering) {
        if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
            if (status.matches(2)) {
                ConStatusMessageDialog.open((ConMessageDialog.Kind)ConMessageDialog.Kind.WARNING, (IConManager)manager, (String)com.ibm.cic.agent.core.sharedUI.Messages.UpdateAgent_Problems_Title, null, (IStatus)status, (int)3, (boolean)true);
            }
            String title = com.ibm.cic.agent.core.sharedUI.Messages.WorkbenchRestartDlg_Title;
            String msg = NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.WorkbenchRestartDlg_Msg, (Object)offering.getInformation().getVersion());
            ConMessageDialog.openInformation((IConManager)manager, (String)title, (String)msg);
            AgentRelaunch.getInstance().setNeedsRelaunch(true);
        } else if (!status.matches(8)) {
            ConStatusMessageDialog.openError((IConManager)manager, (String)com.ibm.cic.agent.core.sharedUI.Messages.UpdateAgent_Problems_Title, null, (IStatus)status, (int)7, (boolean)true);
        }
    }

    private static IStatus checkAgentRequirementInteraction(IConManager manager, IOffering offering, CicMultiStatus status) {
        return ConUpdateAgentUtils.checkAgentRequirementInteraction(manager, offering, status, true);
    }

    private static IStatus checkAgentRequirementInteraction(IConManager manager, IOffering offering, CicMultiStatus status, boolean openQuestion) {
        boolean positiveResponse = openQuestion ? ConStatusMessageDialog.openQuestion((IConManager)manager, (String)Messages.ConUpdateAgentUtils_updateInstallationManager, null, (IStatus)status, (int)2) : ConStatusMessageDialog.openConfirm((IConManager)manager, (String)Messages.ConUpdateAgentUtils_updateInstallationManager, null, (IStatus)status, (int)2);
        if (!positiveResponse) {
            CicMultiStatus result = Statuses.ST.createMultiStatusWithChild(Status.CANCEL_STATUS, null, new Object[0]);
            result.setCode(-50);
            return result;
        }
        IStatus agentRequirementStatus = Agent.getInstance().checkAgentRequirement((IOfferingOrFix)offering, CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key()));
        if (!agentRequirementStatus.isOK()) {
            CicMultiStatus displayStatus = Statuses.ST.createMultiStatus(agentRequirementStatus.getPlugin(), agentRequirementStatus.getSeverity(), agentRequirementStatus.getCode(), null, null, agentRequirementStatus.getMessage());
            displayStatus.add((IStatus)new Status(4, Agent.PI_AGENT, 0, com.ibm.cic.agent.core.sharedUI.Messages.AgentUIAction_agentUpdateNotPossible, null));
            ConStatusMessageDialog.openError((IConManager)manager, (String)Messages.ConUpdateAgentUtils_updateInstallationManager, null, (IStatus)displayStatus, (int)4);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private static void reportRepositoryConnectionMsg(IConManager manager, IStatus connectionStatus, Map repLocationMsgMap) {
        String repStatusMsg = CommonSharedUIUtils.constructRepositoryMessages((Map)repLocationMsgMap, (boolean)true);
        if (repStatusMsg.length() > 0) {
            if (!connectionStatus.isOK()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(com.ibm.cic.common.core.sharedUI.Messages.TestConnectionResultDlg_notConnected);
                buffer.append("\n\n");
                buffer.append(connectionStatus.getMessage());
                buffer.append("\n\n");
                buffer.append(repStatusMsg);
                ConMessageDialog.openError((IConManager)manager, (String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_RepInfo, (String)buffer.toString());
            } else if (CommonSharedUIUtils.repositoryMessageContainWarning((Map)repLocationMsgMap)) {
                ConMessageDialog.openWarning((IConManager)manager, (String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_RepWarning, (String)repStatusMsg);
            } else {
                ConMessageDialog.openInformation((IConManager)manager, (String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_RepInfo, (String)repStatusMsg);
            }
        }
    }

    private static IStatus checkAgentApplicability(IConManager manager, AbstractJob job) {
        IStatus status = job.checkOfferingApplicability();
        if (!status.isOK()) {
            if (status.matches(8)) {
                CicMultiStatus result = Statuses.ST.createMultiStatusWithChild(Status.CANCEL_STATUS, null, new Object[0]);
                result.setCode(-50);
                return result;
            }
            if (status.matches(4)) {
                ConStatusMessageDialog.openError((IConManager)manager, (String)Messages.ConUpdateAgentUtils_updateInstallationManager, null, (IStatus)status);
                return Status.CANCEL_STATUS;
            }
            boolean positiveResponse = ConStatusMessageDialog.openConfirm((IConManager)manager, (String)Messages.ConUpdateAgentUtils_updateInstallationManager, null, (IStatus)status, (int)3);
            if (!positiveResponse) {
                CicMultiStatus result = Statuses.ST.createMultiStatusWithChild(Status.CANCEL_STATUS, null, new Object[0]);
                result.setCode(-50);
                return result;
            }
        }
        return Status.OK_STATUS;
    }
}

