/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.nio.fs.PollingWatchService;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixFileSystemProvider;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.ZosFileStore;
import sun.nio.fs.ZosNativeDispatcher;

class ZosFileSystem
extends UnixFileSystem {
    ZosFileSystem(UnixFileSystemProvider unixFileSystemProvider, String string) {
        super(unixFileSystemProvider, string);
    }

    @Override
    Iterable<UnixMountEntry> getMountEntries() {
        HashSet<UnixMountEntry> hashSet = new HashSet<UnixMountEntry>();
        ZosNativeDispatcher.getMountEntries0(hashSet);
        return hashSet;
    }

    @Override
    FileStore getFileStore(UnixMountEntry unixMountEntry) throws IOException {
        return new ZosFileStore(this, unixMountEntry);
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return new PollingWatchService();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(ZosFileSystem.standardFileAttributeViews());
        return Collections.unmodifiableSet(hashSet);
    }
}

