/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SimpleSoundbank;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Objects;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.spi.SoundbankReader;
import sun.reflect.misc.ReflectUtil;

public final class JARSoundbankReader
extends SoundbankReader {
    private static final String JAR_SOUNDBANK_ENABLED = "jdk.sound.jarsoundbank";

    private static boolean isZIP(URL uRL) {
        boolean bl = false;
        try (InputStream inputStream = uRL.openStream();){
            byte[] byArray = new byte[4];
            boolean bl2 = bl = inputStream.read(byArray) == 4;
            if (bl) {
                bl = byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Soundbank getSoundbank(URL uRL) throws InvalidMidiDataException, IOException {
        Objects.requireNonNull(uRL);
        if (!Boolean.getBoolean(JAR_SOUNDBANK_ENABLED) || !JARSoundbankReader.isZIP(uRL)) {
            return null;
        }
        ArrayList<Soundbank> arrayList = new ArrayList<Soundbank>();
        URLClassLoader uRLClassLoader = URLClassLoader.newInstance(new URL[]{uRL});
        InputStream inputStream = uRLClassLoader.getResourceAsStream("META-INF/services/javax.sound.midi.Soundbank");
        if (inputStream == null) {
            return null;
        }
        Object object = new BufferedReader(new InputStreamReader(inputStream));
        Object object2 = null;
        try {
            void throwable;
            String object3 = ((BufferedReader)object).readLine();
            while (throwable != null) {
                if (!throwable.startsWith("#")) {
                    try {
                        Class<?> clazz = Class.forName(throwable.trim(), false, uRLClassLoader);
                        if (Soundbank.class.isAssignableFrom(clazz)) {
                            Object object4 = ReflectUtil.newInstance(clazz);
                            arrayList.add((Soundbank)object4);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                String throwable2 = ((BufferedReader)object).readLine();
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((BufferedReader)object).close();
                }
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (Soundbank)arrayList.get(0);
        }
        object = new SimpleSoundbank();
        for (Soundbank soundbank : arrayList) {
            ((SimpleSoundbank)object).addAllInstruments(soundbank);
        }
        return object;
    }

    @Override
    public Soundbank getSoundbank(InputStream inputStream) throws InvalidMidiDataException, IOException {
        return null;
    }

    @Override
    public Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        Objects.requireNonNull(file);
        return this.getSoundbank(file.toURI().toURL());
    }
}

