/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.io.PKCS7Parser;
import com.ibm.gsk.ikeyman.keystore.EntryContainerFactory$1;
import com.ibm.gsk.ikeyman.keystore.EntryContainerFactory$EntryContainer;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.util.FileName;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
class EntryContainerFactory$PKCS7EntryFile
implements EntryContainerFactory$EntryContainer {
    private FileName fileName;
    private Collection entries = new ArrayList();

    private EntryContainerFactory$PKCS7EntryFile(FileName fileName) throws KeyManagerException {
        this.fileName = fileName;
        this.populateEntries();
    }

    private void populateEntries() throws KeyManagerException {
        try {
            Certificate[] certificateArray;
            for (Certificate certificate : certificateArray = PKCS7Parser.getCertificates(this.fileName.toString())) {
                X509Certificate x509Certificate = (X509Certificate)certificate;
                this.entries.add(EntryFactory.newCertificateItem(x509Certificate.getSubjectX500Principal().toString(), x509Certificate));
            }
        }
        catch (Exception exception) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.PKCS7_PARSING_ERROR, exception, new String[]{exception.getMessage()});
        }
    }

    public int compare(Entry entry, Entry entry2) {
        return entry.compareTo(entry2);
    }

    public boolean contains(String string) {
        try {
            this.getItem(string);
            return true;
        }
        catch (KeyManagerException keyManagerException) {
            return false;
        }
    }

    public Collection getAliases() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CertificateItem certificateItem : this.entries) {
            arrayList.add(certificateItem.getLabel());
        }
        return arrayList;
    }

    public CertificateItem getItem(String string) throws KeyManagerException {
        for (CertificateItem certificateItem : this.entries) {
            if (!certificateItem.getLabel().equals(string)) continue;
            return certificateItem;
        }
        throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_ENTRY_FOR_LABEL, new String[]{string});
    }

    public Collection getItems() throws KeyManagerException {
        return this.entries;
    }

    public boolean needsRefresh() {
        return true;
    }

    public Entry getItem(String string) throws KeyManagerException {
        return this.getItem(string);
    }

    public int compare(Object object, Object object2) {
        return this.compare((Entry)object, (Entry)object2);
    }

    EntryContainerFactory$PKCS7EntryFile(FileName fileName, EntryContainerFactory$1 entryContainerFactory$1) throws KeyManagerException {
        this(fileName);
    }
}

