/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.wlm;

import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.wlm.ResourceContention;
import java.io.UnsupportedEncodingException;

public class QueryContentionResult {
    private ResourceContention[] resourceContentions = null;
    private int numContentions = 0;
    private boolean moreContentions = false;

    QueryContentionResult(int numContentions, boolean moreContentions, byte[] ciBytes) {
        this.numContentions = numContentions;
        this.moreContentions = moreContentions;
        this.resourceContentions = new ResourceContention[numContentions];
        if (numContentions > 0) {
            this.buildContentionList(ciBytes, numContentions);
        }
    }

    public ResourceContention[] getResourceContentions() {
        return this.resourceContentions;
    }

    public int getNumberOfContentions() {
        return this.numContentions;
    }

    public boolean hasMoreContentions() {
        return this.moreContentions;
    }

    private void buildContentionList(byte[] ciBytes, int numEntries) {
        int subsysTypeLen = 4;
        int subsysNameLen = 8;
        int startTimeLen = 8;
        int contIdLen = 4;
        int countLen = 4;
        int reservedLen = 4;
        int offset = 0;
        try {
            for (int i = 0; i < numEntries; ++i) {
                String subsysType = new String(ciBytes, offset, subsysTypeLen, "IBM-1047");
                String subsysName = new String(ciBytes, offset += subsysTypeLen, subsysNameLen, "IBM-1047");
                byte[] startTime = new byte[startTimeLen];
                System.arraycopy(ciBytes, offset += subsysNameLen, startTime, 0, startTimeLen);
                byte[] contIdBytes = new byte[contIdLen];
                System.arraycopy(ciBytes, offset += startTimeLen, contIdBytes, 0, contIdLen);
                int contId = ByteUtil.bytesAsInt(contIdBytes);
                byte[] countBytes = new byte[countLen];
                System.arraycopy(ciBytes, offset += contIdLen, countBytes, 0, countLen);
                int count = ByteUtil.bytesAsInt(countBytes);
                offset += countLen;
                offset += reservedLen;
                this.resourceContentions[i] = new ResourceContention(subsysType, subsysName, startTime, contId, count);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding" + e);
        }
    }
}

