/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields.daa;

import com.ibm.dataaccess.DecimalData;
import com.ibm.dataaccess.PackedDecimal;
import com.ibm.jzos.fields.PackedDecimalAsLongField;

public class PackedUnsignedLongField
extends PackedDecimalAsLongField {
    protected static final boolean EXCEPTIONS = false;

    public PackedUnsignedLongField(int offset, int precision) {
        super(offset, precision, false);
    }

    @Override
    public long getLong(byte[] buffer, int bufOffset) {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)this.getPrecision());
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        long value = DecimalData.convertPackedDecimalToLong((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)this.getPrecision(), (boolean)false);
        if (value < 0L) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit. value=" + value);
        }
        return value;
    }

    @Override
    public long getLong(byte[] buffer) {
        long value = DecimalData.convertPackedDecimalToLong((byte[])buffer, (int)this.getOffset(), (int)this.getPrecision(), (boolean)false);
        if (value < 0L) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return value;
    }

    @Override
    public void putLong(long value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertLongToPackedDecimal((long)value, (byte[])buffer, (int)(this.getOffset() + bufOffset), (int)this.getPrecision(), (boolean)false);
        int n = this.getOffset() + bufOffset + this.getByteLength() - 1;
        buffer[n] = (byte)(buffer[n] | 0xF);
    }

    @Override
    public void putLong(long value, byte[] buffer) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertLongToPackedDecimal((long)value, (byte[])buffer, (int)this.getOffset(), (int)this.getPrecision(), (boolean)false);
        int n = this.getOffset() + this.getByteLength() - 1;
        buffer[n] = (byte)(buffer[n] | 0xF);
    }

    @Override
    protected void rangeCheck(long value) {
        if (value < 0L || value > this.maxValue) {
            throw new IllegalArgumentException("" + value);
        }
    }
}

