/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields.daa;

import com.ibm.dataaccess.DecimalData;
import com.ibm.dataaccess.PackedDecimal;
import com.ibm.jzos.fields.PackedDecimalAsBigDecimalField;
import java.math.BigDecimal;

public class PackedBigDecimalField
extends PackedDecimalAsBigDecimalField {
    protected static final boolean EXCEPTIONS = true;

    public PackedBigDecimalField(int offset, int precision, int scale) {
        super(offset, precision, scale, true);
    }

    @Override
    public BigDecimal getBigDecimal(byte[] buffer, int bufOffset) throws IllegalArgumentException {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)this.getPrecision());
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return DecimalData.convertPackedDecimalToBigDecimal((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)this.getPrecision(), (int)this.getScale(), (boolean)true);
    }

    @Override
    public BigDecimal getBigDecimal(byte[] buffer) throws IllegalArgumentException {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)this.getOffset(), (int)this.getPrecision());
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return DecimalData.convertPackedDecimalToBigDecimal((byte[])buffer, (int)this.getOffset(), (int)this.getPrecision(), (int)this.getScale(), (boolean)true);
    }

    @Override
    public void putBigDecimal(BigDecimal value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        BigDecimal bd = value.setScale(this.getScale(), 1);
        if (bd.precision() > this.getPrecision()) {
            throw new IllegalArgumentException("" + value);
        }
        DecimalData.convertBigDecimalToPackedDecimal((BigDecimal)bd, (byte[])buffer, (int)(this.getOffset() + bufOffset), (int)this.getPrecision(), (boolean)true);
    }

    @Override
    public void putBigDecimal(BigDecimal value, byte[] buffer) throws IllegalArgumentException {
        BigDecimal bd = value.setScale(this.getScale(), 1);
        if (bd.precision() > this.getPrecision()) {
            throw new IllegalArgumentException("" + value);
        }
        DecimalData.convertBigDecimalToPackedDecimal((BigDecimal)bd, (byte[])buffer, (int)this.getOffset(), (int)this.getPrecision(), (boolean)true);
    }
}

