/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.LongAccessor;

public class PackedDecimalAsLongField
implements LongAccessor {
    private static final int MAX_PRECISION = 18;
    private static final long[] MAX_VALUES = new long[19];
    private static final byte[] PACKED_BYTES;
    private int offset;
    private int length;
    private int precision;
    private boolean signed;
    protected final long minValue;
    protected final long maxValue;

    public PackedDecimalAsLongField(int offset, int precision, boolean signed) {
        if (precision < 1 || precision > 18) {
            throw new IllegalArgumentException("length");
        }
        this.offset = offset;
        this.precision = precision;
        this.length = (precision + 2) / 2;
        this.signed = signed;
        this.maxValue = MAX_VALUES[precision];
        this.minValue = -this.maxValue;
    }

    @Override
    public int getByteLength() {
        return this.length;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public long getLong(byte[] buffer) throws IllegalArgumentException {
        return this.getLong(buffer, 0);
    }

    @Override
    public long getLong(byte[] buffer, int bufOffset) {
        int high_digit;
        int b;
        int i;
        long value = 0L;
        int ilast = i + this.length - 1;
        for (i = this.offset + bufOffset; i < ilast; ++i) {
            b = buffer[i] & 0xFF;
            high_digit = b >>> 4 & 0xF;
            int low_digit = b & 0xF;
            if (high_digit > 9 || low_digit > 9) {
                throw new IllegalArgumentException("Packed field contains invalid digit.");
            }
            value = value * 10L + (long)(b >>> 4);
            value = value * 10L + (long)(b & 0xF);
        }
        b = buffer[ilast] & 0xFF;
        high_digit = b >>> 4 & 0xF;
        if (high_digit > 9) {
            throw new IllegalArgumentException("Packed field contains invalid digit.");
        }
        value = value * 10L + (long)(b >>> 4);
        int sn = b & 0xF;
        if (sn < 10) {
            throw new IllegalArgumentException("Packed field contains invalid sign.");
        }
        if (sn == 11 || sn == 13) {
            if (!this.signed) {
                throw new IllegalArgumentException("Packed field contains invalid sign.");
            }
            value = 0L - value;
        }
        return value;
    }

    @Override
    public void putLong(long value, byte[] buffer) throws IllegalArgumentException {
        this.putLong(value, buffer, 0);
    }

    @Override
    public void putLong(long value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        int signNibble;
        if (value > this.maxValue) {
            throw new IllegalArgumentException("" + value);
        }
        if (this.signed) {
            if (value < 0L) {
                if (value < this.minValue) {
                    throw new IllegalArgumentException("" + value);
                }
                signNibble = 13;
                value = -value;
            } else {
                signNibble = 12;
            }
        } else {
            if (value < 0L) {
                throw new IllegalArgumentException("" + value);
            }
            signNibble = 15;
        }
        int ifirst = this.offset + bufOffset;
        int ilast = ifirst + this.length - 1;
        buffer[ilast] = (byte)(value % 10L << 4 | (long)signNibble);
        value /= 10L;
        for (int i = ilast - 1; i >= ifirst; --i) {
            buffer[i] = PACKED_BYTES[(int)(value % 100L)];
            value /= 100L;
        }
    }

    @Override
    public boolean isSigned() {
        return this.signed;
    }

    public boolean equals(Long aLong, long along) {
        if (aLong == null) {
            return false;
        }
        return aLong == along;
    }

    protected void rangeCheck(long value) {
        if (value < this.minValue || value > this.maxValue) {
            throw new IllegalArgumentException("" + value);
        }
    }

    static {
        long itoten = 1L;
        for (int i = 0; i < MAX_VALUES.length; ++i) {
            PackedDecimalAsLongField.MAX_VALUES[i] = itoten - 1L;
            itoten *= 10L;
        }
        PACKED_BYTES = new byte[100];
        for (int i = 0; i < 100; ++i) {
            int low = i % 10;
            int high = i / 10 % 10;
            PackedDecimalAsLongField.PACKED_BYTES[i] = (byte)((high << 4) + low);
        }
    }
}

