/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.BigIntegerAccessor;
import com.ibm.jzos.fields.PackedDecimalAsLongField;
import java.math.BigInteger;

public class PackedDecimalAsBigIntegerField
implements BigIntegerAccessor {
    private int offset;
    private int length;
    private int precision;
    private boolean signed;
    private int scale;
    private BigInteger scaleFactor;
    private PackedDecimalAsLongField longConverter;
    private long longScaleFactor = 1L;

    public PackedDecimalAsBigIntegerField(int offset, int precision, int scale, boolean signed) {
        if (precision < 1 || precision > 31) {
            throw new IllegalArgumentException("precision");
        }
        this.offset = offset;
        this.precision = precision;
        this.length = (precision + 2) / 2;
        this.signed = signed;
        this.scale = scale;
        if (scale > 0) {
            throw new IllegalArgumentException("scale must be <= 0");
        }
        if (scale < 0) {
            this.scaleFactor = BigInteger.valueOf(10L).pow(-scale);
        }
        if (precision - scale <= 18) {
            this.longConverter = new PackedDecimalAsLongField(offset, precision, signed);
            for (int i = scale; i < 0; ++i) {
                this.longScaleFactor *= 10L;
            }
        }
    }

    @Override
    public int getByteLength() {
        return this.length;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public BigInteger getBigInteger(byte[] buffer) throws IllegalArgumentException {
        return this.getBigInteger(buffer, 0);
    }

    @Override
    public BigInteger getBigInteger(byte[] buffer, int bufOffset) throws IllegalArgumentException {
        int i;
        if (this.longConverter != null) {
            long unscaledLong = this.longConverter.getLong(buffer, bufOffset);
            return BigInteger.valueOf(unscaledLong * this.longScaleFactor);
        }
        int first = this.offset + bufOffset;
        int last = first + this.length - 1;
        StringBuffer sb = new StringBuffer();
        if (this.signed) {
            int sn = buffer[last] & 0xF;
            if (sn < 10) {
                throw new IllegalArgumentException("Packed field contains invalid sign.");
            }
            if (sn == 13 || sn == 11) {
                sb.append("-");
            }
        }
        for (i = first; i < last; ++i) {
            sb.append((char)(48 + (buffer[i] >>> 4 & 0xF)));
            sb.append((char)(48 + (buffer[i] & 0xF)));
        }
        sb.append((char)(48 + (buffer[last] >>> 4 & 0xF)));
        for (i = this.scale; i < 0; ++i) {
            sb.append('0');
        }
        return new BigInteger(sb.toString());
    }

    @Override
    public void putBigInteger(BigInteger value, byte[] buffer) throws IllegalArgumentException {
        this.putBigInteger(value, buffer, 0);
    }

    @Override
    public void putBigInteger(BigInteger value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        if (this.longConverter != null) {
            long unscaledLong = value.longValue() / this.longScaleFactor;
            this.longConverter.putLong(unscaledLong, buffer, bufOffset);
            return;
        }
        if (this.scale < 0) {
            value = value.divide(this.scaleFactor);
        }
        char[] ca = value.toString().toCharArray();
        int cafirst = 0;
        int calast = ca.length - 1;
        int first = this.offset + bufOffset;
        int last = first + this.length - 1;
        byte b = (byte)(ca[calast--] - 48);
        if (this.signed) {
            if (ca[cafirst] == '-') {
                b = (byte)(b << 4 | 0xD);
                cafirst = 1;
            } else {
                b = (byte)(b << 4 | 0xC);
            }
        } else {
            if (ca[cafirst] == '-') {
                throw new IllegalArgumentException("unsigned value may not be < 0");
            }
            b = (byte)(b << 4 | 0xF);
        }
        buffer[last] = b;
        for (int i = last - 1; i >= first; --i) {
            if (calast >= cafirst) {
                int lsn = ca[calast--] - 48;
                int msn = 0;
                if (calast >= cafirst) {
                    msn = ca[calast--] - 48;
                }
                buffer[i] = (byte)(msn << 4 | lsn);
                continue;
            }
            buffer[i] = 0;
        }
        if (calast >= cafirst) {
            throw new IllegalArgumentException("" + value);
        }
    }

    public boolean equals(BigInteger a, BigInteger b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isSigned() {
        return this.signed;
    }
}

