/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.fields.DoubleAccessor;

public class IbmDoubleField
implements DoubleAccessor {
    public static final int BYTE_LENGTH = 8;
    public static final long SIGN_BIT = Long.MIN_VALUE;
    public static final long ALL_NON_SIGN_BITS = Long.MAX_VALUE;
    public static final long HFP_FRACTION_MASK = 0xFFFFFFFFFFFFFFL;
    public static final long BFP_FRACTION_MASK = 0xFFFFFFFFFFFFFL;
    public static final long BFP_FRACTION_IMPLIED_HOB = 0x10000000000000L;
    public static final long BFP_FRACTION_HON = 0xF0000000000000L;
    public static final long HFP_EXP_MASK = 0x7F00000000000000L;
    public static final long BFP_EXP_MASK = 0x7FF0000000000000L;
    public static final int HFP_FRACTION_LENGTH = 56;
    public static final int BFP_FRACTION_LENGTH = 52;
    public static final int HFP_BIAS = 64;
    public static final int HFP_MAX_EXP = 127;
    public static final int BFP_BIAS = 1023;
    public static final int BFP_INF_EXP = 2047;
    private int offset;

    public IbmDoubleField(int offset) {
        this.offset = offset;
    }

    @Override
    public int getByteLength() {
        return 8;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public double getDouble(byte[] buffer) {
        return this.getDouble(buffer, 0);
    }

    @Override
    public double getDouble(byte[] buffer, int bufOffset) {
        long hfpBits = ByteUtil.bytesAsLong(buffer, this.offset + bufOffset, 8);
        long bfpBits = this.hfp2bfp(hfpBits);
        return Double.longBitsToDouble(bfpBits);
    }

    @Override
    public void putDouble(double value, byte[] buffer) {
        this.putDouble(value, buffer, 0);
    }

    @Override
    public void putDouble(double value, byte[] buffer, int bufOffset) {
        long bfpBits = Double.doubleToLongBits(value);
        long hfpBits = this.bfp2hfp(bfpBits);
        ByteUtil.putLong(hfpBits, buffer, this.offset + bufOffset);
    }

    private long bfp2hfp(long bfpBits) {
        long sign = bfpBits & Long.MIN_VALUE;
        if ((bfpBits & Long.MAX_VALUE) == 0L) {
            return sign;
        }
        long fraction = bfpBits & 0xFFFFFFFFFFFFFL;
        int bfpExp = (int)((bfpBits & 0x7FF0000000000000L) >> 52);
        if (bfpExp == 2047) {
            return sign | 0x7F00000000000000L | 0xFFFFFFFFFFFFFFL;
        }
        if (bfpExp > 0) {
            fraction |= 0x10000000000000L;
        }
        if (bfpExp == 0 && (fraction & 0xF0000000000000L) == 0L) {
            fraction <<= 4;
            bfpExp -= 3;
        }
        fraction <<= 3;
        long hfpExp = bfpExp - 766;
        fraction >>= (int)(-hfpExp & 3L);
        hfpExp += 3L;
        hfpExp /= 4L;
        while ((fraction & 0xF0000000000000L) == 0L) {
            --hfpExp;
            fraction <<= 4;
        }
        if (hfpExp < 0L) {
            return sign;
        }
        if (hfpExp > 127L) {
            throw new IllegalArgumentException("Number too large");
        }
        return sign | hfpExp << 56 | fraction;
    }

    private long hfp2bfp(long hfpBits) {
        long sign = hfpBits & Long.MIN_VALUE;
        if ((hfpBits & Long.MAX_VALUE) == 0L) {
            return sign;
        }
        long fraction = hfpBits & 0xFFFFFFFFFFFFFFL;
        long characteristic = (hfpBits & 0x7F00000000000000L) >> 56;
        long exp = (characteristic - 64L << 2) + 1023L - 1L;
        if ((fraction >>= 3) == 0L) {
            return sign;
        }
        while ((fraction & 0x10000000000000L) == 0L) {
            --exp;
            fraction <<= 1;
        }
        if (exp <= 0L) {
            fraction = exp < -56L ? 0L : (fraction >>= (int)(-exp + 1L));
            exp = 0L;
        } else if (exp >= 2047L) {
            fraction = 0L;
            exp = 2047L;
        } else {
            fraction &= 0xFFFFFFFFFFFFFL;
        }
        return sign | exp << 52 | fraction;
    }

    public boolean equals(Double aDouble, double adouble) {
        if (aDouble == null) {
            return false;
        }
        return aDouble == adouble;
    }
}

