/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.Messages;
import com.ibm.jzos.ZUtil;
import com.ibm.jzos.fields.BinaryAsBigDecimalField;
import com.ibm.jzos.fields.BinaryAsBigIntegerField;
import com.ibm.jzos.fields.BinaryAsIntField;
import com.ibm.jzos.fields.BinaryAsLongField;
import com.ibm.jzos.fields.ByteArrayField;
import com.ibm.jzos.fields.ExternalDecimalAsBigDecimalField;
import com.ibm.jzos.fields.ExternalDecimalAsBigIntegerField;
import com.ibm.jzos.fields.ExternalDecimalAsIntField;
import com.ibm.jzos.fields.ExternalDecimalAsLongField;
import com.ibm.jzos.fields.Field;
import com.ibm.jzos.fields.IbmDoubleField;
import com.ibm.jzos.fields.IbmFloatField;
import com.ibm.jzos.fields.PackedDecimalAsBigDecimalField;
import com.ibm.jzos.fields.PackedDecimalAsBigIntegerField;
import com.ibm.jzos.fields.PackedDecimalAsIntField;
import com.ibm.jzos.fields.PackedDecimalAsLongField;
import com.ibm.jzos.fields.StringField;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Stack;

public abstract class DatatypeFactory {
    public static final String USE_DAA_PROPERTY = "com.ibm.jzos.fields.use-daa";
    private static final String DAA_FIELD_PACKAGE = "com.ibm.jzos.fields.daa";
    private static final String DAA_CLASSNAME = "com.ibm.dataaccess.DecimalData";
    private static boolean HAVE_DAA_CLASS;
    public static final boolean USE_DAA_DEFAULT;
    protected boolean useDaa = USE_DAA_DEFAULT;
    protected int offset = 0;
    protected int maximumOffset = 0;
    private Stack<Integer> offsetStack = new Stack();
    protected String stringEncoding;
    protected boolean stringTrimDefault = false;

    public int getOffset() {
        return this.offset;
    }

    public int getMaximumOffset() {
        return this.maximumOffset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.maximumOffset = Math.max(offset, this.maximumOffset);
    }

    public void pushOffset() {
        this.offsetStack.push(this.offset);
    }

    public void popOffset() {
        this.offset = this.offsetStack.pop();
    }

    public void incrementOffset(int amount) {
        this.setOffset(this.offset + amount);
    }

    protected void advanceOffset(Field field) {
        this.incrementOffset(field.getByteLength());
    }

    public String getStringEncoding() {
        return this.stringEncoding;
    }

    public boolean getStringTrimDefault() {
        return this.stringTrimDefault;
    }

    public void setStringTrimDefault(boolean value) {
        this.stringTrimDefault = value;
    }

    public void setStringEncoding(String stringEncoding) {
        this.stringEncoding = stringEncoding;
    }

    public boolean useDaa() {
        return this.useDaa;
    }

    public void setUseDaa(boolean useDaa) {
        if (!useDaa) {
            this.useDaa = false;
        } else if (HAVE_DAA_CLASS) {
            this.useDaa = true;
        } else {
            throw new IllegalStateException(Messages.getString("DatatypeFactory.DAAClassNotFound"));
        }
    }

    public BinaryAsLongField getBinaryAsLongField(int length, boolean signed) {
        BinaryAsLongField field = null;
        field = this.useDaa() ? (signed ? (BinaryAsLongField)this.constructDaaInstance("BinarySignedLongL", this.offset, length) : (BinaryAsLongField)this.constructDaaInstance("BinaryUnsignedLongL", this.offset, length)) : new BinaryAsLongField(this.offset, length, signed);
        this.advanceOffset(field);
        return field;
    }

    public BinaryAsIntField getBinaryAsIntField(int length, boolean signed) {
        BinaryAsIntField field = null;
        field = this.useDaa() ? (signed ? (BinaryAsIntField)this.constructDaaInstance("BinarySignedIntL", this.offset, length) : (BinaryAsIntField)this.constructDaaInstance("BinaryUnsignedIntL", this.offset, length)) : new BinaryAsIntField(this.offset, length, signed);
        this.advanceOffset(field);
        return field;
    }

    public BinaryAsBigIntegerField getBinaryAsBigIntegerField(int length, int scale, boolean signed) {
        BinaryAsBigIntegerField field = new BinaryAsBigIntegerField(this.offset, length, scale, signed);
        this.advanceOffset(field);
        return field;
    }

    public BinaryAsBigIntegerField getBinaryAsBigIntegerField(int length, boolean signed) {
        BinaryAsBigIntegerField field = new BinaryAsBigIntegerField(this.offset, length, 0, signed);
        this.advanceOffset(field);
        return field;
    }

    public BinaryAsBigDecimalField getBinaryAsBigDecimalField(int length, int scale, boolean signed) {
        BinaryAsBigDecimalField field = new BinaryAsBigDecimalField(this.offset, length, scale, signed);
        this.advanceOffset(field);
        return field;
    }

    public Field getBinaryField(int length, boolean signed) {
        if (length > 0 && length < 4 || length == 4 && signed) {
            return this.getBinaryAsIntField(length, signed);
        }
        if (length <= 8) {
            return this.getBinaryAsLongField(length, signed);
        }
        if (length > 8) {
            return this.getBinaryAsBigIntegerField(length, 0, signed);
        }
        throw new IllegalArgumentException("length");
    }

    public ExternalDecimalAsBigDecimalField getExternalDecimalAsBigDecimalField(int precision, int scale, boolean signed) {
        return this.getExternalDecimalAsBigDecimalField(precision, scale, signed, true, false, false);
    }

    public ExternalDecimalAsBigDecimalField getExternalDecimalAsBigDecimalField(int precision, int scale, boolean signed, boolean signTrailing, boolean signExternal, boolean blankWhenZero) {
        ExternalDecimalAsBigDecimalField field = null;
        field = this.useDaa() && signed && !blankWhenZero ? (signExternal ? (signTrailing ? (ExternalDecimalAsBigDecimalField)this.constructBigDecimalDaaInstance("ZonedExternalTrailingSignedBigDecimalP", this.offset, precision, scale) : (ExternalDecimalAsBigDecimalField)this.constructBigDecimalDaaInstance("ZonedExternalLeadingSignedBigDecimalP", this.offset, precision, scale)) : (signTrailing ? (ExternalDecimalAsBigDecimalField)this.constructBigDecimalDaaInstance("ZonedEmbeddedTrailingSignedBigDecimalP", this.offset, precision, scale) : (ExternalDecimalAsBigDecimalField)this.constructBigDecimalDaaInstance("ZonedEmbeddedLeadingSignedBigDecimalP", this.offset, precision, scale))) : new ExternalDecimalAsBigDecimalField(this.offset, precision, scale, signed, signTrailing, signExternal, blankWhenZero);
        this.advanceOffset(field);
        return field;
    }

    public ExternalDecimalAsBigIntegerField getExternalDecimalAsBigIntegerField(int precision, boolean signed) {
        return this.getExternalDecimalAsBigIntegerField(precision, 0, signed, true, false, false);
    }

    public ExternalDecimalAsBigIntegerField getExternalDecimalAsBigIntegerField(int precision, int scale, boolean signed, boolean signTrailing, boolean signExternal, boolean blankWhenZero) {
        ExternalDecimalAsBigIntegerField field = new ExternalDecimalAsBigIntegerField(this.offset, precision, scale, signed, signTrailing, signExternal, blankWhenZero);
        this.advanceOffset(field);
        return field;
    }

    public ExternalDecimalAsIntField getExternalDecimalAsIntField(int precision, boolean signed) {
        return this.getExternalDecimalAsIntField(precision, signed, true, false, false);
    }

    public ExternalDecimalAsIntField getExternalDecimalAsIntField(int precision, boolean signed, boolean signTrailing, boolean signExternal, boolean blankWhenZero) {
        ExternalDecimalAsIntField field = null;
        field = this.useDaa() && !blankWhenZero ? (!signed ? (ExternalDecimalAsIntField)this.constructDaaInstance("ZonedUnsignedIntP", this.offset, precision) : (signExternal ? (signTrailing ? (ExternalDecimalAsIntField)this.constructDaaInstance("ZonedExternalTrailingSignedIntP", this.offset, precision) : (ExternalDecimalAsIntField)this.constructDaaInstance("ZonedExternalLeadingSignedIntP", this.offset, precision)) : (signTrailing ? (ExternalDecimalAsIntField)this.constructDaaInstance("ZonedEmbeddedTrailingSignedIntP", this.offset, precision) : (ExternalDecimalAsIntField)this.constructDaaInstance("ZonedEmbeddedLeadingSignedIntP", this.offset, precision)))) : new ExternalDecimalAsIntField(this.offset, precision, signed, signTrailing, signExternal, blankWhenZero);
        this.advanceOffset(field);
        return field;
    }

    public ExternalDecimalAsLongField getExternalDecimalAsLongField(int precision, boolean signed) {
        return this.getExternalDecimalAsLongField(precision, signed, true, false, false);
    }

    public ExternalDecimalAsLongField getExternalDecimalAsLongField(int precision, boolean signed, boolean signTrailing, boolean signExternal, boolean blankWhenZero) {
        ExternalDecimalAsLongField field = null;
        field = this.useDaa() && !blankWhenZero ? (!signed ? (ExternalDecimalAsLongField)this.constructDaaInstance("ZonedUnsignedLongP", this.offset, precision) : (signExternal ? (signTrailing ? (ExternalDecimalAsLongField)this.constructDaaInstance("ZonedExternalTrailingSignedLongP", this.offset, precision) : (ExternalDecimalAsLongField)this.constructDaaInstance("ZonedExternalLeadingSignedLongP", this.offset, precision)) : (signTrailing ? (ExternalDecimalAsLongField)this.constructDaaInstance("ZonedEmbeddedTrailingSignedLongP", this.offset, precision) : (ExternalDecimalAsLongField)this.constructDaaInstance("ZonedEmbeddedLeadingSignedLongP", this.offset, precision)))) : new ExternalDecimalAsLongField(this.offset, precision, signed, signTrailing, signExternal, blankWhenZero);
        this.advanceOffset(field);
        return field;
    }

    public Field getExternalDecimalField(int precision, int scale, boolean signed, boolean signTailing, boolean signExternal, boolean blankWhenZero) {
        if (scale > 0) {
            return this.getExternalDecimalAsBigDecimalField(precision, scale, signed, signTailing, signExternal, blankWhenZero);
        }
        if (scale < 0) {
            return this.getExternalDecimalAsBigIntegerField(precision, scale, signed, signTailing, signExternal, blankWhenZero);
        }
        if (precision <= 9) {
            return this.getExternalDecimalAsIntField(precision, signed, signTailing, signExternal, blankWhenZero);
        }
        if (precision <= 18) {
            return this.getExternalDecimalAsLongField(precision, signed, signTailing, signExternal, blankWhenZero);
        }
        if (precision <= 31) {
            return this.getExternalDecimalAsBigIntegerField(precision, scale, signed, signTailing, signExternal, blankWhenZero);
        }
        throw new IllegalArgumentException("precision too big");
    }

    public ByteArrayField getByteArrayField(int length) {
        ByteArrayField field = new ByteArrayField(this.offset, length);
        this.advanceOffset(field);
        return field;
    }

    public IbmFloatField getIbmFloatField() {
        IbmFloatField field = new IbmFloatField(this.offset);
        this.advanceOffset(field);
        return field;
    }

    public IbmDoubleField getIbmDoubleField() {
        IbmDoubleField field = new IbmDoubleField(this.offset);
        this.advanceOffset(field);
        return field;
    }

    public PackedDecimalAsBigDecimalField getPackedDecimalAsBigDecimalField(int precision, int scale, boolean signed) {
        PackedDecimalAsBigDecimalField field = null;
        field = this.useDaa() && signed ? (PackedDecimalAsBigDecimalField)this.constructBigDecimalDaaInstance("PackedBigDecimalP", this.offset, precision, scale) : new PackedDecimalAsBigDecimalField(this.offset, precision, scale, signed);
        this.advanceOffset(field);
        return field;
    }

    public PackedDecimalAsBigIntegerField getPackedDecimalAsBigIntegerField(int precision, int scale, boolean signed) {
        PackedDecimalAsBigIntegerField field = new PackedDecimalAsBigIntegerField(this.offset, precision, scale, signed);
        this.advanceOffset(field);
        return field;
    }

    public PackedDecimalAsIntField getPackedDecimalAsIntField(int precision, boolean signed) {
        PackedDecimalAsIntField field = null;
        field = this.useDaa() ? (signed ? (PackedDecimalAsIntField)this.constructDaaInstance("PackedSignedIntP", this.offset, precision) : (PackedDecimalAsIntField)this.constructDaaInstance("PackedUnsignedIntP", this.offset, precision)) : new PackedDecimalAsIntField(this.offset, precision, signed);
        this.advanceOffset(field);
        return field;
    }

    public PackedDecimalAsLongField getPackedDecimalAsLongField(int precision, boolean signed) {
        PackedDecimalAsLongField field = null;
        field = this.useDaa() ? (signed ? (PackedDecimalAsLongField)this.constructDaaInstance("PackedSignedLongP", this.offset, precision) : (PackedDecimalAsLongField)this.constructDaaInstance("PackedUnsignedLongP", this.offset, precision)) : new PackedDecimalAsLongField(this.offset, precision, signed);
        this.advanceOffset(field);
        return field;
    }

    public abstract Field getPackedDecimalField(int var1, int var2, boolean var3);

    public StringField getStringField(int length) {
        StringField field = new StringField(this.offset, length, this.getStringTrimDefault());
        field.setEncoding(this.stringEncoding);
        this.advanceOffset(field);
        return field;
    }

    public StringField getStringField(int length, boolean trim) {
        StringField field = new StringField(this.offset, length, trim);
        field.setEncoding(this.stringEncoding);
        this.advanceOffset(field);
        return field;
    }

    public StringField getStringField(int length, boolean trim, boolean padLeft, boolean allowTruncation, String encoding) {
        StringField field = new StringField(this.offset, length, trim, padLeft, allowTruncation);
        field.setEncoding(encoding);
        this.advanceOffset(field);
        return field;
    }

    public StringField getStringField(int length, boolean trim, boolean padLeft, boolean allowTruncation) {
        StringField field = new StringField(this.offset, length, trim, padLeft, allowTruncation);
        field.setEncoding(this.stringEncoding);
        this.advanceOffset(field);
        return field;
    }

    public StringField getStringField(int length, boolean trim, boolean padLeft) {
        StringField field = new StringField(this.offset, length, trim, padLeft);
        field.setEncoding(this.stringEncoding);
        this.advanceOffset(field);
        return field;
    }

    private Object constructDaaInstance(String basename, int offset, int length) {
        String classname = "com.ibm.jzos.fields.daa." + basename + length + "Field";
        String supername = "com.ibm.jzos.fields.daa." + basename.substring(0, basename.length() - 1) + "Field";
        Class<?> clazz = null;
        Object instance = null;
        try {
            clazz = Class.forName(classname);
            Constructor<?> ctor = clazz.getConstructor(Integer.TYPE);
            instance = ctor.newInstance(offset);
        }
        catch (InvocationTargetException ite1) {
            this.throwRuntimeException(ite1.getTargetException());
        }
        catch (Exception e1) {
            try {
                clazz = Class.forName(supername);
                Constructor<?> ctor = clazz.getConstructor(Integer.TYPE, Integer.TYPE);
                instance = ctor.newInstance(offset, length);
            }
            catch (InvocationTargetException ite2) {
                this.throwRuntimeException(ite2.getTargetException());
            }
            catch (Exception e2) {
                this.throwRuntimeException(e2);
            }
        }
        return instance;
    }

    private Object constructBigDecimalDaaInstance(String basename, int offset, int precision, int scale) {
        String classname = "com.ibm.jzos.fields.daa." + basename + precision + "Field";
        String supername = "com.ibm.jzos.fields.daa." + basename.substring(0, basename.length() - 1) + "Field";
        Class<?> clazz = null;
        Object instance = null;
        try {
            clazz = Class.forName(classname);
            Constructor<?> ctor = clazz.getConstructor(Integer.TYPE, Integer.TYPE);
            instance = ctor.newInstance(offset, scale);
        }
        catch (InvocationTargetException ite1) {
            this.throwRuntimeException(ite1.getTargetException());
        }
        catch (Exception e1) {
            try {
                clazz = Class.forName(supername);
                Constructor<?> ctor = clazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                instance = ctor.newInstance(offset, precision, scale);
            }
            catch (InvocationTargetException ite2) {
                this.throwRuntimeException(ite2.getTargetException());
            }
            catch (Exception e2) {
                this.throwRuntimeException(e2);
            }
        }
        return instance;
    }

    private void throwRuntimeException(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    static {
        block2: {
            HAVE_DAA_CLASS = false;
            try {
                Class.forName(DAA_CLASSNAME);
                HAVE_DAA_CLASS = true;
            }
            catch (Throwable throwable) {
                boolean onZOS;
                boolean bl = onZOS = System.getProperty("os.name").indexOf("z/OS") >= 0;
                if (!onZOS) break block2;
                ZUtil.logDiagnostic(3, Messages.getString("DatatypeFactory.DAAClassNotFound"));
            }
        }
        USE_DAA_DEFAULT = HAVE_DAA_CLASS && System.getProperty(USE_DAA_PROPERTY, "true").equalsIgnoreCase("true");
    }
}

