/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.Field;
import java.util.Arrays;

public class ByteArrayField
implements Field {
    private int offset;
    private int length;

    public ByteArrayField(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int getByteLength() {
        return this.length;
    }

    public void setByteLength(int len) {
        this.length = len;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    public byte[] getByteArray(byte[] buffer) {
        return this.getByteArray(buffer, 0);
    }

    public byte[] getByteArray(byte[] buffer, int bufOffset) {
        byte[] result = new byte[this.length];
        System.arraycopy(buffer, bufOffset + this.offset, result, 0, this.length);
        return result;
    }

    public void putByteArray(byte[] valueBytes, byte[] buffer) {
        this.putByteArray(valueBytes, 0, buffer, 0);
    }

    public void putByteArray(byte[] valueBytes, int valueBytesOffset, byte[] buffer) {
        this.putByteArray(valueBytes, valueBytesOffset, buffer, 0);
    }

    public void putByteArray(byte[] valueBytes, byte[] buffer, int bufOffset) {
        this.putByteArray(valueBytes, 0, buffer, bufOffset);
    }

    public void putByteArray(byte[] valueBytes, int valueBytesOffset, byte[] buffer, int bufOffset) {
        int start = bufOffset + this.offset;
        int valueLen = valueBytes.length - valueBytesOffset;
        if (valueLen > this.length) {
            valueLen = this.length;
        }
        System.arraycopy(valueBytes, valueBytesOffset, buffer, start, valueLen);
        if (valueLen < this.length) {
            for (int i = start + valueLen; i < start + this.length; ++i) {
                buffer[i] = 0;
            }
        }
    }

    public boolean equals(byte[] ba1, byte[] ba2) {
        return Arrays.equals(ba1, ba2);
    }
}

